/******************************************************************************
 *                                                                            *
 * File:   tab     .h         Version  1.12            Date: 1997-05-01       *
 *                                                                            *
 * Copyright (C) 1993-1997 by kostis@acm.org (Kosta Kostis)                   *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *     1997-05-01: KK V1.12                                                   *
 *        - see transtab.c                                                    *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************

	Program Constants

 *****************************************************************************/

/* this is the ISO/IEC 10646-1:1993 name for the NO-BREAK SPACE character    */
#define ISO_NO_BREAK_SPACE      "NO-BREAK SPACE"

/* max. length for ISO/IEC 10646-1:1993 character names (plus a few)         */
#define MAX_ISO_NAME_LENGTH     100

/* max. length for a Character Encoding Name                                 */
#define MAX_ENC_NAME_LENGTH     80

/* max. length for a Comment Line                                            */
#define MAX_COMMENT_LENGTH      80

/* number of entries in an 8-bit character encoding                          */
#define MAX_TABLE_ENTRIES       256

/* number of entries in the Unicode 1.1 name table (incl. extra chars)       */
#define	ISO_TABLE_ENTRIES	13029

/* DEF_ISONAME is the (relative) filename containing all Unicode 1.1 names   */
#define DEF_ISONAME             "iso10646"

/* this is a default value for NO-BREAK SPACE (IBM Codepage value)           */
#define DEF_NO_BREAK_SPACE      255

/* BAD is an illegal ISO/IEC 10646-1:1993 value                              */
#define BAD                     0xFFFE

/* number of codes per line in the unsigned int array (table output)         */
#define MAX_CODES_PER_LINE      8

/* number of comment lines in a Character Encoding Description File          */
#define MAX_COMMENTS            3

/* environment variable for supplying directory path                         */
#define	ENV_TRANS		"TRANS"

/* ISO10646 names starting with this string aren't valid but for internal use*/
#define	STR_NC			"NC"

/* these are pointers to some program information strings (main program)     */
extern	char	*PRGNAM ;
extern	char	*VERSION ;

/******************************************************************************

	Output Filename Extensions

 *****************************************************************************/

#define	EXT_BINARY		"%sxlt%c%s"
#define	EXT_TABLE		"%s.tab"
#define	EXT_UNICODE_A		"%s.txt"
#define	EXT_C			"%s.c"
#define	EXT_H			"%s.h"
