/******************************************************************************
 *                                                                            *
 * File:   strdup  .c         Version  1.00            Date: 1993-05-25       *
 *                                                                            *
 * Copyright (C) 1993-1997 by kostis@acm.org (Kosta Kostis)                   *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *     1993-05-25: KK V1.00                                                   *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "strdup.h"

/******************************************************************************

	Function:
		copy one string into newly allocated memory

	Parameters:
		char    *s		source string

	Returns:
		NULL                    if there's an error
		char    *               pointer to memory holding copy

 *****************************************************************************/

char    *strdup
(
	char    *s
)
{
	char    *p ;

	if (s == (char *) NULL)
		return ((char *) NULL) ;

	p = malloc (strlen (s) + 1) ;
	if (p == (char *) NULL)
		return ((char *) NULL) ;

	return (strcpy (p, s)) ;
}
