;;; bib-konvers.el --- conversion of text; requires konvers.el

;; Copyright (C) 1994 Karl Brodowsky, Volker Kunert
;; Author: Karl Brodowsky <bro@clio.iwr.uni-heidelberg.de>
;;	Volker Kunert <Volker.Kunert@numsun1.mathematik.uni-halle.de>
;; Maintainer: Karl Brodowsky <bro@clio.iwr.uni-heidelberg.de>
;; Version: 0.911
;; Keywords: i18n, tex, wp

;; This file was written for GNU Emacs version 19

;; It is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; It is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Commentary:

;; created December 1993
;; last changed 10. May 1995
;; requires konvers.el (Version 0.860 or newer).
;;
;; WARNING:  THIS FILE CONTAINS 8-BIT CHARACTERS.  
;; MAKE SURE IT HAS BEEN TRANSFERRED IN BINARY MODE!!!
;; DO NOT CONVERT THIS FILE.
;;
;; ACHTUNG:  DIESE DATEI ENTHLT 8-BIT-ZEICHEN.
;; STELLEN SIE SICHER, DASZ SIE BINR BERTRAGEN WORDEN IST.
;; DIESE DATEI VERTRGT KEINE KONVERTIERUNG.
;;
;; It provides conversion for different character sets
;;
;; iso    --> bibtex ({\"a}{\"o}...)
;;
;; C-x 7 b   konvers-iso-to-bibtex		; converts region
;; C-x 7 B   konvers-buffer-iso-to-bibtex	; converts buffer to bibTeX
;; M-x bibtex-type-mode 			; toggle bibtex-type-mode
;; 						; use prefix C-u to turn it on
;;
;; Or insert the following into .emacs:
;;  (add-hook 'bibtex-mode-hook
;;   (function (lambda () (bibtex-type-mode t))))

;;; Code:

(require 'iso-konvers)


(defvar konvers-iso-to-bibtex-alist nil
  "alist describing the replacements for converion iso to seven bit TeX")

(setq konvers-iso-to-bibtex-alist
      (append
       '(
	 ("" . "{\\`A}")
	 ("" . "{\\'A}")
	 ("" . "{\\^A}")
	 ("" . "{\\~A}")
	 ("" . "{\\\"A}")
	 ("" . "{\\AA}")
	 ("" . "{\\AE}")
	 ("" . "{\\CC}")
	 ("" . "{\\`E}")
	 ("" . "{\\'E}")
	 ("" . "{\\^E}")
	 ("" . "{\\\"E}")
	 ("" . "{\\`I}")
	 ("" . "{\\'I}")
	 ("" . "{\\^I}")
	 ("" . "{\\\"I}")
	 ("" . "{\\~N}")
	 ("" . "{\\`O}")
	 ("" . "{\\'O}")
	 ("" . "{\\^O}")
	 ("" . "{\\~O}")
	 ("" . "{\\\"O}")
	 ("" . "{\\O}")
	 ("" . "{\\`U}")
	 ("" . "{\\'U}")
	 ("" . "{\\^U}")
	 ("" . "{\\\"U}")
	 ("" . "{\\'Y}")
	 ("" . "{\\ss}")
	 ("" . "{\\`a}")
	 ("" . "{\\'a}")
	 ("" . "{\\^a}")
	 ("" . "{\\~a}")
	 ("" . "{\\\"a}")
	 ("" . "{\\aa}")
	 ("" . "{\\ae}")
	 ("" . "{\\cc}")
	 ("" . "{\\`e}")
	 ("" . "{\\'e}")
	 ("" . "{\\^e}")
	 ("" . "{\\\"e}")
	 ("" . "{\\`\\i}")
	 ("" . "{\\'\\i}")
	 ("" . "{\\^\\i}")
	 ("" . "{\\\"\\i}")
	 ("" . "{\\~n}")
	 ("" . "{\\`o}")
	 ("" . "{\\'o}")
	 ("" . "{\\^o}")
	 ("" . "{\\~o}")
	 ("" . "{\\\"o}")
	 ("" . "{\\o}")
	 ("" . "{\\`u}")
	 ("" . "{\\'u}")
	 ("" . "{\\^u}")
	 ("" . "{\\\"u}")
	 ("" . "{\\'y}")
	 ("" . "{\\\"y}"))
       konvers-iso-to-seven-bit-tex-alist)) ; konvers-iso-to-bibtex-alist



(defvar bibtex-type-map nil
  "minor mode key map for bibtex-type-mode")

(setq bibtex-type-map (konvers-make-seven-bit-type-map
		       konvers-iso-to-bibtex-alist))  ; changed (K.B. May 10 1995)

;; build a keymap defining the keys of iso-8-bit-characters with macros
;; that insert exactly the substitution the conversion would produce.


(defun konvers-iso-to-bibtex (from to)
  "Transforms ISO Latin letters to bibTeX."
  (interactive "*r")
  (konvers-replace-string-set from to konvers-iso-to-bibtex-alist))

(defun konvers-buffer-iso-to-bibtex (&optional arg)
  "convert full buffer from ISO to bibTeX,
iff ARG ist non-nil ommit Mail/News-Header.
This option is included for sake of orthogonality since it is
implemented in all buffer conversion functions of konvers.el" 
  (interactive "*P")
  (konvers-iso-to-bibtex (konvers-point-min-or-behind-header arg) (point-max)))


(defvar bibtex-type-mode nil
  "Non-nil iff eight-bit characters should insert seven-bit Bibtex sequences.
If non-nil eight-bit non-ascii characters do not selfinsert but insert
a seven bit sequence as replacement which is taken from TeX where
possible and  which has the form \\iso<decimal number> otherwise.")

(make-variable-buffer-local 'bibtex-type-mode)


(defun bibtex-type-mode (&optional arg)
  "Toggle bibtex-type-mode, turn off german-tex-type-mode 
   and seven-bit-tex-type-mode.
With arg, turn bibtex-type-mode on iff arg is positive.
In bibtex-type-mode typing of ISO-characters results in inserting
the corresponding seven Bit BibTeX sequences."
  (interactive "P")
  (let ((temp-bibtex-type-mode
	(if (null arg) (not bibtex-type-mode)
	  (> (prefix-numeric-value arg) 0))))
    (no-seven-type-mode)
	; mit bibtex-type-mode unvertrgliche Minor-Modi (und
	; bibtex-type-mode selbst) werden smtliche durch
	; no-seven-type-mode abgeschaltet.
    (setq bibtex-type-mode temp-bibtex-type-mode)
    (if bibtex-type-mode 
	(setq konvers-seven-bit-type-alist 
	      konvers-iso-to-bibtex-alist))
	; danach wird bibtex-type-mode sinngem zugewiesen.
  (set-buffer-modified-p (buffer-modified-p)))) ;No-op, but updates mode line.


(or (assq 'bibtex-type-mode minor-mode-alist)
    (setq minor-mode-alist 
	  (cons '(bibtex-type-mode " bt7" t) 
		minor-mode-alist)
	  minor-mode-map-alist
	  (cons (cons 'bibtex-type-mode
		      bibtex-type-map)
		minor-mode-map-alist)))


(define-key ctl-x-map [?7 ?b] 'konvers-iso-to-bibtex)
(define-key ctl-x-map [?7 ?B] 'konvers-buffer-iso-to-bibtex)
;; C-x 7 a 
;; would be the key combination for turning on bibtex-type-mode, but
;; since bibtex-type-mode is normally used only in combination with
;; bibtex-mode it does not seem necessary to provide it.  The
;; suggested hook will work fine and C-x 7 A and C-x 7 a can be
;; reserved for the conversion iso2asc, which is not implemented yet.

(provide 'bib-konvers)

;;; bib-konvers.el ends here
