/******************************************************************************
 *                                                                            *
 * File:   codepage.c         Version  1.20            Date: 1996-08-25       *
 *                                                                            *
 * Copyright (C) 1993-1996 by kostis@acm.org (Kosta Kostis)                   *
 * This program may be used free of charge at your own risk.                  *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * Function:                                                                  *
 *        - figure out active Codepage for device CON:                        *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *     1996-08-25: KK V1.20                                                   *
 *        - internal cosmetic changes                                         *
 *     1994-10-14: KK V1.12                                                   *
 *        - changed email address                                             *
 *     1993-10-15: KK V1.10                                                   *
 *        - corrected bug if no MODE CON has taken place                      *
 *     1993-08-08: KK V1.03                                                   *
 *        - eased inclusion                                                   *
 *     1993-07-18: KK V1.02                                                   *
 *        - corrected bug for HGC etc.                                        *
 *     1993-06-12: KK V1.01                                                   *
 *        - now only looking at device CON:                                   *
 *     1993-05-25: KK V1.00                                                   *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include <dos.h>

#include "codepage.h"

/******************************************************************************

	Function:
		figure out DOS version

	Parameters:
		none

	Returns:
		DOS version in BCD format (eg. 0x0330 is version 3.30)

 *****************************************************************************/

static  int     DOS_Version (void)
{
	union   REGS    cpuregs ;

	cpuregs.x.ax = DOS_GETVER ;
	intdos (&cpuregs, &cpuregs) ;

	return (256 * cpuregs.h.al + cpuregs.h.ah) ;
}

/******************************************************************************

	Function:
		figure out current Code Page

	Parameters:
		none

	Returns:
		Code Page (in decimal)

 *****************************************************************************/

int     CodePage (void)
{
	union   REGS    cpuregs ;
	CODEPAGE	cp		= { 2, 0 } ;

	if (DOS_Version () < MIN_DOSVER) /* DOS too old, use default         */
		return (DEF_CODEPAGE) ;

	cpuregs.x.ax = DOS_IOCTL ;
	cpuregs.h.cl = DOS_IOCTL_GETCP ;
	cpuregs.h.ch = CATEGORY_CON ;
	cpuregs.x.bx = HANDLE_CON ;
	cpuregs.x.dx = (unsigned int) &cp ;	// this is *very* hacky
	intdos (&cpuregs, &cpuregs) ;

	if ((cp.cpId == CODEPAGE_UNKNOWN) || (cp.cpId == CODEPAGE_INVALID))
		return (DEF_CODEPAGE) ;

	return (cp.cpId) ;
}

#ifdef	USE_MAIN

#include <stdio.h>

void	main (void)
{
	printf ("Copyright (C) 1993-1996 by kostis@acm.org (Kosta Kostis)\n") ;
	printf ("This program may be used free of charge at your own risk.\n") ;
	printf ("Codepage V1.20 (1996-08-25)\n") ;
	printf ("Active Codepage for device CON: is %u\n", CodePage ()) ;
}

#endif
