#include	"ksc.h"

/* KSC5601 -> Unicode mapping table, compressed for the 94*94 codeset. */
/* 
 * Unlike kuten-table, needed offset is 33 (0x21) instead of
 * 32 for 7-bit portion of each byte.  i.e., a Unicode
 * codepoint for KSC's codepoint (n, m) would be found at
 * index (n-33)*94+m.
 */
long tabksc5601[] = {
/* KSC 5601 -> Unicode mapping table; max codepoint = 0x7d7e */
	0x3000, 0x3001, 0x3002, 0x00b7, 0x2025, 0x2026, 0x00a8, 0x3003, 0x00ad, 
	0x2015, 0x2225, 0xff3c, 0x223c, 0x2018, 0x2019, 0x201c, 0x201d, 0x3014, 
	0x3015, 0x3008, 0x3009, 0x300a, 0x300b, 0x300c, 0x300d, 0x300e, 0x300f, 
	0x3010, 0x3011, 0x00b1, 0x00d7, 0x00f7, 0x2260, 0x2264, 0x2265, 0x221e, 
	0x2234, 0x00b0, 0x2032, 0x2033, 0x2103, 0x212b, 0xffe0, 0xffe1, 0xffe5, 
	0x2642, 0x2640, 0x2220, 0x22a5, 0x2312, 0x2202, 0x2207, 0x2261, 0x2252, 
	0x00a7, 0x203b, 0x2606, 0x2605, 0x25cb, 0x25cf, 0x25ce, 0x25c7, 0x25c6, 
	0x25a1, 0x25a0, 0x25b3, 0x25b2, 0x25bd, 0x25bc, 0x2192, 0x2190, 0x2191, 
	0x2193, 0x2194, 0x3013, 0x226a, 0x226b, 0x221a, 0x223d, 0x221d, 0x2235, 
	0x222b, 0x222c, 0x2208, 0x220b, 0x2286, 0x2287, 0x2282, 0x2283, 0x222a, 
	0x2229, 0x2227, 0x2228, 0xffe2, 0x21d2, 0x21d4, 0x2200, 0x2203, 0x00b4, 
	0xff5e, 0x02c7, 0x02d8, 0x02dd, 0x02da, 0x02d9, 0x00b8, 0x02db, 0x00a1, 
	0x00bf, 0x02d0, 0x222e, 0x2211, 0x220f, 0x00a4, 0x2109, 0x2030, 0x25c1, 
	0x25c0, 0x25b7, 0x25b6, 0x2664, 0x2660, 0x2661, 0x2665, 0x2667, 0x2663, 
	0x25c9, 0x25c8, 0x25a3, 0x25d0, 0x25d1, 0x2592, 0x25a4, 0x25a5, 0x25a8, 
	0x25a7, 0x25a6, 0x25a9, 0x2668, 0x260f, 0x260e, 0x261c, 0x261e, 0x00b6, 
	0x2020, 0x2021, 0x2195, 0x2197, 0x2199, 0x2196, 0x2198, 0x266d, 0x2669, 
	0x266a, 0x266c, 0x327f, 0x321c, 0x2116, 0x33c7, 0x2122, 0x33c2, 0x33d8, 
	0x2121,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 0xff01, 
	0xff02, 0xff03, 0xff04, 0xff05, 0xff06, 0xff07, 0xff08, 0xff09, 0xff0a, 
	0xff0b, 0xff0c, 0xff0d, 0xff0e, 0xff0f, 0xff10, 0xff11, 0xff12, 0xff13, 
	0xff14, 0xff15, 0xff16, 0xff17, 0xff18, 0xff19, 0xff1a, 0xff1b, 0xff1c, 
	0xff1d, 0xff1e, 0xff1f, 0xff20, 0xff21, 0xff22, 0xff23, 0xff24, 0xff25, 
	0xff26, 0xff27, 0xff28, 0xff29, 0xff2a, 0xff2b, 0xff2c, 0xff2d, 0xff2e, 
	0xff2f, 0xff30, 0xff31, 0xff32, 0xff33, 0xff34, 0xff35, 0xff36, 0xff37, 
	0xff38, 0xff39, 0xff3a, 0xff3b, 0xffe6, 0xff3d, 0xff3e, 0xff3f, 0xff40, 
	0xff41, 0xff42, 0xff43, 0xff44, 0xff45, 0xff46, 0xff47, 0xff48, 0xff49, 
	0xff4a, 0xff4b, 0xff4c, 0xff4d, 0xff4e, 0xff4f, 0xff50, 0xff51, 0xff52, 
	0xff53, 0xff54, 0xff55, 0xff56, 0xff57, 0xff58, 0xff59, 0xff5a, 0xff5b, 
	0xff5c, 0xff5d, 0xffe3, 0x3131, 0x3132, 0x3133, 0x3134, 0x3135, 0x3136, 
	0x3137, 0x3138, 0x3139, 0x313a, 0x313b, 0x313c, 0x313d, 0x313e, 0x313f, 
	0x3140, 0x3141, 0x3142, 0x3143, 0x3144, 0x3145, 0x3146, 0x3147, 0x3148, 
	0x3149, 0x314a, 0x314b, 0x314c, 0x314d, 0x314e, 0x314f, 0x3150, 0x3151, 
	0x3152, 0x3153, 0x3154, 0x3155, 0x3156, 0x3157, 0x3158, 0x3159, 0x315a, 
	0x315b, 0x315c, 0x315d, 0x315e, 0x315f, 0x3160, 0x3161, 0x3162, 0x3163, 
	0x3164, 0x3165, 0x3166, 0x3167, 0x3168, 0x3169, 0x316a, 0x316b, 0x316c, 
	0x316d, 0x316e, 0x316f, 0x3170, 0x3171, 0x3172, 0x3173, 0x3174, 0x3175, 
	0x3176, 0x3177, 0x3178, 0x3179, 0x317a, 0x317b, 0x317c, 0x317d, 0x317e, 
	0x317f, 0x3180, 0x3181, 0x3182, 0x3183, 0x3184, 0x3185, 0x3186, 0x3187, 
	0x3188, 0x3189, 0x318a, 0x318b, 0x318c, 0x318d, 0x318e, 0x2170, 0x2171, 
	0x2172, 0x2173, 0x2174, 0x2175, 0x2176, 0x2177, 0x2178, 0x2179,     -1, 
	    -1,     -1,     -1,     -1, 0x2160, 0x2161, 0x2162, 0x2163, 0x2164, 
	0x2165, 0x2166, 0x2167, 0x2168, 0x2169,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1, 0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 
	0x0397, 0x0398, 0x0399, 0x039a, 0x039b, 0x039c, 0x039d, 0x039e, 0x039f, 
	0x03a0, 0x03a1, 0x03a3, 0x03a4, 0x03a5, 0x03a6, 0x03a7, 0x03a8, 0x03a9, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 0x03b1, 
	0x03b2, 0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7, 0x03b8, 0x03b9, 0x03ba, 
	0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf, 0x03c0, 0x03c1, 0x03c3, 0x03c4, 
	0x03c5, 0x03c6, 0x03c7, 0x03c8, 0x03c9,     -1,     -1,     -1,     -1, 
	    -1,     -1, 0x2500, 0x2502, 0x250c, 0x2510, 0x2518, 0x2514, 0x251c, 
	0x252c, 0x2524, 0x2534, 0x253c, 0x2501, 0x2503, 0x250f, 0x2513, 0x251b, 
	0x2517, 0x2523, 0x2533, 0x252b, 0x253b, 0x254b, 0x2520, 0x252f, 0x2528, 
	0x2537, 0x253f, 0x251d, 0x2530, 0x2525, 0x2538, 0x2542, 0x2512, 0x2511, 
	0x251a, 0x2519, 0x2516, 0x2515, 0x250e, 0x250d, 0x251e, 0x251f, 0x2521, 
	0x2522, 0x2526, 0x2527, 0x2529, 0x252a, 0x252d, 0x252e, 0x2531, 0x2532, 
	0x2535, 0x2536, 0x2539, 0x253a, 0x253d, 0x253e, 0x2540, 0x2541, 0x2543, 
	0x2544, 0x2545, 0x2546, 0x2547, 0x2548, 0x2549, 0x254a,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1, 0x3395, 0x3396, 0x3397, 
	0x2113, 0x3398, 0x33c4, 0x33a3, 0x33a4, 0x33a5, 0x33a6, 0x3399, 0x339a, 
	0x339b, 0x339c, 0x339d, 0x339e, 0x339f, 0x33a0, 0x33a1, 0x33a2, 0x33ca, 
	0x338d, 0x338e, 0x338f, 0x33cf, 0x3388, 0x3389, 0x33c8, 0x33a7, 0x33a8, 
	0x33b0, 0x33b1, 0x33b2, 0x33b3, 0x33b4, 0x33b5, 0x33b6, 0x33b7, 0x33b8, 
	0x33b9, 0x3380, 0x3381, 0x3382, 0x3383, 0x3384, 0x33ba, 0x33bb, 0x33bc, 
	0x33bd, 0x33be, 0x33bf, 0x3390, 0x3391, 0x3392, 0x3393, 0x3394, 0x2126, 
	0x33c0, 0x33c1, 0x338a, 0x338b, 0x338c, 0x33d6, 0x33c5, 0x33ad, 0x33ae, 
	0x33af, 0x33db, 0x33a9, 0x33aa, 0x33ab, 0x33ac, 0x33dd, 0x33d0, 0x33d3, 
	0x33c3, 0x33c9, 0x33dc, 0x33c6,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1, 0x00c6, 0x00d0, 0x00aa, 0x0126,     -1, 0x0132,     -1, 0x013f, 
	0x0141, 0x00d8, 0x0152, 0x00ba, 0x00de, 0x0166, 0x014a,     -1, 0x3260, 
	0x3261, 0x3262, 0x3263, 0x3264, 0x3265, 0x3266, 0x3267, 0x3268, 0x3269, 
	0x326a, 0x326b, 0x326c, 0x326d, 0x326e, 0x326f, 0x3270, 0x3271, 0x3272, 
	0x3273, 0x3274, 0x3275, 0x3276, 0x3277, 0x3278, 0x3279, 0x327a, 0x327b, 
	0x24d0, 0x24d1, 0x24d2, 0x24d3, 0x24d4, 0x24d5, 0x24d6, 0x24d7, 0x24d8, 
	0x24d9, 0x24da, 0x24db, 0x24dc, 0x24dd, 0x24de, 0x24df, 0x24e0, 0x24e1, 
	0x24e2, 0x24e3, 0x24e4, 0x24e5, 0x24e6, 0x24e7, 0x24e8, 0x24e9, 0x2460, 
	0x2461, 0x2462, 0x2463, 0x2464, 0x2465, 0x2466, 0x2467, 0x2468, 0x2469, 
	0x246a, 0x246b, 0x246c, 0x246d, 0x246e, 0x00bd, 0x2153, 0x2154, 0x00bc, 
	0x00be, 0x215b, 0x215c, 0x215d, 0x215e, 0x00e6, 0x0111, 0x00f0, 0x0127, 
	0x0131, 0x0133, 0x0138, 0x0140, 0x0142, 0x00f8, 0x0153, 0x00df, 0x00fe, 
	0x0167, 0x014b, 0x0149, 0x3200, 0x3201, 0x3202, 0x3203, 0x3204, 0x3205, 
	0x3206, 0x3207, 0x3208, 0x3209, 0x320a, 0x320b, 0x320c, 0x320d, 0x320e, 
	0x320f, 0x3210, 0x3211, 0x3212, 0x3213, 0x3214, 0x3215, 0x3216, 0x3217, 
	0x3218, 0x3219, 0x321a, 0x321b, 0x249c, 0x249d, 0x249e, 0x249f, 0x24a0, 
	0x24a1, 0x24a2, 0x24a3, 0x24a4, 0x24a5, 0x24a6, 0x24a7, 0x24a8, 0x24a9, 
	0x24aa, 0x24ab, 0x24ac, 0x24ad, 0x24ae, 0x24af, 0x24b0, 0x24b1, 0x24b2, 
	0x24b3, 0x24b4, 0x24b5, 0x2474, 0x2475, 0x2476, 0x2477, 0x2478, 0x2479, 
	0x247a, 0x247b, 0x247c, 0x247d, 0x247e, 0x247f, 0x2480, 0x2481, 0x2482, 
	0x00b9, 0x00b2, 0x00b3, 0x2074, 0x207f, 0x2081, 0x2082, 0x2083, 0x2084, 
	0x3041, 0x3042, 0x3043, 0x3044, 0x3045, 0x3046, 0x3047, 0x3048, 0x3049, 
	0x304a, 0x304b, 0x304c, 0x304d, 0x304e, 0x304f, 0x3050, 0x3051, 0x3052, 
	0x3053, 0x3054, 0x3055, 0x3056, 0x3057, 0x3058, 0x3059, 0x305a, 0x305b, 
	0x305c, 0x305d, 0x305e, 0x305f, 0x3060, 0x3061, 0x3062, 0x3063, 0x3064, 
	0x3065, 0x3066, 0x3067, 0x3068, 0x3069, 0x306a, 0x306b, 0x306c, 0x306d, 
	0x306e, 0x306f, 0x3070, 0x3071, 0x3072, 0x3073, 0x3074, 0x3075, 0x3076, 
	0x3077, 0x3078, 0x3079, 0x307a, 0x307b, 0x307c, 0x307d, 0x307e, 0x307f, 
	0x3080, 0x3081, 0x3082, 0x3083, 0x3084, 0x3085, 0x3086, 0x3087, 0x3088, 
	0x3089, 0x308a, 0x308b, 0x308c, 0x308d, 0x308e, 0x308f, 0x3090, 0x3091, 
	0x3092, 0x3093,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1, 0x30a1, 0x30a2, 0x30a3, 0x30a4, 0x30a5, 
	0x30a6, 0x30a7, 0x30a8, 0x30a9, 0x30aa, 0x30ab, 0x30ac, 0x30ad, 0x30ae, 
	0x30af, 0x30b0, 0x30b1, 0x30b2, 0x30b3, 0x30b4, 0x30b5, 0x30b6, 0x30b7, 
	0x30b8, 0x30b9, 0x30ba, 0x30bb, 0x30bc, 0x30bd, 0x30be, 0x30bf, 0x30c0, 
	0x30c1, 0x30c2, 0x30c3, 0x30c4, 0x30c5, 0x30c6, 0x30c7, 0x30c8, 0x30c9, 
	0x30ca, 0x30cb, 0x30cc, 0x30cd, 0x30ce, 0x30cf, 0x30d0, 0x30d1, 0x30d2, 
	0x30d3, 0x30d4, 0x30d5, 0x30d6, 0x30d7, 0x30d8, 0x30d9, 0x30da, 0x30db, 
	0x30dc, 0x30dd, 0x30de, 0x30df, 0x30e0, 0x30e1, 0x30e2, 0x30e3, 0x30e4, 
	0x30e5, 0x30e6, 0x30e7, 0x30e8, 0x30e9, 0x30ea, 0x30eb, 0x30ec, 0x30ed, 
	0x30ee, 0x30ef, 0x30f0, 0x30f1, 0x30f2, 0x30f3, 0x30f4, 0x30f5, 0x30f6, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 0x0410, 
	0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0401, 0x0416, 0x0417, 0x0418, 
	0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e, 0x041f, 0x0420, 0x0421, 
	0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427, 0x0428, 0x0429, 0x042a, 
	0x042b, 0x042c, 0x042d, 0x042e, 0x042f,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1, 0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0451, 
	0x0436, 0x0437, 0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e, 
	0x043f, 0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447, 
	0x0448, 0x0449, 0x044a, 0x044b, 0x044c, 0x044d, 0x044e, 0x044f,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1, 0x3400, 0x3401, 0x3402, 
	0x3403, 0x3404, 0x3405, 0x3406, 0x3407, 0x3408, 0x3409, 0x340a, 0x340b, 
	0x340c, 0x340d, 0x340e, 0x340f, 0x3410, 0x3411, 0x3412, 0x3413, 0x3414, 
	0x3415, 0x3416, 0x3417, 0x3418, 0x3419, 0x341a, 0x341b, 0x341c, 0x341d, 
	0x341e, 0x341f, 0x3420, 0x3421, 0x3422, 0x3423, 0x3424, 0x3425, 0x3426, 
	0x3427, 0x3428, 0x3429, 0x342a, 0x342b, 0x342c, 0x342d, 0x342e, 0x342f, 
	0x3430, 0x3431, 0x3432, 0x3433, 0x3434, 0x3435, 0x3436, 0x3437, 0x3438, 
	0x3439, 0x343a, 0x343b, 0x343c, 0x343d, 0x343e, 0x343f, 0x3440, 0x3441, 
	0x3442, 0x3443, 0x3444, 0x3445, 0x3446, 0x3447, 0x3448, 0x3449, 0x344a, 
	0x344b, 0x344c, 0x344d, 0x344e, 0x344f, 0x3450, 0x3451, 0x3452, 0x3453, 
	0x3454, 0x3455, 0x3456, 0x3457, 0x3458, 0x3459, 0x345a, 0x345b, 0x345c, 
	0x345d, 0x345e, 0x345f, 0x3460, 0x3461, 0x3462, 0x3463, 0x3464, 0x3465, 
	0x3466, 0x3467, 0x3468, 0x3469, 0x346a, 0x346b, 0x346c, 0x346d, 0x346e, 
	0x346f, 0x3470, 0x3471, 0x3472, 0x3473, 0x3474, 0x3475, 0x3476, 0x3477, 
	0x3478, 0x3479, 0x347a, 0x347b, 0x347c, 0x347d, 0x347e, 0x347f, 0x3480, 
	0x3481, 0x3482, 0x3483, 0x3484, 0x3485, 0x3486, 0x3487, 0x3488, 0x3489, 
	0x348a, 0x348b, 0x348c, 0x348d, 0x348e, 0x348f, 0x3490, 0x3491, 0x3492, 
	0x3493, 0x3494, 0x3495, 0x3496, 0x3497, 0x3498, 0x3499, 0x349a, 0x349b, 
	0x349c, 0x349d, 0x349e, 0x349f, 0x34a0, 0x34a1, 0x34a2, 0x34a3, 0x34a4, 
	0x34a5, 0x34a6, 0x34a7, 0x34a8, 0x34a9, 0x34aa, 0x34ab, 0x34ac, 0x34ad, 
	0x34ae, 0x34af, 0x34b0, 0x34b1, 0x34b2, 0x34b3, 0x34b4, 0x34b5, 0x34b6, 
	0x34b7, 0x34b8, 0x34b9, 0x34ba, 0x34bb, 0x34bc, 0x34bd, 0x34be, 0x34bf, 
	0x34c0, 0x34c1, 0x34c2, 0x34c3, 0x34c4, 0x34c5, 0x34c6, 0x34c7, 0x34c8, 
	0x34c9, 0x34ca, 0x34cb, 0x34cc, 0x34cd, 0x34ce, 0x34cf, 0x34d0, 0x34d1, 
	0x34d2, 0x34d3, 0x34d4, 0x34d5, 0x34d6, 0x34d7, 0x34d8, 0x34d9, 0x34da, 
	0x34db, 0x34dc, 0x34dd, 0x34de, 0x34df, 0x34e0, 0x34e1, 0x34e2, 0x34e3, 
	0x34e4, 0x34e5, 0x34e6, 0x34e7, 0x34e8, 0x34e9, 0x34ea, 0x34eb, 0x34ec, 
	0x34ed, 0x34ee, 0x34ef, 0x34f0, 0x34f1, 0x34f2, 0x34f3, 0x34f4, 0x34f5, 
	0x34f6, 0x34f7, 0x34f8, 0x34f9, 0x34fa, 0x34fb, 0x34fc, 0x34fd, 0x34fe, 
	0x34ff, 0x3500, 0x3501, 0x3502, 0x3503, 0x3504, 0x3505, 0x3506, 0x3507, 
	0x3508, 0x3509, 0x350a, 0x350b, 0x350c, 0x350d, 0x350e, 0x350f, 0x3510, 
	0x3511, 0x3512, 0x3513, 0x3514, 0x3515, 0x3516, 0x3517, 0x3518, 0x3519, 
	0x351a, 0x351b, 0x351c, 0x351d, 0x351e, 0x351f, 0x3520, 0x3521, 0x3522, 
	0x3523, 0x3524, 0x3525, 0x3526, 0x3527, 0x3528, 0x3529, 0x352a, 0x352b, 
	0x352c, 0x352d, 0x352e, 0x352f, 0x3530, 0x3531, 0x3532, 0x3533, 0x3534, 
	0x3535, 0x3536, 0x3537, 0x3538, 0x3539, 0x353a, 0x353b, 0x353c, 0x353d, 
	0x353e, 0x353f, 0x3540, 0x3541, 0x3542, 0x3543, 0x3544, 0x3545, 0x3546, 
	0x3547, 0x3548, 0x3549, 0x354a, 0x354b, 0x354c, 0x354d, 0x354e, 0x354f, 
	0x3550, 0x3551, 0x3552, 0x3553, 0x3554, 0x3555, 0x3556, 0x3557, 0x3558, 
	0x3559, 0x355a, 0x355b, 0x355c, 0x355d, 0x355e, 0x355f, 0x3560, 0x3561, 
	0x3562, 0x3563, 0x3564, 0x3565, 0x3566, 0x3567, 0x3568, 0x3569, 0x356a, 
	0x356b, 0x356c, 0x356d, 0x356e, 0x356f, 0x3570, 0x3571, 0x3572, 0x3573, 
	0x3574, 0x3575, 0x3576, 0x3577, 0x3578, 0x3579, 0x357a, 0x357b, 0x357c, 
	0x357d, 0x357e, 0x357f, 0x3580, 0x3581, 0x3582, 0x3583, 0x3584, 0x3585, 
	0x3586, 0x3587, 0x3588, 0x3589, 0x358a, 0x358b, 0x358c, 0x358d, 0x358e, 
	0x358f, 0x3590, 0x3591, 0x3592, 0x3593, 0x3594, 0x3595, 0x3596, 0x3597, 
	0x3598, 0x3599, 0x359a, 0x359b, 0x359c, 0x359d, 0x359e, 0x359f, 0x35a0, 
	0x35a1, 0x35a2, 0x35a3, 0x35a4, 0x35a5, 0x35a6, 0x35a7, 0x35a8, 0x35a9, 
	0x35aa, 0x35ab, 0x35ac, 0x35ad, 0x35ae, 0x35af, 0x35b0, 0x35b1, 0x35b2, 
	0x35b3, 0x35b4, 0x35b5, 0x35b6, 0x35b7, 0x35b8, 0x35b9, 0x35ba, 0x35bb, 
	0x35bc, 0x35bd, 0x35be, 0x35bf, 0x35c0, 0x35c1, 0x35c2, 0x35c3, 0x35c4, 
	0x35c5, 0x35c6, 0x35c7, 0x35c8, 0x35c9, 0x35ca, 0x35cb, 0x35cc, 0x35cd, 
	0x35ce, 0x35cf, 0x35d0, 0x35d1, 0x35d2, 0x35d3, 0x35d4, 0x35d5, 0x35d6, 
	0x35d7, 0x35d8, 0x35d9, 0x35da, 0x35db, 0x35dc, 0x35dd, 0x35de, 0x35df, 
	0x35e0, 0x35e1, 0x35e2, 0x35e3, 0x35e4, 0x35e5, 0x35e6, 0x35e7, 0x35e8, 
	0x35e9, 0x35ea, 0x35eb, 0x35ec, 0x35ed, 0x35ee, 0x35ef, 0x35f0, 0x35f1, 
	0x35f2, 0x35f3, 0x35f4, 0x35f5, 0x35f6, 0x35f7, 0x35f8, 0x35f9, 0x35fa, 
	0x35fb, 0x35fc, 0x35fd, 0x35fe, 0x35ff, 0x3600, 0x3601, 0x3602, 0x3603, 
	0x3604, 0x3605, 0x3606, 0x3607, 0x3608, 0x3609, 0x360a, 0x360b, 0x360c, 
	0x360d, 0x360e, 0x360f, 0x3610, 0x3611, 0x3612, 0x3613, 0x3614, 0x3615, 
	0x3616, 0x3617, 0x3618, 0x3619, 0x361a, 0x361b, 0x361c, 0x361d, 0x361e, 
	0x361f, 0x3620, 0x3621, 0x3622, 0x3623, 0x3624, 0x3625, 0x3626, 0x3627, 
	0x3628, 0x3629, 0x362a, 0x362b, 0x362c, 0x362d, 0x362e, 0x362f, 0x3630, 
	0x3631, 0x3632, 0x3633, 0x3634, 0x3635, 0x3636, 0x3637, 0x3638, 0x3639, 
	0x363a, 0x363b, 0x363c, 0x363d, 0x363e, 0x363f, 0x3640, 0x3641, 0x3642, 
	0x3643, 0x3644, 0x3645, 0x3646, 0x3647, 0x3648, 0x3649, 0x364a, 0x364b, 
	0x364c, 0x364d, 0x364e, 0x364f, 0x3650, 0x3651, 0x3652, 0x3653, 0x3654, 
	0x3655, 0x3656, 0x3657, 0x3658, 0x3659, 0x365a, 0x365b, 0x365c, 0x365d, 
	0x365e, 0x365f, 0x3660, 0x3661, 0x3662, 0x3663, 0x3664, 0x3665, 0x3666, 
	0x3667, 0x3668, 0x3669, 0x366a, 0x366b, 0x366c, 0x366d, 0x366e, 0x366f, 
	0x3670, 0x3671, 0x3672, 0x3673, 0x3674, 0x3675, 0x3676, 0x3677, 0x3678, 
	0x3679, 0x367a, 0x367b, 0x367c, 0x367d, 0x367e, 0x367f, 0x3680, 0x3681, 
	0x3682, 0x3683, 0x3684, 0x3685, 0x3686, 0x3687, 0x3688, 0x3689, 0x368a, 
	0x368b, 0x368c, 0x368d, 0x368e, 0x368f, 0x3690, 0x3691, 0x3692, 0x3693, 
	0x3694, 0x3695, 0x3696, 0x3697, 0x3698, 0x3699, 0x369a, 0x369b, 0x369c, 
	0x369d, 0x369e, 0x369f, 0x36a0, 0x36a1, 0x36a2, 0x36a3, 0x36a4, 0x36a5, 
	0x36a6, 0x36a7, 0x36a8, 0x36a9, 0x36aa, 0x36ab, 0x36ac, 0x36ad, 0x36ae, 
	0x36af, 0x36b0, 0x36b1, 0x36b2, 0x36b3, 0x36b4, 0x36b5, 0x36b6, 0x36b7, 
	0x36b8, 0x36b9, 0x36ba, 0x36bb, 0x36bc, 0x36bd, 0x36be, 0x36bf, 0x36c0, 
	0x36c1, 0x36c2, 0x36c3, 0x36c4, 0x36c5, 0x36c6, 0x36c7, 0x36c8, 0x36c9, 
	0x36ca, 0x36cb, 0x36cc, 0x36cd, 0x36ce, 0x36cf, 0x36d0, 0x36d1, 0x36d2, 
	0x36d3, 0x36d4, 0x36d5, 0x36d6, 0x36d7, 0x36d8, 0x36d9, 0x36da, 0x36db, 
	0x36dc, 0x36dd, 0x36de, 0x36df, 0x36e0, 0x36e1, 0x36e2, 0x36e3, 0x36e4, 
	0x36e5, 0x36e6, 0x36e7, 0x36e8, 0x36e9, 0x36ea, 0x36eb, 0x36ec, 0x36ed, 
	0x36ee, 0x36ef, 0x36f0, 0x36f1, 0x36f2, 0x36f3, 0x36f4, 0x36f5, 0x36f6, 
	0x36f7, 0x36f8, 0x36f9, 0x36fa, 0x36fb, 0x36fc, 0x36fd, 0x36fe, 0x36ff, 
	0x3700, 0x3701, 0x3702, 0x3703, 0x3704, 0x3705, 0x3706, 0x3707, 0x3708, 
	0x3709, 0x370a, 0x370b, 0x370c, 0x370d, 0x370e, 0x370f, 0x3710, 0x3711, 
	0x3712, 0x3713, 0x3714, 0x3715, 0x3716, 0x3717, 0x3718, 0x3719, 0x371a, 
	0x371b, 0x371c, 0x371d, 0x371e, 0x371f, 0x3720, 0x3721, 0x3722, 0x3723, 
	0x3724, 0x3725, 0x3726, 0x3727, 0x3728, 0x3729, 0x372a, 0x372b, 0x372c, 
	0x372d, 0x372e, 0x372f, 0x3730, 0x3731, 0x3732, 0x3733, 0x3734, 0x3735, 
	0x3736, 0x3737, 0x3738, 0x3739, 0x373a, 0x373b, 0x373c, 0x373d, 0x373e, 
	0x373f, 0x3740, 0x3741, 0x3742, 0x3743, 0x3744, 0x3745, 0x3746, 0x3747, 
	0x3748, 0x3749, 0x374a, 0x374b, 0x374c, 0x374d, 0x374e, 0x374f, 0x3750, 
	0x3751, 0x3752, 0x3753, 0x3754, 0x3755, 0x3756, 0x3757, 0x3758, 0x3759, 
	0x375a, 0x375b, 0x375c, 0x375d, 0x375e, 0x375f, 0x3760, 0x3761, 0x3762, 
	0x3763, 0x3764, 0x3765, 0x3766, 0x3767, 0x3768, 0x3769, 0x376a, 0x376b, 
	0x376c, 0x376d, 0x376e, 0x376f, 0x3770, 0x3771, 0x3772, 0x3773, 0x3774, 
	0x3775, 0x3776, 0x3777, 0x3778, 0x3779, 0x377a, 0x377b, 0x377c, 0x377d, 
	0x377e, 0x377f, 0x3780, 0x3781, 0x3782, 0x3783, 0x3784, 0x3785, 0x3786, 
	0x3787, 0x3788, 0x3789, 0x378a, 0x378b, 0x378c, 0x378d, 0x378e, 0x378f, 
	0x3790, 0x3791, 0x3792, 0x3793, 0x3794, 0x3795, 0x3796, 0x3797, 0x3798, 
	0x3799, 0x379a, 0x379b, 0x379c, 0x379d, 0x379e, 0x379f, 0x37a0, 0x37a1, 
	0x37a2, 0x37a3, 0x37a4, 0x37a5, 0x37a6, 0x37a7, 0x37a8, 0x37a9, 0x37aa, 
	0x37ab, 0x37ac, 0x37ad, 0x37ae, 0x37af, 0x37b0, 0x37b1, 0x37b2, 0x37b3, 
	0x37b4, 0x37b5, 0x37b6, 0x37b7, 0x37b8, 0x37b9, 0x37ba, 0x37bb, 0x37bc, 
	0x37bd, 0x37be, 0x37bf, 0x37c0, 0x37c1, 0x37c2, 0x37c3, 0x37c4, 0x37c5, 
	0x37c6, 0x37c7, 0x37c8, 0x37c9, 0x37ca, 0x37cb, 0x37cc, 0x37cd, 0x37ce, 
	0x37cf, 0x37d0, 0x37d1, 0x37d2, 0x37d3, 0x37d4, 0x37d5, 0x37d6, 0x37d7, 
	0x37d8, 0x37d9, 0x37da, 0x37db, 0x37dc, 0x37dd, 0x37de, 0x37df, 0x37e0, 
	0x37e1, 0x37e2, 0x37e3, 0x37e4, 0x37e5, 0x37e6, 0x37e7, 0x37e8, 0x37e9, 
	0x37ea, 0x37eb, 0x37ec, 0x37ed, 0x37ee, 0x37ef, 0x37f0, 0x37f1, 0x37f2, 
	0x37f3, 0x37f4, 0x37f5, 0x37f6, 0x37f7, 0x37f8, 0x37f9, 0x37fa, 0x37fb, 
	0x37fc, 0x37fd, 0x37fe, 0x37ff, 0x3800, 0x3801, 0x3802, 0x3803, 0x3804, 
	0x3805, 0x3806, 0x3807, 0x3808, 0x3809, 0x380a, 0x380b, 0x380c, 0x380d, 
	0x380e, 0x380f, 0x3810, 0x3811, 0x3812, 0x3813, 0x3814, 0x3815, 0x3816, 
	0x3817, 0x3818, 0x3819, 0x381a, 0x381b, 0x381c, 0x381d, 0x381e, 0x381f, 
	0x3820, 0x3821, 0x3822, 0x3823, 0x3824, 0x3825, 0x3826, 0x3827, 0x3828, 
	0x3829, 0x382a, 0x382b, 0x382c, 0x382d, 0x382e, 0x382f, 0x3830, 0x3831, 
	0x3832, 0x3833, 0x3834, 0x3835, 0x3836, 0x3837, 0x3838, 0x3839, 0x383a, 
	0x383b, 0x383c, 0x383d, 0x383e, 0x383f, 0x3840, 0x3841, 0x3842, 0x3843, 
	0x3844, 0x3845, 0x3846, 0x3847, 0x3848, 0x3849, 0x384a, 0x384b, 0x384c, 
	0x384d, 0x384e, 0x384f, 0x3850, 0x3851, 0x3852, 0x3853, 0x3854, 0x3855, 
	0x3856, 0x3857, 0x3858, 0x3859, 0x385a, 0x385b, 0x385c, 0x385d, 0x385e, 
	0x385f, 0x3860, 0x3861, 0x3862, 0x3863, 0x3864, 0x3865, 0x3866, 0x3867, 
	0x3868, 0x3869, 0x386a, 0x386b, 0x386c, 0x386d, 0x386e, 0x386f, 0x3870, 
	0x3871, 0x3872, 0x3873, 0x3874, 0x3875, 0x3876, 0x3877, 0x3878, 0x3879, 
	0x387a, 0x387b, 0x387c, 0x387d, 0x387e, 0x387f, 0x3880, 0x3881, 0x3882, 
	0x3883, 0x3884, 0x3885, 0x3886, 0x3887, 0x3888, 0x3889, 0x388a, 0x388b, 
	0x388c, 0x388d, 0x388e, 0x388f, 0x3890, 0x3891, 0x3892, 0x3893, 0x3894, 
	0x3895, 0x3896, 0x3897, 0x3898, 0x3899, 0x389a, 0x389b, 0x389c, 0x389d, 
	0x389e, 0x389f, 0x38a0, 0x38a1, 0x38a2, 0x38a3, 0x38a4, 0x38a5, 0x38a6, 
	0x38a7, 0x38a8, 0x38a9, 0x38aa, 0x38ab, 0x38ac, 0x38ad, 0x38ae, 0x38af, 
	0x38b0, 0x38b1, 0x38b2, 0x38b3, 0x38b4, 0x38b5, 0x38b6, 0x38b7, 0x38b8, 
	0x38b9, 0x38ba, 0x38bb, 0x38bc, 0x38bd, 0x38be, 0x38bf, 0x38c0, 0x38c1, 
	0x38c2, 0x38c3, 0x38c4, 0x38c5, 0x38c6, 0x38c7, 0x38c8, 0x38c9, 0x38ca, 
	0x38cb, 0x38cc, 0x38cd, 0x38ce, 0x38cf, 0x38d0, 0x38d1, 0x38d2, 0x38d3, 
	0x38d4, 0x38d5, 0x38d6, 0x38d7, 0x38d8, 0x38d9, 0x38da, 0x38db, 0x38dc, 
	0x38dd, 0x38de, 0x38df, 0x38e0, 0x38e1, 0x38e2, 0x38e3, 0x38e4, 0x38e5, 
	0x38e6, 0x38e7, 0x38e8, 0x38e9, 0x38ea, 0x38eb, 0x38ec, 0x38ed, 0x38ee, 
	0x38ef, 0x38f0, 0x38f1, 0x38f2, 0x38f3, 0x38f4, 0x38f5, 0x38f6, 0x38f7, 
	0x38f8, 0x38f9, 0x38fa, 0x38fb, 0x38fc, 0x38fd, 0x38fe, 0x38ff, 0x3900, 
	0x3901, 0x3902, 0x3903, 0x3904, 0x3905, 0x3906, 0x3907, 0x3908, 0x3909, 
	0x390a, 0x390b, 0x390c, 0x390d, 0x390e, 0x390f, 0x3910, 0x3911, 0x3912, 
	0x3913, 0x3914, 0x3915, 0x3916, 0x3917, 0x3918, 0x3919, 0x391a, 0x391b, 
	0x391c, 0x391d, 0x391e, 0x391f, 0x3920, 0x3921, 0x3922, 0x3923, 0x3924, 
	0x3925, 0x3926, 0x3927, 0x3928, 0x3929, 0x392a, 0x392b, 0x392c, 0x392d, 
	0x392e, 0x392f, 0x3930, 0x3931, 0x3932, 0x3933, 0x3934, 0x3935, 0x3936, 
	0x3937, 0x3938, 0x3939, 0x393a, 0x393b, 0x393c, 0x393d, 0x393e, 0x393f, 
	0x3940, 0x3941, 0x3942, 0x3943, 0x3944, 0x3945, 0x3946, 0x3947, 0x3948, 
	0x3949, 0x394a, 0x394b, 0x394c, 0x394d, 0x394e, 0x394f, 0x3950, 0x3951, 
	0x3952, 0x3953, 0x3954, 0x3955, 0x3956, 0x3957, 0x3958, 0x3959, 0x395a, 
	0x395b, 0x395c, 0x395d, 0x395e, 0x395f, 0x3960, 0x3961, 0x3962, 0x3963, 
	0x3964, 0x3965, 0x3966, 0x3967, 0x3968, 0x3969, 0x396a, 0x396b, 0x396c, 
	0x396d, 0x396e, 0x396f, 0x3970, 0x3971, 0x3972, 0x3973, 0x3974, 0x3975, 
	0x3976, 0x3977, 0x3978, 0x3979, 0x397a, 0x397b, 0x397c, 0x397d, 0x397e, 
	0x397f, 0x3980, 0x3981, 0x3982, 0x3983, 0x3984, 0x3985, 0x3986, 0x3987, 
	0x3988, 0x3989, 0x398a, 0x398b, 0x398c, 0x398d, 0x398e, 0x398f, 0x3990, 
	0x3991, 0x3992, 0x3993, 0x3994, 0x3995, 0x3996, 0x3997, 0x3998, 0x3999, 
	0x399a, 0x399b, 0x399c, 0x399d, 0x399e, 0x399f, 0x39a0, 0x39a1, 0x39a2, 
	0x39a3, 0x39a4, 0x39a5, 0x39a6, 0x39a7, 0x39a8, 0x39a9, 0x39aa, 0x39ab, 
	0x39ac, 0x39ad, 0x39ae, 0x39af, 0x39b0, 0x39b1, 0x39b2, 0x39b3, 0x39b4, 
	0x39b5, 0x39b6, 0x39b7, 0x39b8, 0x39b9, 0x39ba, 0x39bb, 0x39bc, 0x39bd, 
	0x39be, 0x39bf, 0x39c0, 0x39c1, 0x39c2, 0x39c3, 0x39c4, 0x39c5, 0x39c6, 
	0x39c7, 0x39c8, 0x39c9, 0x39ca, 0x39cb, 0x39cc, 0x39cd, 0x39ce, 0x39cf, 
	0x39d0, 0x39d1, 0x39d2, 0x39d3, 0x39d4, 0x39d5, 0x39d6, 0x39d7, 0x39d8, 
	0x39d9, 0x39da, 0x39db, 0x39dc, 0x39dd, 0x39de, 0x39df, 0x39e0, 0x39e1, 
	0x39e2, 0x39e3, 0x39e4, 0x39e5, 0x39e6, 0x39e7, 0x39e8, 0x39e9, 0x39ea, 
	0x39eb, 0x39ec, 0x39ed, 0x39ee, 0x39ef, 0x39f0, 0x39f1, 0x39f2, 0x39f3, 
	0x39f4, 0x39f5, 0x39f6, 0x39f7, 0x39f8, 0x39f9, 0x39fa, 0x39fb, 0x39fc, 
	0x39fd, 0x39fe, 0x39ff, 0x3a00, 0x3a01, 0x3a02, 0x3a03, 0x3a04, 0x3a05, 
	0x3a06, 0x3a07, 0x3a08, 0x3a09, 0x3a0a, 0x3a0b, 0x3a0c, 0x3a0d, 0x3a0e, 
	0x3a0f, 0x3a10, 0x3a11, 0x3a12, 0x3a13, 0x3a14, 0x3a15, 0x3a16, 0x3a17, 
	0x3a18, 0x3a19, 0x3a1a, 0x3a1b, 0x3a1c, 0x3a1d, 0x3a1e, 0x3a1f, 0x3a20, 
	0x3a21, 0x3a22, 0x3a23, 0x3a24, 0x3a25, 0x3a26, 0x3a27, 0x3a28, 0x3a29, 
	0x3a2a, 0x3a2b, 0x3a2c, 0x3a2d, 0x3a2e, 0x3a2f, 0x3a30, 0x3a31, 0x3a32, 
	0x3a33, 0x3a34, 0x3a35, 0x3a36, 0x3a37, 0x3a38, 0x3a39, 0x3a3a, 0x3a3b, 
	0x3a3c, 0x3a3d, 0x3a3e, 0x3a3f, 0x3a40, 0x3a41, 0x3a42, 0x3a43, 0x3a44, 
	0x3a45, 0x3a46, 0x3a47, 0x3a48, 0x3a49, 0x3a4a, 0x3a4b, 0x3a4c, 0x3a4d, 
	0x3a4e, 0x3a4f, 0x3a50, 0x3a51, 0x3a52, 0x3a53, 0x3a54, 0x3a55, 0x3a56, 
	0x3a57, 0x3a58, 0x3a59, 0x3a5a, 0x3a5b, 0x3a5c, 0x3a5d, 0x3a5e, 0x3a5f, 
	0x3a60, 0x3a61, 0x3a62, 0x3a63, 0x3a64, 0x3a65, 0x3a66, 0x3a67, 0x3a68, 
	0x3a69, 0x3a6a, 0x3a6b, 0x3a6c, 0x3a6d, 0x3a6e, 0x3a6f, 0x3a70, 0x3a71, 
	0x3a72, 0x3a73, 0x3a74, 0x3a75, 0x3a76, 0x3a77, 0x3a78, 0x3a79, 0x3a7a, 
	0x3a7b, 0x3a7c, 0x3a7d, 0x3a7e, 0x3a7f, 0x3a80, 0x3a81, 0x3a82, 0x3a83, 
	0x3a84, 0x3a85, 0x3a86, 0x3a87, 0x3a88, 0x3a89, 0x3a8a, 0x3a8b, 0x3a8c, 
	0x3a8d, 0x3a8e, 0x3a8f, 0x3a90, 0x3a91, 0x3a92, 0x3a93, 0x3a94, 0x3a95, 
	0x3a96, 0x3a97, 0x3a98, 0x3a99, 0x3a9a, 0x3a9b, 0x3a9c, 0x3a9d, 0x3a9e, 
	0x3a9f, 0x3aa0, 0x3aa1, 0x3aa2, 0x3aa3, 0x3aa4, 0x3aa5, 0x3aa6, 0x3aa7, 
	0x3aa8, 0x3aa9, 0x3aaa, 0x3aab, 0x3aac, 0x3aad, 0x3aae, 0x3aaf, 0x3ab0, 
	0x3ab1, 0x3ab2, 0x3ab3, 0x3ab4, 0x3ab5, 0x3ab6, 0x3ab7, 0x3ab8, 0x3ab9, 
	0x3aba, 0x3abb, 0x3abc, 0x3abd, 0x3abe, 0x3abf, 0x3ac0, 0x3ac1, 0x3ac2, 
	0x3ac3, 0x3ac4, 0x3ac5, 0x3ac6, 0x3ac7, 0x3ac8, 0x3ac9, 0x3aca, 0x3acb, 
	0x3acc, 0x3acd, 0x3ace, 0x3acf, 0x3ad0, 0x3ad1, 0x3ad2, 0x3ad3, 0x3ad4, 
	0x3ad5, 0x3ad6, 0x3ad7, 0x3ad8, 0x3ad9, 0x3ada, 0x3adb, 0x3adc, 0x3add, 
	0x3ade, 0x3adf, 0x3ae0, 0x3ae1, 0x3ae2, 0x3ae3, 0x3ae4, 0x3ae5, 0x3ae6, 
	0x3ae7, 0x3ae8, 0x3ae9, 0x3aea, 0x3aeb, 0x3aec, 0x3aed, 0x3aee, 0x3aef, 
	0x3af0, 0x3af1, 0x3af2, 0x3af3, 0x3af4, 0x3af5, 0x3af6, 0x3af7, 0x3af8, 
	0x3af9, 0x3afa, 0x3afb, 0x3afc, 0x3afd, 0x3afe, 0x3aff, 0x3b00, 0x3b01, 
	0x3b02, 0x3b03, 0x3b04, 0x3b05, 0x3b06, 0x3b07, 0x3b08, 0x3b09, 0x3b0a, 
	0x3b0b, 0x3b0c, 0x3b0d, 0x3b0e, 0x3b0f, 0x3b10, 0x3b11, 0x3b12, 0x3b13, 
	0x3b14, 0x3b15, 0x3b16, 0x3b17, 0x3b18, 0x3b19, 0x3b1a, 0x3b1b, 0x3b1c, 
	0x3b1d, 0x3b1e, 0x3b1f, 0x3b20, 0x3b21, 0x3b22, 0x3b23, 0x3b24, 0x3b25, 
	0x3b26, 0x3b27, 0x3b28, 0x3b29, 0x3b2a, 0x3b2b, 0x3b2c, 0x3b2d, 0x3b2e, 
	0x3b2f, 0x3b30, 0x3b31, 0x3b32, 0x3b33, 0x3b34, 0x3b35, 0x3b36, 0x3b37, 
	0x3b38, 0x3b39, 0x3b3a, 0x3b3b, 0x3b3c, 0x3b3d, 0x3b3e, 0x3b3f, 0x3b40, 
	0x3b41, 0x3b42, 0x3b43, 0x3b44, 0x3b45, 0x3b46, 0x3b47, 0x3b48, 0x3b49, 
	0x3b4a, 0x3b4b, 0x3b4c, 0x3b4d, 0x3b4e, 0x3b4f, 0x3b50, 0x3b51, 0x3b52, 
	0x3b53, 0x3b54, 0x3b55, 0x3b56, 0x3b57, 0x3b58, 0x3b59, 0x3b5a, 0x3b5b, 
	0x3b5c, 0x3b5d, 0x3b5e, 0x3b5f, 0x3b60, 0x3b61, 0x3b62, 0x3b63, 0x3b64, 
	0x3b65, 0x3b66, 0x3b67, 0x3b68, 0x3b69, 0x3b6a, 0x3b6b, 0x3b6c, 0x3b6d, 
	0x3b6e, 0x3b6f, 0x3b70, 0x3b71, 0x3b72, 0x3b73, 0x3b74, 0x3b75, 0x3b76, 
	0x3b77, 0x3b78, 0x3b79, 0x3b7a, 0x3b7b, 0x3b7c, 0x3b7d, 0x3b7e, 0x3b7f, 
	0x3b80, 0x3b81, 0x3b82, 0x3b83, 0x3b84, 0x3b85, 0x3b86, 0x3b87, 0x3b88, 
	0x3b89, 0x3b8a, 0x3b8b, 0x3b8c, 0x3b8d, 0x3b8e, 0x3b8f, 0x3b90, 0x3b91, 
	0x3b92, 0x3b93, 0x3b94, 0x3b95, 0x3b96, 0x3b97, 0x3b98, 0x3b99, 0x3b9a, 
	0x3b9b, 0x3b9c, 0x3b9d, 0x3b9e, 0x3b9f, 0x3ba0, 0x3ba1, 0x3ba2, 0x3ba3, 
	0x3ba4, 0x3ba5, 0x3ba6, 0x3ba7, 0x3ba8, 0x3ba9, 0x3baa, 0x3bab, 0x3bac, 
	0x3bad, 0x3bae, 0x3baf, 0x3bb0, 0x3bb1, 0x3bb2, 0x3bb3, 0x3bb4, 0x3bb5, 
	0x3bb6, 0x3bb7, 0x3bb8, 0x3bb9, 0x3bba, 0x3bbb, 0x3bbc, 0x3bbd, 0x3bbe, 
	0x3bbf, 0x3bc0, 0x3bc1, 0x3bc2, 0x3bc3, 0x3bc4, 0x3bc5, 0x3bc6, 0x3bc7, 
	0x3bc8, 0x3bc9, 0x3bca, 0x3bcb, 0x3bcc, 0x3bcd, 0x3bce, 0x3bcf, 0x3bd0, 
	0x3bd1, 0x3bd2, 0x3bd3, 0x3bd4, 0x3bd5, 0x3bd6, 0x3bd7, 0x3bd8, 0x3bd9, 
	0x3bda, 0x3bdb, 0x3bdc, 0x3bdd, 0x3bde, 0x3bdf, 0x3be0, 0x3be1, 0x3be2, 
	0x3be3, 0x3be4, 0x3be5, 0x3be6, 0x3be7, 0x3be8, 0x3be9, 0x3bea, 0x3beb, 
	0x3bec, 0x3bed, 0x3bee, 0x3bef, 0x3bf0, 0x3bf1, 0x3bf2, 0x3bf3, 0x3bf4, 
	0x3bf5, 0x3bf6, 0x3bf7, 0x3bf8, 0x3bf9, 0x3bfa, 0x3bfb, 0x3bfc, 0x3bfd, 
	0x3bfe, 0x3bff, 0x3c00, 0x3c01, 0x3c02, 0x3c03, 0x3c04, 0x3c05, 0x3c06, 
	0x3c07, 0x3c08, 0x3c09, 0x3c0a, 0x3c0b, 0x3c0c, 0x3c0d, 0x3c0e, 0x3c0f, 
	0x3c10, 0x3c11, 0x3c12, 0x3c13, 0x3c14, 0x3c15, 0x3c16, 0x3c17, 0x3c18, 
	0x3c19, 0x3c1a, 0x3c1b, 0x3c1c, 0x3c1d, 0x3c1e, 0x3c1f, 0x3c20, 0x3c21, 
	0x3c22, 0x3c23, 0x3c24, 0x3c25, 0x3c26, 0x3c27, 0x3c28, 0x3c29, 0x3c2a, 
	0x3c2b, 0x3c2c, 0x3c2d, 0x3c2e, 0x3c2f, 0x3c30, 0x3c31, 0x3c32, 0x3c33, 
	0x3c34, 0x3c35, 0x3c36, 0x3c37, 0x3c38, 0x3c39, 0x3c3a, 0x3c3b, 0x3c3c, 
	0x3c3d, 0x3c3e, 0x3c3f, 0x3c40, 0x3c41, 0x3c42, 0x3c43, 0x3c44, 0x3c45, 
	0x3c46, 0x3c47, 0x3c48, 0x3c49, 0x3c4a, 0x3c4b, 0x3c4c, 0x3c4d, 0x3c4e, 
	0x3c4f, 0x3c50, 0x3c51, 0x3c52, 0x3c53, 0x3c54, 0x3c55, 0x3c56, 0x3c57, 
	0x3c58, 0x3c59, 0x3c5a, 0x3c5b, 0x3c5c, 0x3c5d, 0x3c5e, 0x3c5f, 0x3c60, 
	0x3c61, 0x3c62, 0x3c63, 0x3c64, 0x3c65, 0x3c66, 0x3c67, 0x3c68, 0x3c69, 
	0x3c6a, 0x3c6b, 0x3c6c, 0x3c6d, 0x3c6e, 0x3c6f, 0x3c70, 0x3c71, 0x3c72, 
	0x3c73, 0x3c74, 0x3c75, 0x3c76, 0x3c77, 0x3c78, 0x3c79, 0x3c7a, 0x3c7b, 
	0x3c7c, 0x3c7d, 0x3c7e, 0x3c7f, 0x3c80, 0x3c81, 0x3c82, 0x3c83, 0x3c84, 
	0x3c85, 0x3c86, 0x3c87, 0x3c88, 0x3c89, 0x3c8a, 0x3c8b, 0x3c8c, 0x3c8d, 
	0x3c8e, 0x3c8f, 0x3c90, 0x3c91, 0x3c92, 0x3c93, 0x3c94, 0x3c95, 0x3c96, 
	0x3c97, 0x3c98, 0x3c99, 0x3c9a, 0x3c9b, 0x3c9c, 0x3c9d, 0x3c9e, 0x3c9f, 
	0x3ca0, 0x3ca1, 0x3ca2, 0x3ca3, 0x3ca4, 0x3ca5, 0x3ca6, 0x3ca7, 0x3ca8, 
	0x3ca9, 0x3caa, 0x3cab, 0x3cac, 0x3cad, 0x3cae, 0x3caf, 0x3cb0, 0x3cb1, 
	0x3cb2, 0x3cb3, 0x3cb4, 0x3cb5, 0x3cb6, 0x3cb7, 0x3cb8, 0x3cb9, 0x3cba, 
	0x3cbb, 0x3cbc, 0x3cbd, 0x3cbe, 0x3cbf, 0x3cc0, 0x3cc1, 0x3cc2, 0x3cc3, 
	0x3cc4, 0x3cc5, 0x3cc6, 0x3cc7, 0x3cc8, 0x3cc9, 0x3cca, 0x3ccb, 0x3ccc, 
	0x3ccd, 0x3cce, 0x3ccf, 0x3cd0, 0x3cd1, 0x3cd2, 0x3cd3, 0x3cd4, 0x3cd5, 
	0x3cd6, 0x3cd7, 0x3cd8, 0x3cd9, 0x3cda, 0x3cdb, 0x3cdc, 0x3cdd, 0x3cde, 
	0x3cdf, 0x3ce0, 0x3ce1, 0x3ce2, 0x3ce3, 0x3ce4, 0x3ce5, 0x3ce6, 0x3ce7, 
	0x3ce8, 0x3ce9, 0x3cea, 0x3ceb, 0x3cec, 0x3ced, 0x3cee, 0x3cef, 0x3cf0, 
	0x3cf1, 0x3cf2, 0x3cf3, 0x3cf4, 0x3cf5, 0x3cf6, 0x3cf7, 0x3cf8, 0x3cf9, 
	0x3cfa, 0x3cfb, 0x3cfc, 0x3cfd, 0x3cfe, 0x3cff, 0x3d00, 0x3d01, 0x3d02, 
	0x3d03, 0x3d04, 0x3d05, 0x3d06, 0x3d07, 0x3d08, 0x3d09, 0x3d0a, 0x3d0b, 
	0x3d0c, 0x3d0d, 0x3d0e, 0x3d0f, 0x3d10, 0x3d11, 0x3d12, 0x3d13, 0x3d14, 
	0x3d15, 0x3d16, 0x3d17, 0x3d18, 0x3d19, 0x3d1a, 0x3d1b, 0x3d1c, 0x3d1d, 
	0x3d1e, 0x3d1f, 0x3d20, 0x3d21, 0x3d22, 0x3d23, 0x3d24, 0x3d25, 0x3d26, 
	0x3d27, 0x3d28, 0x3d29, 0x3d2a, 0x3d2b, 0x3d2c, 0x3d2d,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1, 0x4f3d, 0x4f73, 0x5047, 0x50f9, 0x52a0, 0x53ef, 0x5475, 
	0x54e5, 0x5609, 0x5ac1, 0x5bb6, 0x6687, 0x67b6, 0x67b7, 0x67ef, 0x6b4c, 
	0x73c2, 0x75c2, 0x7a3c, 0x82db, 0x8304, 0x8857, 0x8888, 0x8a36, 0x8cc8, 
	0x8dcf, 0x8efb, 0x8fe6, 0x99d5, 0x523b, 0x5374, 0x5404, 0x606a, 0x6164, 
	0x6bbc, 0x73cf, 0x811a, 0x89ba, 0x89d2, 0x95a3, 0x4f83, 0x520a, 0x58be, 
	0x5978, 0x59e6, 0x5e72, 0x5e79, 0x61c7, 0x63c0, 0x6746, 0x67ec, 0x687f, 
	0x6f97, 0x764e, 0x770b, 0x78f5, 0x7a08, 0x7aff, 0x7c21, 0x809d, 0x826e, 
	0x8271, 0x8aeb, 0x9593, 0x4e6b, 0x559d, 0x66f7, 0x6e34, 0x78a3, 0x7aed, 
	0x845b, 0x8910, 0x874e, 0x97a8, 0x52d8, 0x574e, 0x582a, 0x5d4c, 0x611f, 
	0x61be, 0x6221, 0x6562, 0x67d1, 0x6a44, 0x6e1b, 0x7518, 0x75b3, 0x76e3, 
	0x77b0, 0x7d3a, 0x90af, 0x9451, 0x9452, 0x9f95, 0x5323, 0x5cac, 0x7532, 
	0x80db, 0x9240, 0x9598, 0x525b, 0x5808, 0x59dc, 0x5ca1, 0x5d17, 0x5eb7, 
	0x5f3a, 0x5f4a, 0x6177, 0x6c5f, 0x757a, 0x7586, 0x7ce0, 0x7d73, 0x7db1, 
	0x7f8c, 0x8154, 0x8221, 0x8591, 0x8941, 0x8b1b, 0x92fc, 0x964d, 0x9c47, 
	0x4ecb, 0x4ef7, 0x500b, 0x51f1, 0x584f, 0x6137, 0x613e, 0x6168, 0x6539, 
	0x69ea, 0x6f11, 0x75a5, 0x7686, 0x76d6, 0x7b87, 0x82a5, 0x84cb, 0xf900, 
	0x93a7, 0x958b, 0x5580, 0x5ba2, 0x5751, 0xf901, 0x7cb3, 0x7fb9, 0x91b5, 
	0x5028, 0x53bb, 0x5c45, 0x5de8, 0x62d2, 0x636e, 0x64da, 0x64e7, 0x6e20, 
	0x70ac, 0x795b, 0x8ddd, 0x8e1e, 0xf902, 0x907d, 0x9245, 0x92f8, 0x4e7e, 
	0x4ef6, 0x5065, 0x5dfe, 0x5efa, 0x6106, 0x6957, 0x8171, 0x8654, 0x8e47, 
	0x9375, 0x9a2b, 0x4e5e, 0x5091, 0x6770, 0x6840, 0x5109, 0x528d, 0x5292, 
	0x6aa2, 0x77bc, 0x9210, 0x9ed4, 0x52ab, 0x602f, 0x8ff2, 0x5048, 0x61a9, 
	0x63ed, 0x64ca, 0x683c, 0x6a84, 0x6fc0, 0x8188, 0x89a1, 0x9694, 0x5805, 
	0x727d, 0x72ac, 0x7504, 0x7d79, 0x7e6d, 0x80a9, 0x898b, 0x8b74, 0x9063, 
	0x9d51, 0x6289, 0x6c7a, 0x6f54, 0x7d50, 0x7f3a, 0x8a23, 0x517c, 0x614a, 
	0x7b9d, 0x8b19, 0x9257, 0x938c, 0x4eac, 0x4fd3, 0x501e, 0x50be, 0x5106, 
	0x52c1, 0x52cd, 0x537f, 0x5770, 0x5883, 0x5e9a, 0x5f91, 0x6176, 0x61ac, 
	0x64ce, 0x656c, 0x666f, 0x66bb, 0x66f4, 0x6897, 0x6d87, 0x7085, 0x70f1, 
	0x749f, 0x74a5, 0x74ca, 0x75d9, 0x786c, 0x78ec, 0x7adf, 0x7af6, 0x7d45, 
	0x7d93, 0x8015, 0x803f, 0x811b, 0x8396, 0x8b66, 0x8f15, 0x9015, 0x93e1, 
	0x9803, 0x9838, 0x9a5a, 0x9be8, 0x4fc2, 0x5553, 0x583a, 0x5951, 0x5b63, 
	0x5c46, 0x60b8, 0x6212, 0x6842, 0x68b0, 0x68e8, 0x6eaa, 0x754c, 0x7678, 
	0x78ce, 0x7a3d, 0x7cfb, 0x7e6b, 0x7e7c, 0x8a08, 0x8aa1, 0x8c3f, 0x968e, 
	0x9dc4, 0x53e4, 0x53e9, 0x544a, 0x5471, 0x56fa, 0x59d1, 0x5b64, 0x5c3b, 
	0x5eab, 0x62f7, 0x6537, 0x6545, 0x6572, 0x66a0, 0x67af, 0x69c1, 0x6cbd, 
	0x75fc, 0x7690, 0x777e, 0x7a3f, 0x7f94, 0x8003, 0x80a1, 0x818f, 0x82e6, 
	0x82fd, 0x83f0, 0x85c1, 0x8831, 0x88b4, 0x8aa5, 0xf903, 0x8f9c, 0x932e, 
	0x96c7, 0x9867, 0x9ad8, 0x9f13, 0x54ed, 0x659b, 0x66f2, 0x688f, 0x7a40, 
	0x8c37, 0x9d60, 0x56f0, 0x5764, 0x5d11, 0x6606, 0x68b1, 0x68cd, 0x6efe, 
	0x7428, 0x889e, 0x9be4, 0x6c68, 0xf904, 0x9aa8, 0x4f9b, 0x516c, 0x5171, 
	0x529f, 0x5b54, 0x5de5, 0x6050, 0x606d, 0x62f1, 0x63a7, 0x653b, 0x73d9, 
	0x7a7a, 0x86a3, 0x8ca2, 0x978f, 0x4e32, 0x5be1, 0x6208, 0x679c, 0x74dc, 
	0x79d1, 0x83d3, 0x8a87, 0x8ab2, 0x8de8, 0x904e, 0x934b, 0x9846, 0x5ed3, 
	0x69e8, 0x85ff, 0x90ed, 0xf905, 0x51a0, 0x5b98, 0x5bec, 0x6163, 0x68fa, 
	0x6b3e, 0x704c, 0x742f, 0x74d8, 0x7ba1, 0x7f50, 0x83c5, 0x89c0, 0x8cab, 
	0x95dc, 0x9928, 0x522e, 0x605d, 0x62ec, 0x9002, 0x4f8a, 0x5149, 0x5321, 
	0x58d9, 0x5ee3, 0x66e0, 0x6d38, 0x709a, 0x72c2, 0x73d6, 0x7b50, 0x80f1, 
	0x945b, 0x5366, 0x639b, 0x7f6b, 0x4e56, 0x5080, 0x584a, 0x58de, 0x602a, 
	0x6127, 0x62d0, 0x69d0, 0x9b41, 0x5b8f, 0x7d18, 0x80b1, 0x8f5f, 0x4ea4, 
	0x50d1, 0x54ac, 0x55ac, 0x5b0c, 0x5da0, 0x5de7, 0x652a, 0x654e, 0x6821, 
	0x6a4b, 0x72e1, 0x768e, 0x77ef, 0x7d5e, 0x7ff9, 0x81a0, 0x854e, 0x86df, 
	0x8f03, 0x8f4e, 0x90ca, 0x9903, 0x9a55, 0x9bab, 0x4e18, 0x4e45, 0x4e5d, 
	0x4ec7, 0x4ff1, 0x5177, 0x52fe, 0x5340, 0x53e3, 0x53e5, 0x548e, 0x5614, 
	0x5775, 0x57a2, 0x5bc7, 0x5d87, 0x5ed0, 0x61fc, 0x62d8, 0x6551, 0x67b8, 
	0x67e9, 0x69cb, 0x6b50, 0x6bc6, 0x6bec, 0x6c42, 0x6e9d, 0x7078, 0x72d7, 
	0x7396, 0x7403, 0x77bf, 0x77e9, 0x7a76, 0x7d7f, 0x8009, 0x81fc, 0x8205, 
	0x820a, 0x82df, 0x8862, 0x8b33, 0x8cfc, 0x8ec0, 0x9011, 0x90b1, 0x9264, 
	0x92b6, 0x99d2, 0x9a45, 0x9ce9, 0x9dd7, 0x9f9c, 0x570b, 0x5c40, 0x83ca, 
	0x97a0, 0x97ab, 0x9eb4, 0x541b, 0x7a98, 0x7fa4, 0x88d9, 0x8ecd, 0x90e1, 
	0x5800, 0x5c48, 0x6398, 0x7a9f, 0x5bae, 0x5f13, 0x7a79, 0x7aae, 0x828e, 
	0x8eac, 0x5026, 0x5238, 0x52f8, 0x5377, 0x5708, 0x62f3, 0x6372, 0x6b0a, 
	0x6dc3, 0x7737, 0x53a5, 0x7357, 0x8568, 0x8e76, 0x95d5, 0x673a, 0x6ac3, 
	0x6f70, 0x8a6d, 0x8ecc, 0x994b, 0xf906, 0x6677, 0x6b78, 0x8cb4, 0x9b3c, 
	0xf907, 0x53eb, 0x572d, 0x594e, 0x63c6, 0x69fb, 0x73ea, 0x7845, 0x7aba, 
	0x7ac5, 0x7cfe, 0x8475, 0x898f, 0x8d73, 0x9035, 0x95a8, 0x52fb, 0x5747, 
	0x7547, 0x7b60, 0x83cc, 0x921e, 0xf908, 0x6a58, 0x514b, 0x524b, 0x5287, 
	0x621f, 0x68d8, 0x6975, 0x9699, 0x50c5, 0x52a4, 0x52e4, 0x61c3, 0x65a4, 
	0x6839, 0x69ff, 0x747e, 0x7b4b, 0x82b9, 0x83eb, 0x89b2, 0x8b39, 0x8fd1, 
	0x9949, 0xf909, 0x4eca, 0x5997, 0x64d2, 0x6611, 0x6a8e, 0x7434, 0x7981, 
	0x79bd, 0x82a9, 0x887e, 0x887f, 0x895f, 0xf90a, 0x9326, 0x4f0b, 0x53ca, 
	0x6025, 0x6271, 0x6c72, 0x7d1a, 0x7d66, 0x4e98, 0x5162, 0x77dc, 0x80af, 
	0x4f01, 0x4f0e, 0x5176, 0x5180, 0x55dc, 0x5668, 0x573b, 0x57fa, 0x57fc, 
	0x5914, 0x5947, 0x5993, 0x5bc4, 0x5c90, 0x5d0e, 0x5df1, 0x5e7e, 0x5fcc, 
	0x6280, 0x65d7, 0x65e3, 0x671e, 0x671f, 0x675e, 0x68cb, 0x68c4, 0x6a5f, 
	0x6b3a, 0x6c23, 0x6c7d, 0x6c82, 0x6dc7, 0x7398, 0x7426, 0x742a, 0x7482, 
	0x74a3, 0x7578, 0x757f, 0x7881, 0x78ef, 0x7941, 0x7947, 0x7948, 0x797a, 
	0x7b95, 0x7d00, 0x7dba, 0x7f88, 0x8006, 0x802d, 0x808c, 0x8a18, 0x8b4f, 
	0x8c48, 0x8d77, 0x9321, 0x9324, 0x98e2, 0x9951, 0x9a0e, 0x9a0f, 0x9a65, 
	0x9e92, 0x7dca, 0x4f76, 0x5409, 0x62ee, 0x6854, 0x91d1, 0x55ab, 0x513a, 
	0xf90b, 0xf90c, 0x5a1c, 0x61e6, 0xf90d, 0x62cf, 0x62ff, 0xf90e, 0xf90f, 
	0xf910, 0xf911, 0xf912, 0xf913, 0x90a3, 0xf914, 0xf915, 0xf916, 0xf917, 
	0xf918, 0x8afe, 0xf919, 0xf91a, 0xf91b, 0xf91c, 0x6696, 0xf91d, 0x7156, 
	0xf91e, 0xf91f, 0x96e3, 0xf920, 0x634f, 0x637a, 0x5357, 0xf921, 0x678f, 
	0x6960, 0x6e73, 0xf922, 0x7537, 0xf923, 0xf924, 0xf925, 0x7d0d, 0xf926, 
	0xf927, 0x8872, 0x56ca, 0x5a18, 0xf928, 0xf929, 0xf92a, 0xf92b, 0xf92c, 
	0x4e43, 0xf92d, 0x5167, 0x5948, 0x67f0, 0x8010, 0xf92e, 0x5973, 0x5e74, 
	0x649a, 0x79ca, 0x5ff5, 0x606c, 0x62c8, 0x637b, 0x5be7, 0x5bd7, 0x52aa, 
	0xf92f, 0x5974, 0x5f29, 0x6012, 0xf930, 0xf931, 0xf932, 0x7459, 0xf933, 
	0xf934, 0xf935, 0xf936, 0xf937, 0xf938, 0x99d1, 0xf939, 0xf93a, 0xf93b, 
	0xf93c, 0xf93d, 0xf93e, 0xf93f, 0xf940, 0xf941, 0xf942, 0xf943, 0x6fc3, 
	0xf944, 0xf945, 0x81bf, 0x8fb2, 0x60f1, 0xf946, 0xf947, 0x8166, 0xf948, 
	0xf949, 0x5c3f, 0xf94a, 0xf94b, 0xf94c, 0xf94d, 0xf94e, 0xf94f, 0xf950, 
	0xf951, 0x5ae9, 0x8a25, 0x677b, 0x7d10, 0xf952, 0xf953, 0xf954, 0xf955, 
	0xf956, 0xf957, 0x80fd, 0xf958, 0xf959, 0x5c3c, 0x6ce5, 0x533f, 0x6eba, 
	0x591a, 0x8336, 0x4e39, 0x4eb6, 0x4f46, 0x55ae, 0x5718, 0x58c7, 0x5f56, 
	0x65b7, 0x65e6, 0x6a80, 0x6bb5, 0x6e4d, 0x77ed, 0x7aef, 0x7c1e, 0x7dde, 
	0x86cb, 0x8892, 0x9132, 0x935b, 0x64bb, 0x6fbe, 0x737a, 0x75b8, 0x9054, 
	0x5556, 0x574d, 0x61ba, 0x64d4, 0x66c7, 0x6de1, 0x6e5b, 0x6f6d, 0x6fb9, 
	0x75f0, 0x8043, 0x81bd, 0x8541, 0x8983, 0x8ac7, 0x8b5a, 0x931f, 0x6c93, 
	0x7553, 0x7b54, 0x8e0f, 0x905d, 0x5510, 0x5802, 0x5858, 0x5e62, 0x6207, 
	0x649e, 0x68e0, 0x7576, 0x7cd6, 0x87b3, 0x9ee8, 0x4ee3, 0x5788, 0x576e, 
	0x5927, 0x5c0d, 0x5cb1, 0x5e36, 0x5f85, 0x6234, 0x64e1, 0x73b3, 0x81fa, 
	0x888b, 0x8cb8, 0x968a, 0x9edb, 0x5b85, 0x5fb7, 0x60b3, 0x5012, 0x5200, 
	0x5230, 0x5716, 0x5835, 0x5857, 0x5c0e, 0x5c60, 0x5cf6, 0x5d8b, 0x5ea6, 
	0x5f92, 0x60bc, 0x6311, 0x6389, 0x6417, 0x6843, 0x68f9, 0x6ac2, 0x6dd8, 
	0x6e21, 0x6ed4, 0x6fe4, 0x71fe, 0x76dc, 0x7779, 0x79b1, 0x7a3b, 0x8404, 
	0x89a9, 0x8ced, 0x8df3, 0x8e48, 0x9003, 0x9014, 0x9053, 0x90fd, 0x934d, 
	0x9676, 0x97dc, 0x6bd2, 0x7006, 0x7258, 0x72a2, 0x7368, 0x7763, 0x79bf, 
	0x7be4, 0x7e9b, 0x8b80, 0x58a9, 0x60c7, 0x6566, 0x65fd, 0x66be, 0x6c8c, 
	0x711e, 0x71c9, 0x8c5a, 0x9813, 0x4e6d, 0x7a81, 0x4edd, 0x51ac, 0x51cd, 
	0x52d5, 0x540c, 0x61a7, 0x6771, 0x6850, 0x68df, 0x6d1e, 0x6f7c, 0x75bc, 
	0x77b3, 0x7ae5, 0x80f4, 0x8463, 0x9285, 0x515c, 0x6597, 0x675c, 0x6793, 
	0x75d8, 0x7ac7, 0x8373, 0xf95a, 0x8c46, 0x9017, 0x982d, 0x5c6f, 0x81c0, 
	0x829a, 0x9041, 0x906f, 0x920d, 0x5f97, 0x5d9d, 0x6a59, 0x71c8, 0x767b, 
	0x7b49, 0x85e4, 0x8b04, 0x9127, 0x9a30, 0x5587, 0x61f6, 0xf95b, 0x7669, 
	0x7f85, 0x863f, 0x87ba, 0x88f8, 0x908f, 0xf95c, 0x6d1b, 0x70d9, 0x73de, 
	0x7d61, 0x843d, 0xf95d, 0x916a, 0x99f1, 0xf95e, 0x4e82, 0x5375, 0x6b04, 
	0x6b12, 0x703e, 0x721b, 0x862d, 0x9e1e, 0x524c, 0x8fa3, 0x5d50, 0x64e5, 
	0x652c, 0x6b16, 0x6feb, 0x7c43, 0x7e9c, 0x85cd, 0x8964, 0x89bd, 0x62c9, 
	0x81d8, 0x881f, 0x5eca, 0x6717, 0x6d6a, 0x72fc, 0x7405, 0x746f, 0x8782, 
	0x90de, 0x4f86, 0x5d0d, 0x5fa0, 0x840a, 0x51b7, 0x63a0, 0x7565, 0x4eae, 
	0x5006, 0x5169, 0x51c9, 0x6881, 0x6a11, 0x7cae, 0x7cb1, 0x7ce7, 0x826f, 
	0x8ad2, 0x8f1b, 0x91cf, 0x4fb6, 0x5137, 0x52f5, 0x5442, 0x5eec, 0x616e, 
	0x623e, 0x65c5, 0x6ada, 0x6ffe, 0x792a, 0x85dc, 0x8823, 0x95ad, 0x9a62, 
	0x9a6a, 0x9e97, 0x9ece, 0x529b, 0x66c6, 0x6b77, 0x701d, 0x792b, 0x8f62, 
	0x9742, 0x6190, 0x6200, 0x6523, 0x6f23, 0x7149, 0x7489, 0x7df4, 0x806f, 
	0x84ee, 0x8f26, 0x9023, 0x934a, 0x51bd, 0x5217, 0x52a3, 0x6d0c, 0x70c8, 
	0x88c2, 0x5ec9, 0x6582, 0x6bae, 0x6fc2, 0x7c3e, 0x7375, 0x4ee4, 0x4f36, 
	0x56f9, 0xf95f, 0x5cba, 0x5dba, 0x601c, 0x73b2, 0x7b2d, 0x7f9a, 0x7fce, 
	0x8046, 0x901e, 0x9234, 0x96f6, 0x9748, 0x9818, 0x9f61, 0x4f8b, 0x6fa7, 
	0x79ae, 0x91b4, 0x96b7, 0x52de, 0xf960, 0x6488, 0x64c4, 0x6ad3, 0x6f5e, 
	0x7018, 0x7210, 0x76e7, 0x8001, 0x8606, 0x865c, 0x8def, 0x8f05, 0x9732, 
	0x9b6f, 0x9dfa, 0x9e75, 0x788c, 0x797f, 0x7da0, 0x83c9, 0x9304, 0x9e7f, 
	0x9e93, 0x8ad6, 0x58df, 0x5f04, 0x6727, 0x7027, 0x74cf, 0x7c60, 0x807e, 
	0x5121, 0x7028, 0x7262, 0x78ca, 0x8cc2, 0x8cda, 0x8cf4, 0x96f7, 0x4e86, 
	0x50da, 0x5bee, 0x5ed6, 0x6599, 0x71ce, 0x7642, 0x77ad, 0x804a, 0x84fc, 
	0x907c, 0x9b27, 0x9f8d, 0x58d8, 0x5a41, 0x5c62, 0x6a13, 0x6dda, 0x6f0f, 
	0x763b, 0x7d2f, 0x7e37, 0x851e, 0x8938, 0x93e4, 0x964b, 0x5289, 0x65d2, 
	0x67f3, 0x69b4, 0x6d41, 0x6e9c, 0x700f, 0x7409, 0x7460, 0x7559, 0x7624, 
	0x786b, 0x8b2c, 0x985e, 0x516d, 0x622e, 0x9678, 0x4f96, 0x502b, 0x5d19, 
	0x6dea, 0x7db8, 0x8f2a, 0x5f8b, 0x6144, 0x6817, 0xf961, 0x9686, 0x52d2, 
	0x808b, 0x51dc, 0x51cc, 0x695e, 0x7a1c, 0x7dbe, 0x83f1, 0x9675, 0x4fda, 
	0x5229, 0x5398, 0x540f, 0x550e, 0x5c65, 0x60a7, 0x674e, 0x68a8, 0x6d6c, 
	0x7281, 0x72f8, 0x7406, 0x7483, 0xf962, 0x75e2, 0x7c6c, 0x7f79, 0x7fb8, 
	0x8389, 0x88cf, 0x88e1, 0x91cc, 0x91d0, 0x96e2, 0x9bc9, 0x541d, 0x6f7e, 
	0x71d0, 0x7498, 0x85fa, 0x8eaa, 0x96a3, 0x9c57, 0x9e9f, 0x6797, 0x6dcb, 
	0x7433, 0x81e8, 0x9716, 0x782c, 0x7acb, 0x7b20, 0x7c92, 0x6469, 0x746a, 
	0x75f2, 0x78bc, 0x78e8, 0x99ac, 0x9b54, 0x9ebb, 0x5bde, 0x5e55, 0x6f20, 
	0x819c, 0x83ab, 0x9088, 0x4e07, 0x534d, 0x5a29, 0x5dd2, 0x5f4e, 0x6162, 
	0x633d, 0x6669, 0x66fc, 0x6eff, 0x6f2b, 0x7063, 0x779e, 0x842c, 0x8513, 
	0x883b, 0x8f13, 0x9945, 0x9c3b, 0x551c, 0x62b9, 0x672b, 0x6cab, 0x8309, 
	0x896a, 0x977a, 0x4ea1, 0x5984, 0x5fd8, 0x5fd9, 0x671b, 0x7db2, 0x7f54, 
	0x8292, 0x832b, 0x83bd, 0x8f1e, 0x9099, 0x57cb, 0x59b9, 0x5a92, 0x5bd0, 
	0x6627, 0x679a, 0x6885, 0x6bcf, 0x7164, 0x7f75, 0x8cb7, 0x8ce3, 0x9081, 
	0x9b45, 0x8108, 0x8c8a, 0x964c, 0x9a40, 0x9ea5, 0x5b5f, 0x6c13, 0x731b, 
	0x76f2, 0x76df, 0x840c, 0x51aa, 0x8993, 0x514d, 0x5195, 0x52c9, 0x68c9, 
	0x6c94, 0x7704, 0x7720, 0x7dbf, 0x7dec, 0x9762, 0x9eb5, 0x6ec5, 0x8511, 
	0x51a5, 0x540d, 0x547d, 0x660e, 0x669d, 0x6927, 0x6e9f, 0x76bf, 0x7791, 
	0x8317, 0x84c2, 0x879f, 0x9169, 0x9298, 0x9cf4, 0x8882, 0x4fae, 0x5192, 
	0x52df, 0x59c6, 0x5e3d, 0x6155, 0x6478, 0x6479, 0x66ae, 0x67d0, 0x6a21, 
	0x6bcd, 0x6bdb, 0x725f, 0x7261, 0x7441, 0x7738, 0x77db, 0x8017, 0x82bc, 
	0x8305, 0x8b00, 0x8b28, 0x8c8c, 0x6728, 0x6c90, 0x7267, 0x76ee, 0x7766, 
	0x7a46, 0x9da9, 0x6b7f, 0x6c92, 0x5922, 0x6726, 0x8499, 0x536f, 0x5893, 
	0x5999, 0x5edf, 0x63cf, 0x6634, 0x6773, 0x6e3a, 0x732b, 0x7ad7, 0x82d7, 
	0x9328, 0x52d9, 0x5deb, 0x61ae, 0x61cb, 0x620a, 0x62c7, 0x64ab, 0x65e0, 
	0x6959, 0x6b66, 0x6bcb, 0x7121, 0x73f7, 0x755d, 0x7e46, 0x821e, 0x8302, 
	0x856a, 0x8aa3, 0x8cbf, 0x9727, 0x9d61, 0x58a8, 0x9ed8, 0x5011, 0x520e, 
	0x543b, 0x554f, 0x6587, 0x6c76, 0x7d0a, 0x7d0b, 0x805e, 0x868a, 0x9580, 
	0x96ef, 0x52ff, 0x6c95, 0x7269, 0x5473, 0x5a9a, 0x5c3e, 0x5d4b, 0x5f4c, 
	0x5fae, 0x672a, 0x68b6, 0x6963, 0x6e3c, 0x6e44, 0x7709, 0x7c73, 0x7f8e, 
	0x8587, 0x8b0e, 0x8ff7, 0x9761, 0x9ef4, 0x5cb7, 0x60b6, 0x610d, 0x61ab, 
	0x654f, 0x65fb, 0x65fc, 0x6c11, 0x6cef, 0x739f, 0x73c9, 0x7de1, 0x9594, 
	0x5bc6, 0x871c, 0x8b10, 0x525d, 0x535a, 0x62cd, 0x640f, 0x64b2, 0x6734, 
	0x6a38, 0x6cca, 0x73c0, 0x749e, 0x7b94, 0x7c95, 0x7e1b, 0x818a, 0x8236, 
	0x8584, 0x8feb, 0x96f9, 0x99c1, 0x4f34, 0x534a, 0x53cd, 0x53db, 0x62cc, 
	0x642c, 0x6500, 0x6591, 0x69c3, 0x6cee, 0x6f58, 0x73ed, 0x7554, 0x7622, 
	0x76e4, 0x76fc, 0x78d0, 0x78fb, 0x792c, 0x7d46, 0x822c, 0x87e0, 0x8fd4, 
	0x9812, 0x98ef, 0x52c3, 0x62d4, 0x64a5, 0x6e24, 0x6f51, 0x767c, 0x8dcb, 
	0x91b1, 0x9262, 0x9aee, 0x9b43, 0x5023, 0x508d, 0x574a, 0x59a8, 0x5c28, 
	0x5e47, 0x5f77, 0x623f, 0x653e, 0x65b9, 0x65c1, 0x6609, 0x678b, 0x699c, 
	0x6ec2, 0x78c5, 0x7d21, 0x80aa, 0x8180, 0x822b, 0x82b3, 0x84a1, 0x868c, 
	0x8a2a, 0x8b17, 0x90a6, 0x9632, 0x9f90, 0x500d, 0x4ff3, 0xf963, 0x57f9, 
	0x5f98, 0x62dc, 0x6392, 0x676f, 0x6e43, 0x7119, 0x76c3, 0x80cc, 0x80da, 
	0x88f4, 0x88f5, 0x8919, 0x8ce0, 0x8f29, 0x914d, 0x966a, 0x4f2f, 0x4f70, 
	0x5e1b, 0x67cf, 0x6822, 0x767d, 0x767e, 0x9b44, 0x5e61, 0x6a0a, 0x7169, 
	0x71d4, 0x756a, 0xf964, 0x7e41, 0x8543, 0x85e9, 0x98dc, 0x4f10, 0x7b4f, 
	0x7f70, 0x95a5, 0x51e1, 0x5e06, 0x68b5, 0x6c3e, 0x6c4e, 0x6cdb, 0x72af, 
	0x7bc4, 0x8303, 0x6cd5, 0x743a, 0x50fb, 0x5288, 0x58c1, 0x64d8, 0x6a97, 
	0x74a7, 0x7656, 0x78a7, 0x8617, 0x95e2, 0x9739, 0xf965, 0x535e, 0x5f01, 
	0x8b8a, 0x8fa8, 0x8faf, 0x908a, 0x5225, 0x77a5, 0x9c49, 0x9f08, 0x4e19, 
	0x5002, 0x5175, 0x5c5b, 0x5e77, 0x661e, 0x663a, 0x67c4, 0x68c5, 0x70b3, 
	0x7501, 0x75c5, 0x79c9, 0x7add, 0x8f27, 0x9920, 0x9a08, 0x4fdd, 0x5821, 
	0x5831, 0x5bf6, 0x666e, 0x6b65, 0x6d11, 0x6e7a, 0x6f7d, 0x73e4, 0x752b, 
	0x83e9, 0x88dc, 0x8913, 0x8b5c, 0x8f14, 0x4f0f, 0x50d5, 0x5310, 0x535c, 
	0x5b93, 0x5fa9, 0x670d, 0x798f, 0x8179, 0x832f, 0x8514, 0x8907, 0x8986, 
	0x8f39, 0x8f3b, 0x99a5, 0x9c12, 0x672c, 0x4e76, 0x4ff8, 0x5949, 0x5c01, 
	0x5cef, 0x5cf0, 0x6367, 0x68d2, 0x70fd, 0x71a2, 0x742b, 0x7e2b, 0x84ec, 
	0x8702, 0x9022, 0x92d2, 0x9cf3, 0x4e0d, 0x4ed8, 0x4fef, 0x5085, 0x5256, 
	0x526f, 0x5426, 0x5490, 0x57e0, 0x592b, 0x5a66, 0x5b5a, 0x5b75, 0x5bcc, 
	0x5e9c, 0xf966, 0x6276, 0x6577, 0x65a7, 0x6d6e, 0x6ea5, 0x7236, 0x7b26, 
	0x7c3f, 0x7f36, 0x8150, 0x8151, 0x819a, 0x8240, 0x8299, 0x83a9, 0x8a03, 
	0x8ca0, 0x8ce6, 0x8cfb, 0x8d74, 0x8dba, 0x90e8, 0x91dc, 0x961c, 0x9644, 
	0x99d9, 0x9ce7, 0x5317, 0x5206, 0x5429, 0x5674, 0x58b3, 0x5954, 0x596e, 
	0x5fff, 0x61a4, 0x626e, 0x6610, 0x6c7e, 0x711a, 0x76c6, 0x7c89, 0x7cde, 
	0x7d1b, 0x82ac, 0x8cc1, 0x96f0, 0xf967, 0x4f5b, 0x5f17, 0x5f7f, 0x62c2, 
	0x5d29, 0x670b, 0x68da, 0x787c, 0x7e43, 0x9d6c, 0x4e15, 0x5099, 0x5315, 
	0x532a, 0x5351, 0x5983, 0x5a62, 0x5e87, 0x60b2, 0x618a, 0x6249, 0x6279, 
	0x6590, 0x6787, 0x69a7, 0x6bd4, 0x6bd6, 0x6bd7, 0x6bd8, 0x6cb8, 0xf968, 
	0x7435, 0x75fa, 0x7812, 0x7891, 0x79d5, 0x79d8, 0x7c83, 0x7dcb, 0x7fe1, 
	0x80a5, 0x813e, 0x81c2, 0x83f2, 0x871a, 0x88e8, 0x8ab9, 0x8b6c, 0x8cbb, 
	0x9119, 0x975e, 0x98db, 0x9f3b, 0x56ac, 0x5b2a, 0x5f6c, 0x658c, 0x6ab3, 
	0x6baf, 0x6d5c, 0x6ff1, 0x7015, 0x725d, 0x73ad, 0x8ca7, 0x8cd3, 0x983b, 
	0x6191, 0x6c37, 0x8058, 0x9a01, 0x4e4d, 0x4e8b, 0x4e9b, 0x4ed5, 0x4f3a, 
	0x4f3c, 0x4f7f, 0x4fdf, 0x50ff, 0x53f2, 0x53f8, 0x5506, 0x55e3, 0x56db, 
	0x58eb, 0x5962, 0x5a11, 0x5beb, 0x5bfa, 0x5c04, 0x5df3, 0x5e2b, 0x5f99, 
	0x601d, 0x6368, 0x659c, 0x65af, 0x67f6, 0x67fb, 0x68ad, 0x6b7b, 0x6c99, 
	0x6cd7, 0x6e23, 0x7009, 0x7345, 0x7802, 0x793e, 0x7940, 0x7960, 0x79c1, 
	0x7be9, 0x7d17, 0x7d72, 0x8086, 0x820d, 0x838e, 0x84d1, 0x86c7, 0x88df, 
	0x8a50, 0x8a5e, 0x8b1d, 0x8cdc, 0x8d66, 0x8fad, 0x90aa, 0x98fc, 0x99df, 
	0x9e9d, 0x524a, 0xf969, 0x6714, 0xf96a, 0x5098, 0x522a, 0x5c71, 0x6563, 
	0x6c55, 0x73ca, 0x7523, 0x759d, 0x7b97, 0x849c, 0x9178, 0x9730, 0x4e77, 
	0x6492, 0x6bba, 0x715e, 0x85a9, 0x4e09, 0xf96b, 0x6749, 0x68ee, 0x6e17, 
	0x829f, 0x8518, 0x886b, 0x63f7, 0x6f81, 0x9212, 0x98af, 0x4e0a, 0x50b7, 
	0x50cf, 0x511f, 0x5546, 0x55aa, 0x5617, 0x5b40, 0x5c19, 0x5ce0, 0x5e38, 
	0x5e8a, 0x5ea0, 0x5ec2, 0x60f3, 0x6851, 0x6a61, 0x6e58, 0x723d, 0x7240, 
	0x72c0, 0x76f8, 0x7965, 0x7bb1, 0x7fd4, 0x88f3, 0x89f4, 0x8a73, 0x8c61, 
	0x8cde, 0x971c, 0x585e, 0x74bd, 0x8cfd, 0x55c7, 0xf96c, 0x7a61, 0x7d22, 
	0x8272, 0x7272, 0x751f, 0x7525, 0xf96d, 0x7b19, 0x5885, 0x58fb, 0x5dbc, 
	0x5e8f, 0x5eb6, 0x5f90, 0x6055, 0x6292, 0x637f, 0x654d, 0x6691, 0x66d9, 
	0x66f8, 0x6816, 0x68f2, 0x7280, 0x745e, 0x7b6e, 0x7d6e, 0x7dd6, 0x7f72, 
	0x80e5, 0x8212, 0x85af, 0x897f, 0x8a93, 0x901d, 0x92e4, 0x9ecd, 0x9f20, 
	0x5915, 0x596d, 0x5e2d, 0x60dc, 0x6614, 0x6673, 0x6790, 0x6c50, 0x6dc5, 
	0x6f5f, 0x77f3, 0x78a9, 0x84c6, 0x91cb, 0x932b, 0x4ed9, 0x50ca, 0x5148, 
	0x5584, 0x5b0b, 0x5ba3, 0x6247, 0x657e, 0x65cb, 0x6e32, 0x717d, 0x7401, 
	0x7444, 0x7487, 0x74bf, 0x766c, 0x79aa, 0x7dda, 0x7e55, 0x7fa8, 0x817a, 
	0x81b3, 0x8239, 0x861a, 0x87ec, 0x8a75, 0x8de3, 0x9078, 0x9291, 0x9425, 
	0x994d, 0x9bae, 0x5368, 0x5c51, 0x6954, 0x6cc4, 0x6d29, 0x6e2b, 0x820c, 
	0x859b, 0x893b, 0x8a2d, 0x8aaa, 0x96ea, 0x9f67, 0x5261, 0x66b9, 0x6bb2, 
	0x7e96, 0x87fe, 0x8d0d, 0x9583, 0x965d, 0x651d, 0x6d89, 0x71ee, 0xf96e, 
	0x57ce, 0x59d3, 0x5bac, 0x6027, 0x60fa, 0x6210, 0x661f, 0x665f, 0x7329, 
	0x73f9, 0x76db, 0x7701, 0x7b6c, 0x8056, 0x8072, 0x8165, 0x8aa0, 0x9192, 
	0x4e16, 0x52e2, 0x6b72, 0x6d17, 0x7a05, 0x7b39, 0x7d30, 0xf96f, 0x8cb0, 
	0x53ec, 0x562f, 0x5851, 0x5bb5, 0x5c0f, 0x5c11, 0x5de2, 0x6240, 0x6383, 
	0x6414, 0x662d, 0x68b3, 0x6cbc, 0x6d88, 0x6eaf, 0x701f, 0x70a4, 0x71d2, 
	0x7526, 0x758f, 0x758e, 0x7619, 0x7b11, 0x7be0, 0x7c2b, 0x7d20, 0x7d39, 
	0x852c, 0x856d, 0x8607, 0x8a34, 0x900d, 0x9061, 0x90b5, 0x92b7, 0x97f6, 
	0x9a37, 0x4fd7, 0x5c6c, 0x675f, 0x6d91, 0x7c9f, 0x7e8c, 0x8b16, 0x8d16, 
	0x901f, 0x5b6b, 0x5dfd, 0x640d, 0x84c0, 0x905c, 0x98e1, 0x7387, 0x5b8b, 
	0x609a, 0x677e, 0x6dde, 0x8a1f, 0x8aa6, 0x9001, 0x980c, 0x5237, 0xf970, 
	0x7051, 0x788e, 0x9396, 0x8870, 0x91d7, 0x4fee, 0x53d7, 0x55fd, 0x56da, 
	0x5782, 0x58fd, 0x5ac2, 0x5b88, 0x5cab, 0x5cc0, 0x5e25, 0x6101, 0x620d, 
	0x624b, 0x6388, 0x641c, 0x6536, 0x6578, 0x6a39, 0x6b8a, 0x6c34, 0x6d19, 
	0x6f31, 0x71e7, 0x72e9, 0x7378, 0x7407, 0x74b2, 0x7626, 0x7761, 0x79c0, 
	0x7a57, 0x7aea, 0x7cb9, 0x7d8f, 0x7dac, 0x7e61, 0x7f9e, 0x8129, 0x8331, 
	0x8490, 0x84da, 0x85ea, 0x8896, 0x8ab0, 0x8b90, 0x8f38, 0x9042, 0x9083, 
	0x916c, 0x9296, 0x92b9, 0x968b, 0x96a7, 0x96a8, 0x96d6, 0x9700, 0x9808, 
	0x9996, 0x9ad3, 0x9b1a, 0x53d4, 0x587e, 0x5919, 0x5b70, 0x5bbf, 0x6dd1, 
	0x6f5a, 0x719f, 0x7421, 0x74b9, 0x8085, 0x83fd, 0x5de1, 0x5f87, 0x5faa, 
	0x6042, 0x65ec, 0x6812, 0x696f, 0x6a53, 0x6b89, 0x6d35, 0x6df3, 0x73e3, 
	0x76fe, 0x77ac, 0x7b4d, 0x7d14, 0x8123, 0x821c, 0x8340, 0x84f4, 0x8563, 
	0x8a62, 0x8ac4, 0x9187, 0x931e, 0x9806, 0x99b4, 0x620c, 0x8853, 0x8ff0, 
	0x9265, 0x5d07, 0x5d27, 0x5d69, 0x745f, 0x819d, 0x8768, 0x6fd5, 0x62fe, 
	0x7fd2, 0x8936, 0x8972, 0x4e1e, 0x4e58, 0x50e7, 0x52dd, 0x5347, 0x627f, 
	0x6607, 0x7e69, 0x8805, 0x965e, 0x4f8d, 0x5319, 0x5636, 0x59cb, 0x5aa4, 
	0x5c38, 0x5c4e, 0x5c4d, 0x5e02, 0x5f11, 0x6043, 0x65bd, 0x662f, 0x6642, 
	0x67be, 0x67f4, 0x731c, 0x77e2, 0x793a, 0x7fc5, 0x8494, 0x84cd, 0x8996, 
	0x8a66, 0x8a69, 0x8ae1, 0x8c55, 0x8c7a, 0x57f4, 0x5bd4, 0x5f0f, 0x606f, 
	0x62ed, 0x690d, 0x6b96, 0x6e5c, 0x7184, 0x7bd2, 0x8755, 0x8b58, 0x8efe, 
	0x98df, 0x98fe, 0x4f38, 0x4f81, 0x4fe1, 0x547b, 0x5a20, 0x5bb8, 0x613c, 
	0x65b0, 0x6668, 0x71fc, 0x7533, 0x795e, 0x7d33, 0x814e, 0x81e3, 0x8398, 
	0x85aa, 0x85ce, 0x8703, 0x8a0a, 0x8eab, 0x8f9b, 0xf971, 0x8fc5, 0x5931, 
	0x5ba4, 0x5be6, 0x6089, 0x5be9, 0x5c0b, 0x5fc3, 0x6c81, 0xf972, 0x6df1, 
	0x700b, 0x751a, 0x82af, 0x8af6, 0x4ec0, 0x5341, 0xf973, 0x96d9, 0x6c0f, 
	0x4e9e, 0x4fc4, 0x5152, 0x555e, 0x5a25, 0x5ce8, 0x6211, 0x7259, 0x82bd, 
	0x83aa, 0x86fe, 0x8859, 0x8a1d, 0x963f, 0x96c5, 0x9913, 0x9d09, 0x9d5d, 
	0x580a, 0x5cb3, 0x5dbd, 0x5e44, 0x60e1, 0x6115, 0x63e1, 0x6a02, 0x6e25, 
	0x9102, 0x9354, 0x984e, 0x9c10, 0x9f77, 0x5b89, 0x5cb8, 0x6309, 0x664f, 
	0x6848, 0x773c, 0x96c1, 0x978d, 0x9854, 0x9b9f, 0x65a1, 0x8b01, 0x8ecb, 
	0x95bc, 0x5535, 0x5ca9, 0x5dd6, 0x5eb5, 0x6697, 0x764c, 0x83f4, 0x95c7, 
	0x58d3, 0x62bc, 0x72ce, 0x9d28, 0x4ef0, 0x592e, 0x600f, 0x663b, 0x6b83, 
	0x79e7, 0x9d26, 0x5393, 0x54c0, 0x57c3, 0x5d16, 0x611b, 0x66d6, 0x6daf, 
	0x788d, 0x827e, 0x9698, 0x9744, 0x5384, 0x627c, 0x6396, 0x6db2, 0x7e0a, 
	0x814b, 0x984d, 0x6afb, 0x7f4c, 0x9daf, 0x9e1a, 0x4e5f, 0x503b, 0x51b6, 
	0x591c, 0x60f9, 0x63f6, 0x6930, 0x723a, 0x8036, 0xf974, 0x91ce, 0x5f31, 
	0xf975, 0xf976, 0x7d04, 0x82e5, 0x846f, 0x84bb, 0x85e5, 0x8e8d, 0xf977, 
	0x4f6f, 0xf978, 0xf979, 0x58e4, 0x5b43, 0x6059, 0x63da, 0x6518, 0x656d, 
	0x6698, 0xf97a, 0x694a, 0x6a23, 0x6d0b, 0x7001, 0x716c, 0x75d2, 0x760d, 
	0x79b3, 0x7a70, 0xf97b, 0x7f8a, 0xf97c, 0x8944, 0xf97d, 0x8b93, 0x91c0, 
	0x967d, 0xf97e, 0x990a, 0x5704, 0x5fa1, 0x65bc, 0x6f01, 0x7600, 0x79a6, 
	0x8a9e, 0x99ad, 0x9b5a, 0x9f6c, 0x5104, 0x61b6, 0x6291, 0x6a8d, 0x81c6, 
	0x5043, 0x5830, 0x5f66, 0x7109, 0x8a00, 0x8afa, 0x5b7c, 0x8616, 0x4ffa, 
	0x513c, 0x56b4, 0x5944, 0x63a9, 0x6df9, 0x5daa, 0x696d, 0x5186, 0x4e88, 
	0x4f59, 0xf97f, 0xf980, 0xf981, 0x5982, 0xf982, 0xf983, 0x6b5f, 0x6c5d, 
	0xf984, 0x74b5, 0x7916, 0xf985, 0x8207, 0x8245, 0x8339, 0x8f3f, 0x8f5d, 
	0xf986, 0x9918, 0xf987, 0xf988, 0xf989, 0x4ea6, 0xf98a, 0x57df, 0x5f79, 
	0x6613, 0xf98b, 0xf98c, 0x75ab, 0x7e79, 0x8b6f, 0xf98d, 0x9006, 0x9a5b, 
	0x56a5, 0x5827, 0x59f8, 0x5a1f, 0x5bb4, 0xf98e, 0x5ef6, 0xf98f, 0xf990, 
	0x6350, 0x633b, 0xf991, 0x693d, 0x6c87, 0x6cbf, 0x6d8e, 0x6d93, 0x6df5, 
	0x6f14, 0xf992, 0x70df, 0x7136, 0x7159, 0xf993, 0x71c3, 0x71d5, 0xf994, 
	0x784f, 0x786f, 0xf995, 0x7b75, 0x7de3, 0xf996, 0x7e2f, 0xf997, 0x884d, 
	0x8edf, 0xf998, 0xf999, 0xf99a, 0x925b, 0xf99b, 0x9cf6, 0xf99c, 0xf99d, 
	0xf99e, 0x6085, 0x6d85, 0xf99f, 0x71b1, 0xf9a0, 0xf9a1, 0x95b1, 0x53ad, 
	0xf9a2, 0xf9a3, 0xf9a4, 0x67d3, 0xf9a5, 0x708e, 0x7130, 0x7430, 0x8276, 
	0x82d2, 0xf9a6, 0x95bb, 0x9ae5, 0x9e7d, 0x66c4, 0xf9a7, 0x71c1, 0x8449, 
	0xf9a8, 0xf9a9, 0x584b, 0xf9aa, 0xf9ab, 0x5db8, 0x5f71, 0xf9ac, 0x6620, 
	0x668e, 0x6979, 0x69ae, 0x6c38, 0x6cf3, 0x6e36, 0x6f41, 0x6fda, 0x701b, 
	0x702f, 0x7150, 0x71df, 0x7370, 0xf9ad, 0x745b, 0xf9ae, 0x74d4, 0x76c8, 
	0x7a4e, 0x7e93, 0xf9af, 0xf9b0, 0x82f1, 0x8a60, 0x8fce, 0xf9b1, 0x9348, 
	0xf9b2, 0x9719, 0xf9b3, 0xf9b4, 0x4e42, 0x502a, 0xf9b5, 0x5208, 0x53e1, 
	0x66f3, 0x6c6d, 0x6fca, 0x730a, 0x777f, 0x7a62, 0x82ae, 0x85dd, 0x8602, 
	0xf9b6, 0x88d4, 0x8a63, 0x8b7d, 0x8c6b, 0xf9b7, 0x92b3, 0xf9b8, 0x9713, 
	0x9810, 0x4e94, 0x4f0d, 0x4fc9, 0x50b2, 0x5348, 0x543e, 0x5433, 0x55da, 
	0x5862, 0x58ba, 0x5967, 0x5a1b, 0x5be4, 0x609f, 0xf9b9, 0x61ca, 0x6556, 
	0x65ff, 0x6664, 0x68a7, 0x6c5a, 0x6fb3, 0x70cf, 0x71ac, 0x7352, 0x7b7d, 
	0x8708, 0x8aa4, 0x9c32, 0x9f07, 0x5c4b, 0x6c83, 0x7344, 0x7389, 0x923a, 
	0x6eab, 0x7465, 0x761f, 0x7a69, 0x7e15, 0x860a, 0x5140, 0x58c5, 0x64c1, 
	0x74ee, 0x7515, 0x7670, 0x7fc1, 0x9095, 0x96cd, 0x9954, 0x6e26, 0x74e6, 
	0x7aa9, 0x7aaa, 0x81e5, 0x86d9, 0x8778, 0x8a1b, 0x5a49, 0x5b8c, 0x5b9b, 
	0x68a1, 0x6900, 0x6d63, 0x73a9, 0x7413, 0x742c, 0x7897, 0x7de9, 0x7feb, 
	0x8118, 0x8155, 0x839e, 0x8c4c, 0x962e, 0x9811, 0x66f0, 0x5f80, 0x65fa, 
	0x6789, 0x6c6a, 0x738b, 0x502d, 0x5a03, 0x6b6a, 0x77ee, 0x5916, 0x5d6c, 
	0x5dcd, 0x7325, 0x754f, 0xf9ba, 0xf9bb, 0x50e5, 0x51f9, 0x582f, 0x592d, 
	0x5996, 0x59da, 0x5be5, 0xf9bc, 0xf9bd, 0x5da2, 0x62d7, 0x6416, 0x6493, 
	0x64fe, 0xf9be, 0x66dc, 0xf9bf, 0x6a48, 0xf9c0, 0x71ff, 0x7464, 0xf9c1, 
	0x7a88, 0x7aaf, 0x7e47, 0x7e5e, 0x8000, 0x8170, 0xf9c2, 0x87ef, 0x8981, 
	0x8b20, 0x9059, 0xf9c3, 0x9080, 0x9952, 0x617e, 0x6b32, 0x6d74, 0x7e1f, 
	0x8925, 0x8fb1, 0x4fd1, 0x50ad, 0x5197, 0x52c7, 0x57c7, 0x5889, 0x5bb9, 
	0x5eb8, 0x6142, 0x6995, 0x6d8c, 0x6e67, 0x6eb6, 0x7194, 0x7462, 0x7528, 
	0x752c, 0x8073, 0x8338, 0x84c9, 0x8e0a, 0x9394, 0x93de, 0xf9c4, 0x4e8e, 
	0x4f51, 0x5076, 0x512a, 0x53c8, 0x53cb, 0x53f3, 0x5b87, 0x5bd3, 0x5c24, 
	0x611a, 0x6182, 0x65f4, 0x725b, 0x7397, 0x7440, 0x76c2, 0x7950, 0x7991, 
	0x79b9, 0x7d06, 0x7fbd, 0x828b, 0x85d5, 0x865e, 0x8fc2, 0x9047, 0x90f5, 
	0x91ea, 0x9685, 0x96e8, 0x96e9, 0x52d6, 0x5f67, 0x65ed, 0x6631, 0x682f, 
	0x715c, 0x7a36, 0x90c1, 0x980a, 0x4e91, 0xf9c5, 0x6a52, 0x6b9e, 0x6f90, 
	0x7189, 0x8018, 0x82b8, 0x8553, 0x904b, 0x9695, 0x96f2, 0x97fb, 0x851a, 
	0x9b31, 0x4e90, 0x718a, 0x96c4, 0x5143, 0x539f, 0x54e1, 0x5713, 0x5712, 
	0x57a3, 0x5a9b, 0x5ac4, 0x5bc3, 0x6028, 0x613f, 0x63f4, 0x6c85, 0x6d39, 
	0x6e72, 0x6e90, 0x7230, 0x733f, 0x7457, 0x82d1, 0x8881, 0x8f45, 0x9060, 
	0xf9c6, 0x9662, 0x9858, 0x9d1b, 0x6708, 0x8d8a, 0x925e, 0x4f4d, 0x5049, 
	0x50de, 0x5371, 0x570d, 0x59d4, 0x5a01, 0x5c09, 0x6170, 0x6690, 0x6e2d, 
	0x7232, 0x744b, 0x7def, 0x80c3, 0x840e, 0x8466, 0x853f, 0x875f, 0x885b, 
	0x8918, 0x8b02, 0x9055, 0x97cb, 0x9b4f, 0x4e73, 0x4f91, 0x5112, 0x516a, 
	0xf9c7, 0x552f, 0x55a9, 0x5b7a, 0x5ba5, 0x5e7c, 0x5e7d, 0x5ebe, 0x60a0, 
	0x60df, 0x6108, 0x6109, 0x63c4, 0x6538, 0x6709, 0xf9c8, 0x67d4, 0x67da, 
	0xf9c9, 0x6961, 0x6962, 0x6cb9, 0x6d27, 0xf9ca, 0x6e38, 0xf9cb, 0x6fe1, 
	0x7336, 0x7337, 0xf9cc, 0x745c, 0x7531, 0xf9cd, 0x7652, 0xf9ce, 0xf9cf, 
	0x7dad, 0x81fe, 0x8438, 0x88d5, 0x8a98, 0x8adb, 0x8aed, 0x8e30, 0x8e42, 
	0x904a, 0x903e, 0x907a, 0x9149, 0x91c9, 0x936e, 0xf9d0, 0xf9d1, 0x5809, 
	0xf9d2, 0x6bd3, 0x8089, 0x80b2, 0xf9d3, 0xf9d4, 0x5141, 0x596b, 0x5c39, 
	0xf9d5, 0xf9d6, 0x6f64, 0x73a7, 0x80e4, 0x8d07, 0xf9d7, 0x9217, 0x958f, 
	0xf9d8, 0xf9d9, 0xf9da, 0xf9db, 0x807f, 0x620e, 0x701c, 0x7d68, 0x878d, 
	0xf9dc, 0x57a0, 0x6069, 0x6147, 0x6bb7, 0x8abe, 0x9280, 0x96b1, 0x4e59, 
	0x541f, 0x6deb, 0x852d, 0x9670, 0x97f3, 0x98ee, 0x63d6, 0x6ce3, 0x9091, 
	0x51dd, 0x61c9, 0x81ba, 0x9df9, 0x4f9d, 0x501a, 0x5100, 0x5b9c, 0x610f, 
	0x61ff, 0x64ec, 0x6905, 0x6bc5, 0x7591, 0x77e3, 0x7fa9, 0x8264, 0x858f, 
	0x87fb, 0x8863, 0x8abc, 0x8b70, 0x91ab, 0x4e8c, 0x4ee5, 0x4f0a, 0xf9dd, 
	0xf9de, 0x5937, 0x59e8, 0xf9df, 0x5df2, 0x5f1b, 0x5f5b, 0x6021, 0xf9e0, 
	0xf9e1, 0xf9e2, 0xf9e3, 0x723e, 0x73e5, 0xf9e4, 0x7570, 0x75cd, 0xf9e5, 
	0x79fb, 0xf9e6, 0x800c, 0x8033, 0x8084, 0x82e1, 0x8351, 0xf9e7, 0xf9e8, 
	0x8cbd, 0x8cb3, 0x9087, 0xf9e9, 0xf9ea, 0x98f4, 0x990c, 0xf9eb, 0xf9ec, 
	0x7037, 0x76ca, 0x7fca, 0x7fcc, 0x7ffc, 0x8b1a, 0x4eba, 0x4ec1, 0x5203, 
	0x5370, 0xf9ed, 0x54bd, 0x56e0, 0x59fb, 0x5bc5, 0x5f15, 0x5fcd, 0x6e6e, 
	0xf9ee, 0xf9ef, 0x7d6a, 0x8335, 0xf9f0, 0x8693, 0x8a8d, 0xf9f1, 0x976d, 
	0x9777, 0xf9f2, 0xf9f3, 0x4e00, 0x4f5a, 0x4f7e, 0x58f9, 0x65e5, 0x6ea2, 
	0x9038, 0x93b0, 0x99b9, 0x4efb, 0x58ec, 0x598a, 0x59d9, 0x6041, 0xf9f4, 
	0xf9f5, 0x7a14, 0xf9f6, 0x834f, 0x8cc3, 0x5165, 0x5344, 0xf9f7, 0xf9f8, 
	0xf9f9, 0x4ecd, 0x5269, 0x5b55, 0x82bf, 0x4ed4, 0x523a, 0x54a8, 0x59c9, 
	0x59ff, 0x5b50, 0x5b57, 0x5b5c, 0x6063, 0x6148, 0x6ecb, 0x7099, 0x716e, 
	0x7386, 0x74f7, 0x75b5, 0x78c1, 0x7d2b, 0x8005, 0x81ea, 0x8328, 0x8517, 
	0x85c9, 0x8aee, 0x8cc7, 0x96cc, 0x4f5c, 0x52fa, 0x56bc, 0x65ab, 0x6628, 
	0x707c, 0x70b8, 0x7235, 0x7dbd, 0x828d, 0x914c, 0x96c0, 0x9d72, 0x5b71, 
	0x68e7, 0x6b98, 0x6f7a, 0x76de, 0x5c91, 0x66ab, 0x6f5b, 0x7bb4, 0x7c2a, 
	0x8836, 0x96dc, 0x4e08, 0x4ed7, 0x5320, 0x5834, 0x58bb, 0x58ef, 0x596c, 
	0x5c07, 0x5e33, 0x5e84, 0x5f35, 0x638c, 0x66b2, 0x6756, 0x6a1f, 0x6aa3, 
	0x6b0c, 0x6f3f, 0x7246, 0xf9fa, 0x7350, 0x748b, 0x7ae0, 0x7ca7, 0x8178, 
	0x81df, 0x81e7, 0x838a, 0x846c, 0x8523, 0x8594, 0x85cf, 0x88dd, 0x8d13, 
	0x91ac, 0x9577, 0x969c, 0x518d, 0x54c9, 0x5728, 0x5bb0, 0x624d, 0x6750, 
	0x683d, 0x6893, 0x6e3d, 0x6ed3, 0x707d, 0x7e21, 0x88c1, 0x8ca1, 0x8f09, 
	0x9f4b, 0x9f4e, 0x722d, 0x7b8f, 0x8acd, 0x931a, 0x4f47, 0x4f4e, 0x5132, 
	0x5480, 0x59d0, 0x5e95, 0x62b5, 0x6775, 0x696e, 0x6a17, 0x6cae, 0x6e1a, 
	0x72d9, 0x732a, 0x75bd, 0x7bb8, 0x7d35, 0x82e7, 0x83f9, 0x8457, 0x85f7, 
	0x8a5b, 0x8caf, 0x8e87, 0x9019, 0x90b8, 0x96ce, 0x9f5f, 0x52e3, 0x540a, 
	0x5ae1, 0x5bc2, 0x6458, 0x6575, 0x6ef4, 0x72c4, 0xf9fb, 0x7684, 0x7a4d, 
	0x7b1b, 0x7c4d, 0x7e3e, 0x7fdf, 0x837b, 0x8b2b, 0x8cca, 0x8d64, 0x8de1, 
	0x8e5f, 0x8fea, 0x8ff9, 0x9069, 0x93d1, 0x4f43, 0x4f7a, 0x50b3, 0x5168, 
	0x5178, 0x524d, 0x526a, 0x5861, 0x587c, 0x5960, 0x5c08, 0x5c55, 0x5edb, 
	0x609b, 0x6230, 0x6813, 0x6bbf, 0x6c08, 0x6fb1, 0x714e, 0x7420, 0x7530, 
	0x7538, 0x7551, 0x7672, 0x7b4c, 0x7b8b, 0x7bad, 0x7bc6, 0x7e8f, 0x8a6e, 
	0x8f3e, 0x8f49, 0x923f, 0x9293, 0x9322, 0x942b, 0x96fb, 0x985a, 0x986b, 
	0x991e, 0x5207, 0x622a, 0x6298, 0x6d59, 0x7664, 0x7aca, 0x7bc0, 0x7d76, 
	0x5360, 0x5cbe, 0x5e97, 0x6f38, 0x70b9, 0x7c98, 0x9711, 0x9b8e, 0x9ede, 
	0x63a5, 0x647a, 0x8776, 0x4e01, 0x4e95, 0x4ead, 0x505c, 0x5075, 0x5448, 
	0x59c3, 0x5b9a, 0x5e40, 0x5ead, 0x5ef7, 0x5f81, 0x60c5, 0x633a, 0x653f, 
	0x6574, 0x65cc, 0x6676, 0x6678, 0x67fe, 0x6968, 0x6a89, 0x6b63, 0x6c40, 
	0x6dc0, 0x6de8, 0x6e1f, 0x6e5e, 0x701e, 0x70a1, 0x738e, 0x73fd, 0x753a, 
	0x775b, 0x7887, 0x798e, 0x7a0b, 0x7a7d, 0x7cbe, 0x7d8e, 0x8247, 0x8a02, 
	0x8aea, 0x8c9e, 0x912d, 0x914a, 0x91d8, 0x9266, 0x92cc, 0x9320, 0x9706, 
	0x9756, 0x975c, 0x9802, 0x9f0e, 0x5236, 0x5291, 0x557c, 0x5824, 0x5e1d, 
	0x5f1f, 0x608c, 0x63d0, 0x68af, 0x6fdf, 0x796d, 0x7b2c, 0x81cd, 0x85ba, 
	0x88fd, 0x8af8, 0x8e44, 0x918d, 0x9664, 0x969b, 0x973d, 0x984c, 0x9f4a, 
	0x4fce, 0x5146, 0x51cb, 0x52a9, 0x5632, 0x5f14, 0x5f6b, 0x63aa, 0x64cd, 
	0x65e9, 0x6641, 0x66fa, 0x66f9, 0x671d, 0x689d, 0x68d7, 0x69fd, 0x6f15, 
	0x6f6e, 0x7167, 0x71e5, 0x722a, 0x74aa, 0x773a, 0x7956, 0x795a, 0x79df, 
	0x7a20, 0x7a95, 0x7c97, 0x7cdf, 0x7d44, 0x7e70, 0x8087, 0x85fb, 0x86a4, 
	0x8a54, 0x8abf, 0x8d99, 0x8e81, 0x9020, 0x906d, 0x91e3, 0x963b, 0x96d5, 
	0x9ce5, 0x65cf, 0x7c07, 0x8db3, 0x93c3, 0x5b58, 0x5c0a, 0x5352, 0x62d9, 
	0x731d, 0x5027, 0x5b97, 0x5f9e, 0x60b0, 0x616b, 0x68d5, 0x6dd9, 0x742e, 
	0x7a2e, 0x7d42, 0x7d9c, 0x7e31, 0x816b, 0x8e2a, 0x8e35, 0x937e, 0x9418, 
	0x4f50, 0x5750, 0x5de6, 0x5ea7, 0x632b, 0x7f6a, 0x4e3b, 0x4f4f, 0x4f8f, 
	0x505a, 0x59dd, 0x80c4, 0x546a, 0x5468, 0x55fe, 0x594f, 0x5b99, 0x5dde, 
	0x5eda, 0x665d, 0x6731, 0x67f1, 0x682a, 0x6ce8, 0x6d32, 0x6e4a, 0x6f8d, 
	0x70b7, 0x73e0, 0x7587, 0x7c4c, 0x7d02, 0x7d2c, 0x7da2, 0x821f, 0x86db, 
	0x8a3b, 0x8a85, 0x8d70, 0x8e8a, 0x8f33, 0x9031, 0x914e, 0x9152, 0x9444, 
	0x99d0, 0x7af9, 0x7ca5, 0x4fca, 0x5101, 0x51c6, 0x57c8, 0x5bef, 0x5cfb, 
	0x6659, 0x6a3d, 0x6d5a, 0x6e96, 0x6fec, 0x710c, 0x756f, 0x7ae3, 0x8822, 
	0x9021, 0x9075, 0x96cb, 0x99ff, 0x8301, 0x4e2d, 0x4ef2, 0x8846, 0x91cd, 
	0x537d, 0x6adb, 0x696b, 0x6c41, 0x847a, 0x589e, 0x618e, 0x66fe, 0x62ef, 
	0x70dd, 0x7511, 0x75c7, 0x7e52, 0x84b8, 0x8b49, 0x8d08, 0x4e4b, 0x53ea, 
	0x54ab, 0x5730, 0x5740, 0x5fd7, 0x6301, 0x6307, 0x646f, 0x652f, 0x65e8, 
	0x667a, 0x679d, 0x67b3, 0x6b62, 0x6c60, 0x6c9a, 0x6f2c, 0x77e5, 0x7825, 
	0x7949, 0x7957, 0x7d19, 0x80a2, 0x8102, 0x81f3, 0x829d, 0x82b7, 0x8718, 
	0x8a8c, 0xf9fc, 0x8d04, 0x8dbe, 0x9072, 0x76f4, 0x7a19, 0x7a37, 0x7e54, 
	0x8077, 0x5507, 0x55d4, 0x5875, 0x632f, 0x6422, 0x6649, 0x664b, 0x686d, 
	0x699b, 0x6b84, 0x6d25, 0x6eb1, 0x73cd, 0x7468, 0x74a1, 0x755b, 0x75b9, 
	0x76e1, 0x771e, 0x778b, 0x79e6, 0x7e09, 0x7e1d, 0x81fb, 0x852f, 0x8897, 
	0x8a3a, 0x8cd1, 0x8eeb, 0x8fb0, 0x9032, 0x93ad, 0x9663, 0x9673, 0x9707, 
	0x4f84, 0x53f1, 0x59ea, 0x5ac9, 0x5e19, 0x684e, 0x74c6, 0x75be, 0x79e9, 
	0x7a92, 0x81a3, 0x86ed, 0x8cea, 0x8dcc, 0x8fed, 0x659f, 0x6715, 0xf9fd, 
	0x57f7, 0x6f57, 0x7ddd, 0x8f2f, 0x93f6, 0x96c6, 0x5fb5, 0x61f2, 0x6f84, 
	0x4e14, 0x4f98, 0x501f, 0x53c9, 0x55df, 0x5d6f, 0x5dee, 0x6b21, 0x6b64, 
	0x78cb, 0x7b9a, 0xf9fe, 0x8e49, 0x8eca, 0x906e, 0x6349, 0x643e, 0x7740, 
	0x7a84, 0x932f, 0x947f, 0x9f6a, 0x64b0, 0x6faf, 0x71e6, 0x74a8, 0x74da, 
	0x7ac4, 0x7c12, 0x7e82, 0x7cb2, 0x7e98, 0x8b9a, 0x8d0a, 0x947d, 0x9910, 
	0x994c, 0x5239, 0x5bdf, 0x64e6, 0x672d, 0x7d2e, 0x50ed, 0x53c3, 0x5879, 
	0x6158, 0x6159, 0x61fa, 0x65ac, 0x7ad9, 0x8b92, 0x8b96, 0x5009, 0x5021, 
	0x5275, 0x5531, 0x5a3c, 0x5ee0, 0x5f70, 0x6134, 0x655e, 0x660c, 0x6636, 
	0x66a2, 0x69cd, 0x6ec4, 0x6f32, 0x7316, 0x7621, 0x7a93, 0x8139, 0x8259, 
	0x83d6, 0x84bc, 0x50b5, 0x57f0, 0x5bc0, 0x5be8, 0x5f69, 0x63a1, 0x7826, 
	0x7db5, 0x83dc, 0x8521, 0x91c7, 0x91f5, 0x518a, 0x67f5, 0x7b56, 0x8cac, 
	0x51c4, 0x59bb, 0x60bd, 0x8655, 0x501c, 0xf9ff, 0x5254, 0x5c3a, 0x617d, 
	0x621a, 0x62d3, 0x64f2, 0x65a5, 0x6ecc, 0x7620, 0x810a, 0x8e60, 0x965f, 
	0x96bb, 0x4edf, 0x5343, 0x5598, 0x5929, 0x5ddd, 0x64c5, 0x6cc9, 0x6dfa, 
	0x7394, 0x7a7f, 0x821b, 0x85a6, 0x8ce4, 0x8e10, 0x9077, 0x91e7, 0x95e1, 
	0x9621, 0x97c6, 0x51f8, 0x54f2, 0x5586, 0x5fb9, 0x64a4, 0x6f88, 0x7db4, 
	0x8f1f, 0x8f4d, 0x9435, 0x50c9, 0x5c16, 0x6cbe, 0x6dfb, 0x751b, 0x77bb, 
	0x7c3d, 0x7c64, 0x8a79, 0x8ac2, 0x581e, 0x59be, 0x5e16, 0x6377, 0x7252, 
	0x758a, 0x776b, 0x8adc, 0x8cbc, 0x8f12, 0x5ef3, 0x6674, 0x6df8, 0x807d, 
	0x83c1, 0x8acb, 0x9751, 0x9bd6, 0xfa00, 0x5243, 0x66ff, 0x6d95, 0x6eef, 
	0x7de0, 0x8ae6, 0x902e, 0x905e, 0x9ad4, 0x521d, 0x527f, 0x54e8, 0x6194, 
	0x6284, 0x62db, 0x68a2, 0x6912, 0x695a, 0x6a35, 0x7092, 0x7126, 0x785d, 
	0x7901, 0x790e, 0x79d2, 0x7a0d, 0x8096, 0x8278, 0x82d5, 0x8349, 0x8549, 
	0x8c82, 0x8d85, 0x9162, 0x918b, 0x91ae, 0x4fc3, 0x56d1, 0x71ed, 0x77d7, 
	0x8700, 0x89f8, 0x5bf8, 0x5fd6, 0x6751, 0x90a8, 0x53e2, 0x585a, 0x5bf5, 
	0x60a4, 0x6181, 0x6460, 0x7e3d, 0x8070, 0x8525, 0x9283, 0x64ae, 0x50ac, 
	0x5d14, 0x6700, 0x589c, 0x62bd, 0x63a8, 0x690e, 0x6978, 0x6a1e, 0x6e6b, 
	0x76ba, 0x79cb, 0x82bb, 0x8429, 0x8acf, 0x8da8, 0x8ffd, 0x9112, 0x914b, 
	0x919c, 0x9310, 0x9318, 0x939a, 0x96db, 0x9a36, 0x9c0d, 0x4e11, 0x755c, 
	0x795d, 0x7afa, 0x7b51, 0x7bc9, 0x7e2e, 0x84c4, 0x8e59, 0x8e74, 0x8ef8, 
	0x9010, 0x6625, 0x693f, 0x7443, 0x51fa, 0x672e, 0x9edc, 0x5145, 0x5fe0, 
	0x6c96, 0x87f2, 0x885d, 0x8877, 0x60b4, 0x81b5, 0x8403, 0x8d05, 0x53d6, 
	0x5439, 0x5634, 0x5a36, 0x5c31, 0x708a, 0x7fe0, 0x805a, 0x8106, 0x81ed, 
	0x8da3, 0x9189, 0x9a5f, 0x9df2, 0x5074, 0x4ec4, 0x53a0, 0x60fb, 0x6e2c, 
	0x5c64, 0x4f88, 0x5024, 0x55e4, 0x5cd9, 0x5e5f, 0x6065, 0x6894, 0x6cbb, 
	0x6dc4, 0x71be, 0x75d4, 0x75f4, 0x7661, 0x7a1a, 0x7a49, 0x7dc7, 0x7dfb, 
	0x7f6e, 0x81f4, 0x86a9, 0x8f1c, 0x96c9, 0x99b3, 0x9f52, 0x5247, 0x52c5, 
	0x98ed, 0x89aa, 0x4e03, 0x67d2, 0x6f06, 0x4fb5, 0x5be2, 0x6795, 0x6c88, 
	0x6d78, 0x741b, 0x7827, 0x91dd, 0x937c, 0x87c4, 0x79e4, 0x7a31, 0x5feb, 
	0x4ed6, 0x54a4, 0x553e, 0x58ae, 0x59a5, 0x60f0, 0x6253, 0x62d6, 0x6736, 
	0x6955, 0x8235, 0x9640, 0x99b1, 0x99dd, 0x502c, 0x5353, 0x5544, 0x577c, 
	0xfa01, 0x6258, 0xfa02, 0x64e2, 0x666b, 0x67dd, 0x6fc1, 0x6fef, 0x7422, 
	0x7438, 0x8a17, 0x9438, 0x5451, 0x5606, 0x5766, 0x5f48, 0x619a, 0x6b4e, 
	0x7058, 0x70ad, 0x7dbb, 0x8a95, 0x596a, 0x812b, 0x63a2, 0x7708, 0x803d, 
	0x8caa, 0x5854, 0x642d, 0x69bb, 0x5b95, 0x5e11, 0x6e6f, 0xfa03, 0x8569, 
	0x514c, 0x53f0, 0x592a, 0x6020, 0x614b, 0x6b86, 0x6c70, 0x6cf0, 0x7b1e, 
	0x80ce, 0x82d4, 0x8dc6, 0x90b0, 0x98b1, 0xfa04, 0x64c7, 0x6fa4, 0x6491, 
	0x6504, 0x514e, 0x5410, 0x571f, 0x8a0e, 0x615f, 0x6876, 0xfa05, 0x75db, 
	0x7b52, 0x7d71, 0x901a, 0x5806, 0x69cc, 0x817f, 0x892a, 0x9000, 0x9839, 
	0x5078, 0x5957, 0x59ac, 0x6295, 0x900f, 0x9b2a, 0x615d, 0x7279, 0x95d6, 
	0x5761, 0x5a46, 0x5df4, 0x628a, 0x64ad, 0x64fa, 0x6777, 0x6ce2, 0x6d3e, 
	0x722c, 0x7436, 0x7834, 0x7f77, 0x82ad, 0x8ddb, 0x9817, 0x5224, 0x5742, 
	0x677f, 0x7248, 0x74e3, 0x8ca9, 0x8fa6, 0x9211, 0x962a, 0x516b, 0x53ed, 
	0x634c, 0x4f69, 0x5504, 0x6096, 0x6557, 0x6c9b, 0x6d7f, 0x724c, 0x72fd, 
	0x7a17, 0x8987, 0x8c9d, 0x5f6d, 0x6f8e, 0x70f9, 0x81a8, 0x610e, 0x4fbf, 
	0x504f, 0x6241, 0x7247, 0x7bc7, 0x7de8, 0x7fe9, 0x904d, 0x97ad, 0x9a19, 
	0x8cb6, 0x576a, 0x5e73, 0x67b0, 0x840d, 0x8a55, 0x5420, 0x5b16, 0x5e63, 
	0x5ee2, 0x5f0a, 0x6583, 0x80ba, 0x853d, 0x9589, 0x965b, 0x4f48, 0x5305, 
	0x530d, 0x530f, 0x5486, 0x54fa, 0x5703, 0x5e03, 0x6016, 0x629b, 0x62b1, 
	0x6355, 0xfa06, 0x6ce1, 0x6d66, 0x75b1, 0x7832, 0x80de, 0x812f, 0x82de, 
	0x8461, 0x84b2, 0x888d, 0x8912, 0x900b, 0x92ea, 0x98fd, 0x9b91, 0x5e45, 
	0x66b4, 0x66dd, 0x7011, 0x7206, 0xfa07, 0x4ff5, 0x527d, 0x5f6a, 0x6153, 
	0x6753, 0x6a19, 0x6f02, 0x74e2, 0x7968, 0x8868, 0x8c79, 0x98c7, 0x98c4, 
	0x9a43, 0x54c1, 0x7a1f, 0x6953, 0x8af7, 0x8c4a, 0x98a8, 0x99ae, 0x5f7c, 
	0x62ab, 0x75b2, 0x76ae, 0x88ab, 0x907f, 0x9642, 0x5339, 0x5f3c, 0x5fc5, 
	0x6ccc, 0x73cc, 0x7562, 0x758b, 0x7b46, 0x82fe, 0x999d, 0x4e4f, 0x903c, 
	0x4e0b, 0x4f55, 0x53a6, 0x590f, 0x5ec8, 0x6630, 0x6cb3, 0x7455, 0x8377, 
	0x8766, 0x8cc0, 0x9050, 0x971e, 0x9c15, 0x58d1, 0x5b78, 0x8650, 0x8b14, 
	0x9db4, 0x5bd2, 0x6068, 0x608d, 0x65f1, 0x6c57, 0x6f22, 0x6fa3, 0x701a, 
	0x7f55, 0x7ff0, 0x9591, 0x9592, 0x9650, 0x97d3, 0x5272, 0x8f44, 0x51fd, 
	0x542b, 0x54b8, 0x5563, 0x558a, 0x6abb, 0x6db5, 0x7dd8, 0x8266, 0x929c, 
	0x9677, 0x9e79, 0x5408, 0x54c8, 0x76d2, 0x86e4, 0x95a4, 0x95d4, 0x965c, 
	0x4ea2, 0x4f09, 0x59ee, 0x5ae6, 0x5df7, 0x6052, 0x6297, 0x676d, 0x6841, 
	0x6c86, 0x6e2f, 0x7f38, 0x809b, 0x822a, 0xfa08, 0xfa09, 0x9805, 0x4ea5, 
	0x5055, 0x54b3, 0x5793, 0x595a, 0x5b69, 0x5bb3, 0x61c8, 0x6977, 0x6d77, 
	0x7023, 0x87f9, 0x89e3, 0x8a72, 0x8ae7, 0x9082, 0x99ed, 0x9ab8, 0x52be, 
	0x6838, 0x5016, 0x5e78, 0x674f, 0x8347, 0x884c, 0x4eab, 0x5411, 0x56ae, 
	0x73e6, 0x9115, 0x97ff, 0x9909, 0x9957, 0x9999, 0x5653, 0x589f, 0x865b, 
	0x8a31, 0x61b2, 0x6af6, 0x737b, 0x8ed2, 0x6b47, 0x96aa, 0x9a57, 0x5955, 
	0x7200, 0x8d6b, 0x9769, 0x4fd4, 0x5cf4, 0x5f26, 0x61f8, 0x665b, 0x6ceb, 
	0x70ab, 0x7384, 0x73b9, 0x73fe, 0x7729, 0x774d, 0x7d43, 0x7d62, 0x7e23, 
	0x8237, 0x8852, 0xfa0a, 0x8ce2, 0x9249, 0x986f, 0x5b51, 0x7a74, 0x8840, 
	0x9801, 0x5acc, 0x4fe0, 0x5354, 0x593e, 0x5cfd, 0x633e, 0x6d79, 0x72f9, 
	0x8105, 0x8107, 0x83a2, 0x92cf, 0x9830, 0x4ea8, 0x5144, 0x5211, 0x578b, 
	0x5f62, 0x6cc2, 0x6ece, 0x7005, 0x7050, 0x70af, 0x7192, 0x73e9, 0x7469, 
	0x834a, 0x87a2, 0x8861, 0x9008, 0x90a2, 0x93a3, 0x99a8, 0x516e, 0x5f57, 
	0x60e0, 0x6167, 0x66b3, 0x8559, 0x8e4a, 0x91af, 0x978b, 0x4e4e, 0x4e92, 
	0x547c, 0x58d5, 0x58fa, 0x597d, 0x5cb5, 0x5f27, 0x6236, 0x6248, 0x660a, 
	0x6667, 0x6beb, 0x6d69, 0x6dcf, 0x6e56, 0x6ef8, 0x6f94, 0x6fe0, 0x6fe9, 
	0x705d, 0x72d0, 0x7425, 0x745a, 0x74e0, 0x7693, 0x795c, 0x7cca, 0x7e1e, 
	0x80e1, 0x82a6, 0x846b, 0x84bf, 0x864e, 0x865f, 0x8774, 0x8b77, 0x8c6a, 
	0x93ac, 0x9800, 0x9865, 0x60d1, 0x6216, 0x9177, 0x5a5a, 0x660f, 0x6df7, 
	0x6e3e, 0x743f, 0x9b42, 0x5ffd, 0x60da, 0x7b0f, 0x54c4, 0x5f18, 0x6c5e, 
	0x6cd3, 0x6d2a, 0x70d8, 0x7d05, 0x8679, 0x8a0c, 0x9d3b, 0x5316, 0x548c, 
	0x5b05, 0x6a3a, 0x706b, 0x7575, 0x798d, 0x79be, 0x82b1, 0x83ef, 0x8a71, 
	0x8b41, 0x8ca8, 0x9774, 0xfa0b, 0x64f4, 0x652b, 0x78ba, 0x78bb, 0x7a6b, 
	0x4e38, 0x559a, 0x5950, 0x5ba6, 0x5e7b, 0x60a3, 0x63db, 0x6b61, 0x6665, 
	0x6853, 0x6e19, 0x7165, 0x74b0, 0x7d08, 0x9084, 0x9a69, 0x9c25, 0x6d3b, 
	0x6ed1, 0x733e, 0x8c41, 0x95ca, 0x51f0, 0x5e4c, 0x5fa8, 0x604d, 0x60f6, 
	0x6130, 0x614c, 0x6643, 0x6644, 0x69a5, 0x6cc1, 0x6e5f, 0x6ec9, 0x6f62, 
	0x714c, 0x749c, 0x7687, 0x7bc1, 0x7c27, 0x8352, 0x8757, 0x9051, 0x968d, 
	0x9ec3, 0x532f, 0x56de, 0x5efb, 0x5f8a, 0x6062, 0x6094, 0x61f7, 0x6666, 
	0x6703, 0x6a9c, 0x6dee, 0x6fae, 0x7070, 0x736a, 0x7e6a, 0x81be, 0x8334, 
	0x86d4, 0x8aa8, 0x8cc4, 0x5283, 0x7372, 0x5b96, 0x6a6b, 0x9404, 0x54ee, 
	0x5686, 0x5b5d, 0x6548, 0x6585, 0x66c9, 0x689f, 0x6d8d, 0x6dc6, 0x723b, 
	0x80b4, 0x9175, 0x9a4d, 0x4faf, 0x5019, 0x539a, 0x540e, 0x543c, 0x5589, 
	0x55c5, 0x5e3f, 0x5f8c, 0x673d, 0x7166, 0x73dd, 0x9005, 0x52db, 0x52f3, 
	0x5864, 0x58ce, 0x7104, 0x718f, 0x71fb, 0x85b0, 0x8a13, 0x6688, 0x85a8, 
	0x55a7, 0x6684, 0x714a, 0x8431, 0x5349, 0x5599, 0x6bc1, 0x5f59, 0x5fbd, 
	0x63ee, 0x6689, 0x7147, 0x8af1, 0x8f1d, 0x9ebe, 0x4f11, 0x643a, 0x70cb, 
	0x7566, 0x8667, 0x6064, 0x8b4e, 0x9df8, 0x5147, 0x51f6, 0x5308, 0x6d36, 
	0x80f8, 0x9ed1, 0x6615, 0x6b23, 0x7098, 0x75d5, 0x5403, 0x5c79, 0x7d07, 
	0x8a16, 0x6b20, 0x6b3d, 0x6b46, 0x5438, 0x6070, 0x6d3d, 0x7fd5, 0x8208, 
	0x50d6, 0x51de, 0x559c, 0x566b, 0x56cd, 0x59ec, 0x5b09, 0x5e0c, 0x6199, 
	0x6198, 0x6231, 0x665e, 0x66e6, 0x7199, 0x71b9, 0x71ba, 0x72a7, 0x79a7, 
	0x7a00, 0x7fb2, 0x8a70, 
	0/*  End of table; # of entries=8741(0x2225)+1 */

};
int ksc5601max=sizeof(tabksc5601)/sizeof(tabksc5601[0]);
	/* # of entries in the table. */
