;;; asc2iso.el --- conversion of text

;; Copyright (C) 1993 Karl Brodowsky

;; Author: Karl Brodowsky <bro@clio.iwr.uni-heidelberg.de>
;; Version: 0.700
;; Keywords: i18n, wp

;; This file was written for GNU Emacs version 19

;; It is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; It is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Commentary:

;; created December 1993
;; last changed 29. December 1993
;;
;; It provides conversion from notation ae oe ue Ae Oe Ue ss sz
;; used for transcription of German Umlauts to the real Umlauts.
;;
;; It requires asc2iso (binary executable to be found in path).
;; It can coexist with konvers.el.
;;
;; Key sequences beginning with ctrl-x 7 are used:
;;
;; C-x 7 e   konvers-transcript-to-iso                  ; converts region 
;; C-x 7 E   konvers-buffer-transcript-to-iso           ; converts buffer from German TeX to Iso


(defun konvers-transcript-to-iso (from to)
  "Converts German transcriptions of umlaut letters and sharp s in
region to ISO Latin accented characters."
  (interactive "r")
  (shell-command-on-region from to "asc2iso" t))


(defun konvers-buffer-transcript-to-iso (arg)
  "Converts German transcriptions of umlaut letters and sharp s in
whole buffer to ISO Latin accented characters.
Iff ARG is non-nil ommit header."
  (interactive "P")
  (konvers-transcript-to-iso (konvers-point-min-or-behind-header arg) (point-max)))

(define-key ctl-x-map [?7 ?e] 'konvers-transcript-to-iso)
(define-key ctl-x-map [?7 ?E] 'konvers-buffer-transcript-to-iso)

(provide 'asc2iso)

;;; asc2iso.el ends here
