/******************************************************************************
 *                                                                            *
 * File:   scanflag.c         Version  1.12            Date: 1997-05-01       *
 *                                                                            *
 * Copyright (C) 1993-1997 by kostis@acm.org (Kosta Kostis)                   *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *     1997-05-01: KK V1.12                                                   *
 *        - new release of package                                            *
 *     1996-06-01: KK V1.01                                                   *
 *        - new release of package, change of email address                   *
 *        - changed switch "-w" to "-u"                                       *
 *     1994-03-04: KK V0.97                                                   *
 *        - new release of the package                                        *
 *     1994-01-18: KK V0.96                                                   *
 *        - added new switches "-c", "-b" and "-n"                            *
 *     1993-12-22: KK V0.95                                                   *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include <stdio.h>
#include <string.h>

#include "scanflag.h"

/******************************************************************************

	Function Variables

 *****************************************************************************/

char	*SrcFile ;      /* source encoding                           */
char	*DstFile ;      /* destination encoding                      */
char	*TabFile ;	/* table name                                */
int	TransMake ;
int	TableDump ;

/******************************************************************************

	Function:
		parse parameters and set flags and variables accordingly

	Parameters:
		int     argc    number of parameters
		char    *argv[] argument strings

	Returns:
		SCN_OK          if all parameters are valid
		SCN_UNKNOWN     if any of the parameters is unknown
		SCN_BADARGS     if the number of parameters is wrong

 *****************************************************************************/

int	ScanFlags
(
	int     argc,
	char    *argv   []
)
{
	int     i ;             /* index through the parameters              */
	int     parms = 0 ;     /* yet no parameter scanned                  */

	/**********************************************************************

		set defaults / initialize

	 *********************************************************************/

	SrcFile = (char *) NULL ;
	DstFile = (char *) NULL ;
	TabFile = (char *) NULL ;
	TransMake = TRANS_MAKE_DEFAULT ;
	TableDump = 0 ;

	for (i = 1 ; i < argc ; ++i)    /* scan command line                 */
	{
		/**************************************************************

			is it a flag/switch? (*NIX style)

		 *************************************************************/

		if (*argv [i] == '-')
		{
			/******************************************************

				which flag is it?

			 *****************************************************/

			switch (argv [i][1])
			{
				case	'C':	/* create complete C prog.   */
				case	'c':

					if (TransMake != TRANS_MAKE_DEFAULT)
						return (SCN_BADARGS) ;

					TransMake = TRANS_MAKE_ALL ;
					break ;

				case	'B':	/* create binary file only   */
				case	'b':

					if (TransMake != TRANS_MAKE_DEFAULT)
						return (SCN_BADARGS) ;

					TransMake = TRANS_MAKE_BINARY ;
					break ;

				case	'T':	/* create table file only    */
				case	't':

					if (TransMake != TRANS_MAKE_DEFAULT)
						return (SCN_BADARGS) ;

					TransMake = TRANS_MAKE_TABLE ;
					break ;

				case	'U':	/* create unicde table only*/
				case	'u':

					if (TransMake != TRANS_MAKE_DEFAULT)
						return (SCN_BADARGS) ;

					TransMake = TRANS_MAKE_UNICODE_A ;
					break ;

				case	'D':	/* dump tables read          */
				case	'd':

					TableDump = 1 ;
					break ;

				case	'N':	/* create nothing            */
				case	'n':

					if (TransMake != TRANS_MAKE_DEFAULT)
						return (SCN_BADARGS) ;

					TransMake = TRANS_MAKE_NOTHING ;
					break ;

				default:        /* Uh! This flag's unknown!  */

					return (SCN_UNKNOWN) ;
			}
		}
		else
		{
			/******************************************************

				if it's no flag it must be a filename

			 *****************************************************/

			++parms ;       /* check for multiple filenames      */
			switch (parms)
			{
				case	1:

					SrcFile = argv [i] ;
					break ;

				case	2:

					DstFile = argv [i] ;
					break ;

				case	3:

					TabFile = argv [i] ;
					break ;

				default :

					return (SCN_BADARGS) ;
			}
		}
	}

	/**********************************************************************

		everything's been fine - let's quit!

	 *********************************************************************/

	if
	(
		(SrcFile == (char *) NULL) ||
		(DstFile == (char *) NULL) ||
		(TabFile == (char *) NULL)
	)
		return (SCN_BADARGS) ;

	if (TransMake == TRANS_MAKE_DEFAULT)
		TransMake = TRANS_MAKE_ALL ;

	return (SCN_OK) ;
}
