/******************************************************************************
 *                                                                            *
 * File:   varread .c         Version  1.00            Date: 1996-01-08       *
 *                                                                            *
 * Copyright (C) 1993-1996 by Kosta Kostis - this is freeware!                *
 * Written by kostis@acm.org (Kosta Kostis)                                   *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * Function:                                                                  *
 *        - retrieve value from Waffle's STATIC file                          *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *    1996-01-08: KK V1.00                                                    *
 *        - updated Copyright message and email address                       *
 *    1993-02-24: KK V1.00                                                    *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include <stdio.h>
#include <string.h>

#include "setenv.h"

#include "readline.h"
#include "strccmp.h"
#include "rstatic.h"
#include "varread.h"

/******************************************************************************

	Function:
		display copyright message

	Parameters:
		none

	Returns:
		nothing

******************************************************************************/

static	void	Hello (void)
{
	fprintf (stderr, MSG_COPYRIGHT) ;
	fprintf (stderr, MSG_AUTHOR) ;
	fprintf (stderr, MSG_VERSION, PRGNAM) ;
}

/*****************************************************************************/

int	main
(
	int	argc,
	char	*argv []
)
{
	char	*Value ;
	int	i ;
	int	Status		= ERR_NONE ;

	/**********************************************************************

		check syntax, first

	**********************************************************************/

	if ((argc < 2) || (argc > 3))
	{
		Hello () ;
		fprintf (stderr, ERR_MSG_SYNTAX, PRGNAM) ;
		return (ERR_SYNTAX) ;
	}

	/**********************************************************************

		attempt to read Waffle STATIC variable

	**********************************************************************/

	Value = rstatic (argv [1]) ;
	if (Value == (char *) NULL)
	{
		Status = ERR_UNKNOWN ;
		Value  = "" ;
	}
	else
	{
		Value = strdup (Value) ;
	}

	/**********************************************************************

		perform correct action

	**********************************************************************/

	if (argc == 3)
	{
		if (SetEnvVar (argv [2], Value) != SETENVVAR_OK)
		{
			fprintf (stderr, ERR_MSG_ENVVAR, PRGNAM, argv [1]) ;
			return (ERR_ENVVAR) ;
		}
	}
	else
	{
		printf (MSG_DISPLAY, argv [1], Value) ;
	}

	return (Status) ;
}
