/******************************************************************************
 *                                                                            *
 * File:   readline.c         Version  1.00            Date: 1996-01-08       *
 *                                                                            *
 * Copyright (C) 1993-1996 by Kosta Kostis - this is freeware!                *
 * Written by kostis@acm.org (Kosta Kostis)                                   *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * Function:                                                                  *
 *        - read a line from a file into a buffer                             *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *    1996-01-08: KK V1.00                                                    *
 *        - updated Copyright message and email address                       *
 *    1993-02-01: KK V1.00                                                    *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include <stdio.h>

#include "readline.h"

/******************************************************************************

	Function:
		read a line from a file into a buffer

	Parameters:
		FILE    *fin            file being read
		char    *buf            line buffer
		int     maxlen          max. line length

	Returns:
		READLINE_OK             if all is OK
		READLINE_EOF            if EOF has been read
		READLINE_LONG           if the line is too long
		READLINE_ERROR          if there's a read error

******************************************************************************/

int     ReadLine
(
	FILE    *fin,
	char    *buf,
	int     maxlen
)
{
	int     ch ;

	*buf = '\0' ;           /* clear buffer */

	for (;;)
	{
		ch = fgetc (fin) ;
		switch (ch)
		{
			case    EOF:

				if (ferror (fin) != 0)
					return (READLINE_ERROR) ;

				return (READLINE_EOF) ;

			case    '\n':

				return (READLINE_OK) ;
		}

		if (maxlen-- == 0)
			return (READLINE_LONG) ;

		*buf++ = (char) ch ;
		*buf = '\0' ;
	}
}
