/******************************************************************************
 *                                                                            *
 * File:   isormail.c         Version  1.20            Date: 1996-01-08       *
 *                                                                            *
 * Copyright (C) 1992-1996 by Kosta Kostis - this is freeware!                *
 * Written by kostis@acm.org (Kosta Kostis)                                   *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * Function:                                                                  *
 *        Waffle 1.65 is 8-bit clean, but doesn't make any code conversion    *
 *        between IBM Code Pages and ISO 8859-x. To achieve that, use this    *
 *        program together with the code converters supplied to be closer     *
 *        to international standards.                                         *
 *                                                                            *
 *        Converters supplied and supported are:                              *
 *                                                                            *
 *               - IBMxISO, ISOxIBM         for IBM Code Page x               *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *    1996-01-08: KK V1.20                                                    *
 *        - updated Copyright message and email address                       *
 *    1993-11-21: KK V1.20                                                    *
 *        - minor fix to cooperate with Helldiver V1.07                       *
 *    1993-02-21: KK V1.11                                                    *
 *        - fixed bug that deleted the percent sign in mail addresses         *
 *    1993-02-01: KK V1.10                                                    *
 *        - added STATIC file variables                                       *
 *    1993-01-02: KK V1.02                                                    *
 *        - added hack for quoted-printables and base64 for incoming mails    *
 *    1992-12-06: KK V1.01                                                    *
 *        - added hack for MIME header for outgoing mails                     *
 *        - removed Code Page 437                                             *
 *    1992-10-29: KK V1.00                                                    *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>

#include "patch.h"
#include "rstatic.h"
#include "isormail.h"

/******************************************************************************

	Function:
		convert characters set in mail messages between IBM and ISO
		prior transmission

	Parameters:
		parameters for original rmail

	Returns:
		original rmail return code

******************************************************************************/         

int     main
(
	int     argc,
	char    *argv []
)
{
	char    cmd     [MAX_CMDLEN + 1] ;
	int     parms ;
	char    *EncodeParm ;
	char    *EncodePrg ;
	char    *DecodePrg ;
	char    *rmail ;

	/**********************************************************************

		The PC internal Character Set is IBM Code Page xxx
		We assume Code Page 850, because Code Page 850 includes
		all displayable ISO 8859-1 characters. Should you use
		Code Page 437, you may find most characters converted
		correctly. Other will be mapped to "wrong" characters,
		but when they are converted back to ISO 8859-1, they are
		unaltered. The network 8bit standard is ISO 8859-1

		Incoming mails must be converted from IBM to ISO
		Outgoing mails must be converted from ISO to IBM

		If the parameter -u{user} is found, we assume outgoing
		messages, else incoming

	**********************************************************************/

	DecodePrg = rstatic (STATIC_MIME_DECODE) ;
	if (DecodePrg == (char *) NULL)
		DecodePrg = CMD_DECODE ;
	else
		DecodePrg = strdup (DecodePrg) ;

	sprintf (cmd, "%s | ", DecodePrg) ;

	if
	(
		(argc > 2) &&
		(
			(strncmp (argv [1], "-u", 2) == 0) ||
			(strncmp (argv [1], "-f", 2) == 0)
		)
	)
	{
		EncodePrg = rstatic (STATIC_MIME_ENCODE) ;
		if (EncodePrg == (char *) NULL)
			EncodePrg = CMD_ENCODE ;
		else
			EncodePrg = strdup (EncodePrg) ;

		sprintf (cmd, "%s ", EncodePrg) ;

		EncodeParm = rstatic (STATIC_MIME_MAIL_CTE) ;
		if (EncodeParm != (char *) NULL)
		{
			strcat (cmd, EncodeParm) ;
			strcat (cmd, " ") ;
		}
		strcat (cmd, "| ") ;
	}

	/**********************************************************************

		rebuild command line with original parameters

	**********************************************************************/

	rmail = rstatic (STATIC_MIME_RMAIL) ;
	if (rmail == (char *) NULL)
		rmail = CMD_RMAIL ;
	else
		rmail = strdup (rmail) ;

	strcat (cmd, rmail) ;
	for (parms = 1 ; parms < argc ; ++parms)
	{
		strcat (cmd, " ") ;
		strcat (cmd, argv [parms]) ;
	}

	/**********************************************************************

		convert and deliver messages - return error codes

	**********************************************************************/

	return (system (cmd)) ;
}
