/******************************************************************************
 *                                                                            *
 * File:   isocomp .c         Version  1.20            Date: 1996-01-08       *
 *                                                                            *
 * Copyright (C) 1992-1996 by Kosta Kostis - this is freeware!                *
 * Written by kostis@acm.org (Kosta Kostis)                                   *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * Function:                                                                  *
 *        - convert between ISO 8859-x and IBM PC Code Page y before          *
 *          compression or after decompression.                               *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *    1996-01-08: KK V1.20                                                    *
 *        - updated Copyright message and email address                       *
 *    1993-03-05: KK V1.11                                                    *
 *        - made conversion via switch rather than program name               *
 *    1993-02-01: KK V1.10                                                    *
 *        - added static file support                                         *
 *    1992-12-06: KK V1.02                                                    *
 *        - removed Code Page 437                                             *
 *    1992-11-21: KK V1.01                                                    *
 *        - see isocomp.h                                                     *
 *    1992-10-29: KK V1.00                                                    *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "patch.h"
#include "rstatic.h"
#include "isocomp.h"

/*****************************************************************************/

int     main
(
	int     argc,
	char    *argv []
)
{
	char    cmd     [MAX_CMDLEN + 1] ;
	int     parms ;
	char    *Ext ;
	int     rc ;
	char    *help ;
	int     IBMxISO         = 1 ;   /* default is: translate */
	int     ISOxIBM         = 1 ;   /* default is: translate */
	char    *Compress ;

	/**********************************************************************

		shall we translate?

	**********************************************************************/

	help = rstatic (STATIC_MIME_IBMxISO) ;
	if (help != (char *) NULL)
		if (strcmp (help, VAL_NO) == 0)
			IBMxISO = 0 ;
	help = rstatic (STATIC_MIME_ISOxIBM) ;
	if (help != (char *) NULL)
		if (strcmp (help, VAL_NO) == 0)
			ISOxIBM = 0 ;

	/**********************************************************************

		If batch is outgoing, convert from IBM PC to ISO
		Here: outgoing :== !(incoming)

	**********************************************************************/

	if
	(
		(argc > 1) &&
		(strncmp (argv [1], ARG_UNCOMPRESS, strlen (ARG_UNCOMPRESS))) &&
		(IBMxISO != 0)
	)
	{                
		sprintf (cmd, "%s %s", CMD_IBMPCxISO, argv [2]) ;
		rc = system (cmd) ;
		if (rc)
		{
			fprintf (stderr, "%s: can not convert %s to ISO\n",
				PRGNAM, argv [2]) ;
			return (rc) ;
		}
	}

	/**********************************************************************

		Now do the actual compression/decompression

	**********************************************************************/

	Compress = rstatic (STATIC_MIME_COMPRESS) ;
	if (Compress == (char *) NULL)
		Compress = CMD_COMPRESS ;
	else
		Compress = strdup (Compress) ;

	sprintf (cmd, "%s", Compress) ;

	for (parms = 1 ; parms < argc ; ++parms)
	{
		strcat (cmd, " ") ;
		strcat (cmd, argv [parms]) ;
	}

	rc = system (cmd) ;
	if (rc)
		return (rc) ;

	/**********************************************************************

		If the batch file was incoming, convert from ISO to IBM PC

	**********************************************************************/

	if
	(
		(argc > 1) &&
		(strncmp (argv [1], ARG_UNCOMPRESS, strlen (ARG_UNCOMPRESS)) == 0) &&
		(ISOxIBM != 0)
	)
	{                
		strupr (argv [2]) ;
		sprintf (cmd, "%s %s", CMD_ISOxIBMPC, argv [2]) ;
		Ext = strstr (cmd, ".Z") ;      /* cut off extension */
		if (Ext != (char *) NULL)
			*Ext = '\0' ;

		rc = system (cmd) ;
		if (rc)
		{
			fprintf (stderr, "%s: can not decode file %s\n",
				PRGNAM, argv [2]) ;
			return (rc) ;
		}
	}

	/**********************************************************************

		We're hopefully ready...

	**********************************************************************/

	return (rc) ;
}
