/******************************************************************************
 *                                                                            *
 * File:   hrnews.c         Version  1.00            Date: 1996-01-08         *
 *                                                                            *
 * Copyright (C) 1993-1996 by Kosta Kostis - this is freeware!                *
 * Written by kostis@acm.org (Kosta Kostis)                                   *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * Function:                                                                  *
 *        - add MIME-header for outgoing articles containing 8bit, ISO 8859-x *
 *          special version for Helldiver 1.07                                *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *    1996-01-08: KK V1.00                                                    *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>

#include "patch.h"
#include "rstatic.h"
#include "hrnews.h"

/******************************************************************************

	Function:
		add MIME-headers to outgoing articles

	Parameters:
		parameters for original rnews

	Returns:
		original rnews return code

******************************************************************************/         

int     main
(
	int     argc,
	char    *argv []
)
{
	FILE	*stdlog ;
	char	LogName	[MAX_CMDLEN + 1] ;
	char    cmd     [MAX_CMDLEN + 1] ;
	int     parms ;
	int	rc ;
	char    *EncodeParm ;
	char    *EncodePrg ;
	char    *rnews ;
	char	*rnewslog ;
	char	*Help ;

	/**********************************************************************

		Articles get a MIME-header

	**********************************************************************/

	strcpy (cmd, "") ;
	EncodePrg = rstatic (STATIC_MIME_ENCODE) ;
	if (EncodePrg == (char *) NULL)
		EncodePrg = CMD_ENCODE ;
	else
		EncodePrg = strdup (EncodePrg) ;

	EncodeParm = rstatic (STATIC_MIME_NEWS_CTE) ;
	if (EncodeParm == (char *) NULL)
	{
		sprintf (cmd, "%s | ", EncodePrg) ;
	}
	else
	{
		EncodeParm = strdup (EncodeParm) ;
		sprintf (cmd, "%s %s | ",
			EncodePrg, EncodeParm) ;
	}

	/**********************************************************************

		rebuild command line with original parameters

	**********************************************************************/

	rnews = rstatic (STATIC_MIME_RNEWS) ;
	if (rnews == (char *) NULL)
		rnews = CMD_RNEWS ;
	else
		rnews = strdup (rnews) ;

	strcat (cmd, rnews) ;
	for (parms = 1 ; parms < argc ; ++parms)
	{
		strcat (cmd, " ") ;
		strcat (cmd, argv [parms]) ;
	}

	/**********************************************************************

		convert and deliver messages - return error codes

	**********************************************************************/

	rc = system (cmd) ;

	return (rc) ;
}
