/******************************************************************************
 *                                                                            *
 * File:   codepage.c         Version  1.20            Date: 1996-01-08       *
 *                                                                            *
 * Copyright (C) 1993-1996 by Kosta Kostis - this is freeware!                *
 * Written by kostis@acm.org (Kosta Kostis)                                   *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * Function:                                                                  *
 *        - figure out current Code Page for device CON:                      *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *    1996-01-08: KK V1.20                                                    *
 *        - added env var CP for Codepage detection                           *
 *    1993-09-30: KK V1.03                                                    *
 *        - corrected bug reported by Markus Kuhn (happens prior MODE CP)     *
 *    1993-07-31: KK V1.02                                                    *
 *        - corrected bug for HGC etc.                                        *
 *    1993-06-07: KK V1.01                                                    *
 *        - now only looking at device CON:                                   *
 *    1993-05-25: KK V1.00                                                    *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include <stdlib.h>
#include <dos.h>

#include "codepage.h"

/******************************************************************************

	Function:
		figure out DOS version

	Parameters:
		none

	Returns:
		DOS version in BCD format (eg. 0x0330 is version 3.30)

 *****************************************************************************/

static  int     DOS_Version (void)
{
	union   REGS    cpuregs ;

	cpuregs.x.ax = DOS_GETVER ;
	intdos (&cpuregs, &cpuregs) ;

	return (256 * cpuregs.h.al + cpuregs.h.ah) ;
}

/******************************************************************************

	Function:
		figure out active CON: Codepage

	Parameters:
		none

	Returns:
		int			Codepage value (e. g. 850)

 *****************************************************************************/

int     CodePage (void)
{
	union   REGS    cpuregs ;
	CODEPAGE	cp = { 2, 0 } ;
	char		*cpenv ;


	cpenv = getenv (ENV_CP) ;	/* check env var first */
	if (cpenv != (char *) NULL)
		return (atoi (cpenv)) ;

	if (DOS_Version () < MIN_DOSVER) /* DOS too old, use default         */
		return (DEF_CODE_PAGE) ;

	cpuregs.x.ax = DOS_IOCTL ;
	cpuregs.h.cl = DOS_IOCTL_GETCP ;
	cpuregs.h.ch = CATEGORY_CON ;
	cpuregs.x.bx = HANDLE_CON ;

	/**********************************************************************

		the following line will lead to a compiler warning,
		but will compile just fine as long as you choose
		the Intel small model for compilation (default)

	**********************************************************************/

	cpuregs.x.dx = (unsigned int) &cp ;	/* this is very hacky */

	intdos (&cpuregs, &cpuregs) ;

	if ((cp.cpId == 0) || (cp.cpId == 65535))
		return (DEF_CODE_PAGE) ;

	return (cp.cpId) ;
}
