/******************************************************************************
 *                                                                            *
 * File:   binary  .c         Version  1.10            Date: 1996-01-08       *
 *                                                                            *
 * Copyright (C) 1993-1996 by Kosta Kostis - this is freeware!                *
 * Written by kostis@acm.org (Kosta Kostis)                                   *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * Function:                                                                  *
 *        - copy binary                                                       *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *    1996-01-08: KK V1.10                                                    *
 *        - updated Copyright message and email address                       *
 *        - switched from int to ushort for tables                            *
 *    1993-03-05: KK V1.01                                                    *
 *        - added translation table support                                   *
 *    1993-02-01: KK V1.00                                                    *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include <stdio.h>

#include "binary.h"

/******************************************************************************

	Function:
		copy input to output unchanged

	Parameters:
		FILE    *fin            file being read
		FILE    *fout           file being written
		ushort	*table		pointer to translation table

	Returns:
		BINARY_OK               if all goes well
		BINARY_WRITE            if there's a write error

	Note:
		To be sure the data copied isn't modified open the files
		in binary mode (especially under MS-DOS).

******************************************************************************/

int     CopyBinary
(
	FILE    *fin,
	FILE    *fout,
	ushort	*table
)
{
	int     ch ;

	while ((ch = fgetc (fin)) != EOF)
	{
		/**************************************************************

			use conversion table if supplied

		**************************************************************/

		if (table != (ushort *) NULL)
			ch = (int) table [ch] ;

		if (fputc (ch, fout) != ch)
			return (BINARY_WRITE) ;
	}

	return (BINARY_OK) ;
}
