/******************************************************************************
 *                                                                            *
 * File:   base64  .h         Version  1.10            Date: 1996-01-08       *
 *                                                                            *
 * Copyright (C) 1993-1996 by Kosta Kostis - this is freeware!                *
 * Written by kostis@acm.org (Kosta Kostis)                                   *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *    1996-01-08: KK V1.10                                                    *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#ifndef	HANDY_DATA_TYPES
	#include "datatype.h"
#endif

/******************************************************************************

	base64 Constants

 *****************************************************************************/

#define BASE64_CHAR_PAD		'='		/* padding character	*/

#define BASE64_CODE_PAD		64		/* internal pad code	*/
#define	BASE64_CODE_NULL	 0		/* internal code for 0	*/

#define	BASE64_CODE_INVALID	-1		/* marks invalid code	*/

#define BASE64_CPL		72		/* characters per line	*/

#define	BASE64_INTERN		3		/* # of 8-bit octets	*/
#define	BASE64_EXTERN		4		/* # of base64 chars	*/

/******************************************************************************

	Function Return Codes (common)

 *****************************************************************************/

#define	BASE64_OK		0
#define	BASE64_WRITE		1

/******************************************************************************

	Function Prototypes

 *****************************************************************************/

extern	int	Copy8BitToBase64 (FILE *fin, FILE *fout, ushort *table) ;
extern	int	CopyBase64To8Bit (FILE *fin, FILE *fout, ushort *table) ;
