/******************************************************************************
 *                                                                            *
 * File:   loadtab .c         Version  1.13            Date: 1997-06-14       *
 *                                                                            *
 * Copyright (C) 1997 by kostis@acm.org (Kosta Kostis)                        *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * Function:                                                                  *
 *        - Translate Character Encoding 8-bit                                *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *     1997-06-14: KK V1.13                                                   *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "datatype.h"
#include "os-stuff.h"
#include "tab.h"
#include "taberr.h"

#include "loadtab.h"

/******************************************************************************

	Function:
		load table from file

	Parameters:
		char	*Encoding
		ushort	*bintab
		char	*Path

	Returns:

 *****************************************************************************/

int	LoadTable
(
	char	*Encoding,
	ushort	*bintab
)
{
	FILE	*Fin ;
	char	FileName	[PATHNAME_MAX + 1] ;
	char	*Help ;

	Help = getenv (ENV_TRANS) ;
	if (Help == (char *) NULL)
		Help = "" ;

	sprintf (FileName, EXT_BINARY, Help, CHR_DIR, Encoding) ;

	Fin = fopen (FileName, "rb") ;
	if (Fin == (FILE *) NULL)
		return (ERR_TAB) ;

	fread (bintab, sizeof (ushort), MAX_TABLE_ENTRIES, Fin) ;	
	fclose (Fin) ;

	return (ERR_NONE) ;
}

