/******************************************************************************
 *                                                                            *
 * File:   txtxqp  .c         Version  1.00            Date: 1996-01-08       *
 *                                                                            *
 * Copyright (C) 1993-1996 by Kosta Kostis - this is freeware!                *
 * Written by kostis@acm.org (Kosta Kostis)                                   *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * Function:                                                                  *
 *        - conversion from 8bit to quoted-printable                          *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *    1996-01-08: KK V1.00                                                    *
 *        - updated Copyright message and email address                       *
 *    1993-05-18: KK V1.00                                                    *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include <stdio.h>
#include <string.h>

#include "qp.h"

#include "txtxqp.h"

/******************************************************************************

	Function:
		display copyright message

	Parameters:
		none

	Returns:
		nothing

******************************************************************************/

static	void	Hello (void)
{
	fprintf (stderr, MSG_COPYRIGHT) ;
	fprintf (stderr, MSG_AUTHOR) ;
	fprintf (stderr, MSG_VERSION, PRGNAM) ;
}

int	main
(
	int	argc,
	char	*argv	[]
)
{
	FILE	*inf ;

	/**********************************************************************

		check syntax first

	**********************************************************************/

	if (argc != 2)
	{
		Hello () ;
		fprintf (stderr, ERR_MSG_SYNTAX, PRGNAM) ;
		return (ERR_SYNTAX) ;
	}

	/**********************************************************************

		attempt to open input file

	**********************************************************************/

	inf = fopen (argv [1], "r") ;
	if (inf == (FILE *) NULL)
	{
		Hello () ;
		fprintf (stderr, ERR_MSG_OPEN, PRGNAM, argv [1]) ;
		return (ERR_OPEN) ;
	}

	/**********************************************************************

		convert 8bit to quoted-printable

	**********************************************************************/

	Copy8BitToQP (inf, stdout, (int *) NULL) ;

	/**********************************************************************

		close input file and quit

	**********************************************************************/

	fclose (inf) ;
	
	return (ERR_NONE) ;
}
