/******************************************************************************
 *                                                                            *
 * File:   strccmp .c         Version  1.00            Date: 1996-01-08       *
 *                                                                            *
 * Copyright (C) 1993-1996 by Kosta Kostis - this is freeware!                *
 * Written by kostis@acm.org (Kosta Kostis)                                   *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *    1996-01-08: KK V1.00                                                    *
 *        - updated Copyright message and email address                       *
 *    1993-05-23: KK V1.00                                                    *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "strccmp.h"

/******************************************************************************

	Function:
		compare two strings ignoring the case (a-z only)
		use the length of the second string for the comparison.

	Parameters:
		char    *s1		source string
		char    *s2		compare string

	Returns:
		NULL                    if the strings are unequal
					or pointer(s) are invalid
		char    *               the position in s1 after s2

	Note:
		if you want to compare more than a-z (e. g. Umlauts)
		you'll have to supply your own version of toupper ()

******************************************************************************/

char    *strccmp
(
	char    *s1,
	char    *s2
)
{
	int     c1 ;
	int     c2 ;

	/**********************************************************************

		are the pointers valid?

	**********************************************************************/

	if ((s1 == (char *) NULL) || (s2 == (char *) NULL))
		return ((char *) NULL) ;

	/**********************************************************************

		scan through the strings

	**********************************************************************/

	while (*s2 != '\0')
	{
		c1 = toupper ((int) *s1++) ;
		if (c1 == '\0')
			return ((char *) NULL) ;

		c2 = toupper ((int) *s2++) ;
		if (c1 != c2)
			return ((char *) NULL) ;
	}

	return (s1) ;
}
