/******************************************************************************
 *                                                                            *
 * File:   rstatic .c         Version  1.00            Date: 1996-01-08       *
 *                                                                            *
 * Copyright (C) 1993-1996 by Kosta Kostis - this is freeware!                *
 * Written by kostis@acm.org (Kosta Kostis)                                   *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * Function:                                                                  *
 *        - retrieve value from Waffle's STATIC file                          *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *    1996-01-08: KK V1.00                                                    *
 *        - updated Copyright message and email address                       *
 *    1993-02-01: KK V1.00                                                    *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "rstatic.h"
#include "strccmp.h"
#include "readline.h"

/******************************************************************************

	Function:
		read the value behind the entry found in Waffle's
		static file

	Parameters:
		char    *Entry          Waffle's static entry name

	Returns:
		NULL                    if the entry is not found
		char    *               the entrie's value

	Note:
		The function opens and reads Waffle's static file each
		and every time it's being called. This may not be efficient
		and/or fast, but it's safe and easy to implement.

******************************************************************************/

char    *rstatic
(
	char    *Entry
)
{
	FILE    *fin ;
	static  char    Line    [RSTATIC_MAXLEN + 1] ;
	char    *FileName ;
	static  char    *Value ;
	int     Status ;

	FileName = getenv (RSTATIC_ENV_STATIC) ;
	if (FileName == (char *) NULL)
		return ((char *) NULL) ;

	fin = fopen (FileName, "r") ;
	if (fin == (FILE *) NULL)
		return ((char *) NULL) ;

	do
	{
		Status = ReadLine (fin, Line, RSTATIC_MAXLEN) ;

		Value = strccmp (Line, Entry) ;
		if
		(
			(Value != (char *) NULL) &&
			((*Value == ' ') || (*Value == ':'))
		)
		{
			Value = strchr (Value, ':') ;
			if (Value != (char *) NULL)
			{
				fclose (fin) ;

				while (*++Value == ' ') ;

				return (Value) ;
			}
		}
	}
	while (Status == READLINE_OK) ;

	fclose (fin) ;

	return ((char *) NULL) ;
}
