/******************************************************************************
 *                                                                            *
 * File:   qpxtxt  .c         Version  1.00            Date: 1996-01-08       *
 *                                                                            *
 * Copyright (C) 1993-1996 by Kosta Kostis - this is freeware!                *
 * Written by kostis@acm.org (Kosta Kostis)                                   *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * Function:                                                                  *
 *        - conversion from quoted printable to 8bit                          *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *    1996-01-08: KK V1.00                                                    *
 *        - updated Copyright message and email address                       *
 *    1993-05-18: KK V1.00                                                    *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include <stdio.h>
#include <string.h>

#include "qp.h"

#include "qpxtxt.h"

/******************************************************************************

	Function:
		display copyright message

	Parameters:
		none

	Returns:
		nothing

******************************************************************************/

static  void    Hello (void)
{
	fprintf (stderr, MSG_COPYRIGHT) ;
	fprintf (stderr, MSG_AUTHOR) ;
	fprintf (stderr, MSG_VERSION, PRGNAM) ;
}

/*****************************************************************************/

int     main
(
	int     argc,
	char    *argv   []
)
{
	FILE    *outf ;

	/**********************************************************************

		check syntax first

	**********************************************************************/

	if (argc != 2)
	{
		Hello () ;
		fprintf (stderr, ERR_MSG_SYNTAX, PRGNAM) ;
		return (ERR_SYNTAX) ;
	}

	/**********************************************************************

		attempt to open output file

	**********************************************************************/

	outf = fopen (argv [1], "w") ;
	if (outf == (FILE *) NULL)
	{
		Hello () ;
		fprintf (stderr, ERR_MSG_OPEN, PRGNAM, argv [1]) ;
		return (ERR_OPEN) ;
	}

	/**********************************************************************

		convert quoted printable to 8bit

	**********************************************************************/

	CopyQPTo8Bit (stdin, outf, (int *) NULL) ;

	/**********************************************************************

		close output file and quit

	**********************************************************************/

	fclose (outf) ;
	
	return (ERR_NONE) ;
}
