/******************************************************************************
 *                                                                            *
 * File:   mime    .h         Version  1.10            Date: 1996-01-08       *
 *                                                                            *
 * Copyright (C) 1993-1996 by Kosta Kostis - this is freeware!                *
 * Written by kostis@acm.org (Kosta Kostis)                                   *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *    1996-01-08: KK V1.10                                                    *
 *        - see "mime.c"                                                      *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************

	MIME encoding tags (conforming to RFC 1521: MIME)

******************************************************************************/

#define MIME_HEAD_VERSION       "%s%s"
#define MIME_TAG_VERSION        "MIME-Version: "
#define MIME_TAG_VERNUM         "1.0"

#define MIME_HEAD_TYPE          "%s%s%s%s"
#define MIME_TAG_TYPE           "Content-Type: "
#define MIME_TAG_PLAINTEXT      "text/plain"
#define MIME_TAG_CHARSET        "; charset="
#define MIME_TAG_PT_US_ASCII    "US-ASCII"
#define MIME_TAG_PT_ISO_8859    "ISO-8859-"

#define MIME_HEAD_ENCODING      "%s%s"
#define MIME_TAG_ENCODING       "Content-Transfer-Encoding: "
#define MIME_TAG_7BIT           "7bit"
#define MIME_TAG_8BIT           "8bit"
#define MIME_TAG_BINARY         "binary"
#define MIME_TAG_QP             "quoted-printable"
#define MIME_TAG_BASE64         "base64"

/******************************************************************************

	MIME encoding codes

******************************************************************************/

#define MIME_CODE_ERROR         -4      /* signal error         */

#define MIME_CODE_NOHEAD        -3      /* no header at all     */
#define MIME_CODE_NONE          -2      /* no MIME tag detected */
#define MIME_CODE_UNKNOWN       -1      /* MIME tag unknown     */

#define MIME_CODE_7BIT          0       /* 32..126              */
#define MIME_CODE_8BIT          1       /* 32..126 & 160..255   */
#define MIME_CODE_BINARY        2       /*  0..255              */
#define MIME_CODE_QP            3       /* quoted-printable     */
#define MIME_CODE_BASE64        4       /* base64               */

#define MIME_CODE_FIRST         MIME_CODE_7BIT
#define MIME_CODE_LAST          MIME_CODE_BASE64

/******************************************************************************

	Function Return Codes (common)

******************************************************************************/

#define MIME_OK                 0
#define MIME_WRITE              1

/******************************************************************************

	Function Prototypes

******************************************************************************/

extern  char    *MIME_CodeToTag (int Code) ;
extern  int     MIME_TagToCode (char *Tag) ;
extern  int     MIME_WriteHeader (FILE *fout, int Encoding, int iso8859) ;
