/******************************************************************************
 *                                                                            *
 * File:   isoxibm .c         Version: 1.20            Date: 1996-01-08       *
 *                                                                            *
 * Copyright (C) 1992-1996 by Kosta Kostis - this is freeware!                *
 * Written by kostis@acm.org (Kosta Kostis)                                   *
 *                                                                            *
 * Filter converting ISO 8859-1 to IBM Codepage 850 (CP850)                   *
 *     or converting ISO 8859-2 to IBM Codepage 852 (CP852)                   *
 *     or converting ISO 8859-3 to IBM Codepage 853 (CP853)                   *
 *     or converting ISO 8859-5 to IBM Codepage 866 (CP866)                   *
 *     or converting ISO 8859-6 to IBM Codepage 864 (CP864)                   *
 *     or converting ISO 8859-7 to IBM Codepage 869 (CP869)                   *
 *     or converting ISO 8859-8 to IBM Codepage 862 (CP862)                   *
 *     or converting ISO 8859-9 to IBM Codepage 857 (CP857)                   *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *    1996-01-08: KK V1.20                                                    *
 *        - added env var CP for Codepage detection                           *
 *    1994-01-04: KK V1.10                                                    *
 *        - added conversion tables for ISO 8859-3, -6 and -8                 *
 *    1993-12-29: KK V1.03                                                    *
 *        - recompilation because of corrected ISO 8859-7 <-> CP869 table     *
 *    1993-07-31: KK V1.02                                                    *
 *        - recompilation because of improved CodePage () function            *
 *    1993-06-11: KK V1.01                                                    *
 *        - accept other Codepages                                            *
 *    1993-05-25: KK V1.00                                                    *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include "isoxibm.h"

#include "isox850.tab"
#include "isox852.tab"
#include "isox853.tab"
#include "isox857.tab"
#include "isox862.tab"
#include "isox864.tab"
#include "isox866.tab"
#include "isox869.tab"

#include "transibm.c"
