/******************************************************************************
 *                                                                            *
 * File:   isornews.c         Version  1.10            Date: 1996-01-08       *
 *                                                                            *
 * Copyright (C) 1993-1996 by Kosta Kostis - this is freeware!                *
 * Written by kostis@acm.org (Kosta Kostis)                                   *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * Function:                                                                  *
 *        - add MIME-header for outgoing articles containing 8bit, ISO 8859-x *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *    1996-01-08: KK V1.20                                                    *
 *        - updated Copyright message and email address                       *
 *    1993-11-21: KK V1.10                                                    *
 *        - minor fix to cooperate with Helldiver V1.07                       *
 *    1993-03-05: KK V1.01                                                    *
 *        - main code conversion now done by Encode                           *
 *    1993-02-01: KK V1.00                                                    *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>

#include "patch.h"
#include "rstatic.h"
#include "isornews.h"

/******************************************************************************

	Function:
		add MIME-headers to outgoing articles

	Parameters:
		parameters for original rnews

	Returns:
		original rnews return code

******************************************************************************/         

int     main
(
	int     argc,
	char    *argv []
)
{
	FILE	*stdlog ;
	char	LogName	[MAX_CMDLEN + 1] ;
	char    cmd     [MAX_CMDLEN + 1] ;
	int     parms ;
	int	rc ;
	char    *EncodeParm ;
	char    *EncodePrg ;
	char    *rnews ;
	char	*rnewslog ;
	char	*Help ;

	/**********************************************************************

		Outgoing articles will get a MIME-header

		If the parameter -u{user} is found, we assume outgoing
		messages, else incoming

	**********************************************************************/

	strcpy (cmd, "") ;
	if
	(
		(argc > 1) &&
		(
			(strncmp (argv [1], "-u", 2) == 0) ||
			(strncmp (argv [1], "-f", 2) == 0)
		)
	)
	{
		EncodePrg = rstatic (STATIC_MIME_ENCODE) ;
		if (EncodePrg == (char *) NULL)
			EncodePrg = CMD_ENCODE ;
		else
			EncodePrg = strdup (EncodePrg) ;

		EncodeParm = rstatic (STATIC_MIME_NEWS_CTE) ;
		if (EncodeParm == (char *) NULL)
		{
			sprintf (cmd, "%s | ", EncodePrg) ;
		}
		else
		{
			EncodeParm = strdup (EncodeParm) ;
			sprintf (cmd, "%s %s | %s | ",
				EncodePrg, EncodeParm, CMD_ISOxIBMPC) ;
		}
	}

	/**********************************************************************

		rebuild command line with original parameters

	**********************************************************************/

	rnews = rstatic (STATIC_MIME_RNEWS) ;
	if (rnews == (char *) NULL)
		rnews = CMD_RNEWS ;
	else
		rnews = strdup (rnews) ;

	strcat (cmd, rnews) ;
	for (parms = 1 ; parms < argc ; ++parms)
	{
		strcat (cmd, " ") ;
		strcat (cmd, argv [parms]) ;
	}

	/**********************************************************************

		convert and deliver messages - return error codes

	**********************************************************************/

	rc = system (cmd) ;

	/**********************************************************************

		shall the call be logged?

	**********************************************************************/

	rnewslog = rstatic (STATIC_MIME_RNEWS_LOG) ;
	if (rnewslog == (char *) NULL)
		return (rc) ;
	if (strcmp (rnewslog, VAL_YES) != 0)
		return (rc) ;

	/**********************************************************************

		yes, log the call

	**********************************************************************/

	strcpy (LogName, DEF_LOGDIR) ;
	Help = rstatic (STATIC_SPOOL) ;
	if (Help != (char *) NULL)
		strcpy (LogName, Help) ;
	strcat (LogName, DEF_LOGFILE) ;

	stdlog = fopen (LogName, "a") ;
	if (stdlog != (FILE *) NULL)
	{
		fprintf (stdlog, "Calling '%s' returning: %d\n", cmd, rc) ;
		fclose (stdlog) ;
	}

	return (rc) ;
}
