/******************************************************************************
 *                                                                            *
 * File:   ibmxiso .c         Version: 1.20            Date: 1996-01-08       *
 *                                                                            *
 * Copyright (C) 1992-1996 by Kosta Kostis - this is freeware!                *
 * Written by kostis@acm.org (Kosta Kostis)                                   *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * Filter converting IBM Codepage 850 (CP850) to ISO 8859-1                   *
 *     or converting IBM Codepage 852 (CP852) to ISO 8859-2                   *
 *     or converting IBM Codepage 853 (CP853) to ISO 8859-3                   *
 *     or converting IBM Codepage 866 (CP866) to ISO 8859-5                   *
 *     or converting IBM Codepage 864 (CP864) to ISO 8859-6                   *
 *     or converting IBM Codepage 869 (CP869) to ISO 8859-7                   *
 *     or converting IBM Codepage 862 (CP862) to ISO 8859-8                   *
 *     or converting IBM Codepage 857 (CP857) to ISO 8859-9                   *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *    1996-01-08: KK V1.20                                                    *
 *        - added use of env var CP for Codepage detection                    *
 *    1994-01-04: KK V1.10                                                    *
 *        - added conversion tables for ISO 8859-3, -6 and -8                 *
 *    1993-12-29: KK V1.03                                                    *
 *        - recompiled because of corrected ISO 8859-7 <-> CP869 table        *
 *    1993-07-31: KK V1.02                                                    *
 *        - recompiled because of improved CodePage () function               *
 *    1993-06-11: KK V1.01                                                    *
 *        - accept other Codepages                                            *
 *    1993-05-25: KK V1.00                                                    *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include "ibmxiso.h"

#include "850xiso.tab"
#include "852xiso.tab"
#include "853xiso.tab"
#include "857xiso.tab"
#include "862xiso.tab"
#include "864xiso.tab"
#include "866xiso.tab"
#include "869xiso.tab"

#include "transibm.c"
