;;; make-spec-konvers.el --- make special versions from iso-konvers.el

;; Copyright (C) 1995 Karl Brodowsky

;; Author: Karl Brodowsky <bk1@ix.urz.uni-heidelberg.de>
;; Version: 0.500
;; Keywords: i18n, tex, wp

;; This file was written for GNU Emacs version 19

;; It is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; It is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.	If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Commentary:

;; created May 1995
;;
;; The functions provided in this file should only be used on rare
;; occasions when creating a version <xxx>-konvers from iso-konvers.
;; Currently supported are nxt-konvers for nextstep encoding and
;; os2-konvers for cp850.  To disable accidental use the variable
;; konvers-make-spec-konvers-enabled is set to nil.  It must be set to
;; something non-nil before using the functions supplied in this file.

;;; Code:

(require 'iso-konvers)
(require 'charset-konvers)

(defvar konvers-make-spec-konvers-enabled nil
  "must be non-nil to enable use of functions in this file")

(setq konvers-make-spec-konvers-enabled nil)

(defun konvers-make-spec-konvers (short medium long fun)
  "creates SHORT-konvers.el from iso-konvers.el
MEDIUM is the name to be used in converted text where no other name is available
LONG is the long name to be used in commentaries"
  (if konvers-make-spec-konvers-enabled
      (let
	  ((buffer (find-file (concat short "-konvers.el"))))
	(delete-region (point-min) (point-max))
	(insert-file "iso-konvers.el")
	(apply fun (list (point-min) (point-max)))
	(konvers-replace-string-set 
	 (point-min) (point-max)
	 (list
	  (cons "ISO-8859-1" long)
	  (cons "\\iso" (concat "\\" medium))
	  (cons "iso" short)
	  (cons "8bit-html" (concat short "-8bit-html"))))
	(save-buffer)
	(kill-buffer buffer))))

(defun konvers-make-os2-konvers ()
  "creates os2-konvers.el"
  (konvers-make-spec-konvers 
   "os2" "cpDCCCL" "OS2 Code Page 850" 
   (function konvers-iso-to-os2)))

(defun konvers-make-nxt-konvers ()
  "creates os2-konvers.el"
  (konvers-make-spec-konvers 
   "nxt" "nextenc" "Nextstep Encoding"
   (function konvers-iso-to-nxt)))

;;; make-spec-konvers.el ends here
