;;; extra-konvers.el --- conversion of text; requires konvers.el

;; Copyright (C) 1993 Karl Brodowsky

;; Author: Karl Brodowsky <bro@clio.iwr.uni-heidelberg.de>
;; Version: 0.610
;; Keywords: i18n, tex, wp

;; This file was written for GNU Emacs version 19

;; It is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; It is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.	If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Commentary:

;; created January 1994
;; last changed 28. January 1994
;; requires konvers.el
;;
;; WARNING:  THIS FILE CONTAINS 8-BIT CHARACTERS.  
;; MAKE SURE IT HAS BEEN TRANSFERRED IN BINARY MODE!!!
;; DO NOT CONVERT THIS FILE.
;;
;; ACHTUNG:  DIESE DATEI ENTHLT 8-BIT-ZEICHEN.
;; STELLEN SIE SICHER, DASZ SIE BINR BERTRAGEN WORDEN IST.
;; DIESE DATEI VERTRGT KEINE KONVERTIERUNG.
;;
;; It provides conversion for different quotation conventions
;;
;; ascii-quote	  --> German TeX quote   ("xyz" --> "`xyz"')
;; ascii-quote    --> English TeX quote ("xyz" --> ``xyz'')
;; 

;;; Code:

(require 'konvers)

(defun konvers-quote-replace (quote-begin quote-end from to)
  "Replace ascii double quotes by TeX quotes where apropriate"
  (interactive "*sbegin-quote-sequence: \nsend-quote-sequence: \nr")
  (let ((case-replace nil)
	(case-fold-search nil)
    (save-excursion
      (save-restriction
	(narrow-to-region from to)
	(goto-char from)
	(replace-regexp "\\\([^a-zA-Z-!?.]\\\)\"\\\([a-zA-Z-]\\\)"
			(concat "\\1" quote-begin "\\2"))
	(goto-char from)
	(replace-regexp "\\\([a-zA-Z-!?.]\\\)\"\\\([^a-zA-Z-']\\\)"
			(concat "\\1" quote-end "\\2")))))))

(defun konvers-buffer-quote-replace (quote-begin quote-end &optional arg)
  "Replace ascii double quotes by TeX quotes in whole buffer"
  (interactive "*sbegin-quote-sequence: \nsend-quote-sequence: \nP")
  (konvers-quote-replace  quote-begin quote-end 
			  (konvers-point-min-or-behind-header arg) 
			  (point-max)))

(defun konvers-buffer-german-quote-replace (&optional arg)
  "Replace ascii double quotes by German TeX quotes in whole buffer"
  (interactive "*P")
  (konvers-buffer-quote-replace "\"\`" "\"\'" arg))

(defun konvers-buffer-english-quote-replace (&optional arg)
  "Replace ascii double quotes by German TeX quotes in whole buffer"
  (interactive "*P")
  (konvers-buffer-quote-replace "\`\`" "\'\'" arg))

(provide 'extra-konvers)

;;; extra-konvers.el ends here
