;  ***************************************************************************
;  *                                                                         *
;  * File:   NEWINT  .INC         Version   1.01           Date: 01-OCT-1993 *
;  *                                                                         *
;  * Copyright (C) 1993 by Kosta Kostis - this is freeware!                  *
;  * Written by kosta@blues.sub.de (Kosta Kostis)                            *
;  *                                                                         *
;  ***************************************************************************
;  *                                                                         *
;  * History:                                                                *
;  *    01-OCT-1993: KK V1.01                                                *
;  *        - see NEWINT.ASM                                                 *
;  *                                                                         *
;  ***************************************************************************

;  ***************************************************************************
;
;	interface to the TSR
;
;  ***************************************************************************

INT_TSR		EQU	16h			; BIOS keyboard interrupt
   KBD_GET	EQU	00h			; getch () for AT keyboard
   KBD_HIT	EQU	01h			; kbhit () and KBD_GET
   KBD_ENHGET	EQU	10h			; getch () for enh. keyboard
   KBD_ENHHIT	EQU	11h			; kbhit () and KBD_ENHGET
   TSR_XFACE	EQU	42			; ISOkeyb TSR interface
   TSR_CHK	EQU	0			; load check (AL, CX)
						; AL == TSR_XFACE -> TSR inst.
						; BX = version # (BCD) high:low
   TSR_GETMODE	EQU	2			; return translation status
						; BX == 0 --> enabled
   TSR_GETPSP	EQU	3			; return PSP in BX (for free)
   TSR_GETOVEC	EQU	4			; return original int in DS:DX
   TSR_GETNVEC	EQU	5			; return TSR addr in DX:CX

   KEY_CURSOR	EQU	0E0h			; code for cursor keys
   KEY_SCROLL	EQU	010h			; scroll lock bit
   KEY_NOSCROLL	EQU	0EFh			; not scoll lock bit
   BIOS_KBDSTAT	EQU	0417h			; BIOS keyboard status

;  ***************************************************************************
;
;	interface to MS-DOS services
;
;  ***************************************************************************

INT_DOS		EQU	21h			; DOS interrupt
						; put function # in AH
   PUT_CHR	EQU	02h			; output a character (DL)
   PUT_STR	EQU	09h			; output a $string (DS:DX)
   GET_VEC	EQU	35h			; get int vector (AL,ES:BX)
   SET_VEC	EQU	25h			; set int vector (AL,ES:BX)
   DOS_CLOSE	EQU	3Eh			; close file (BX)
   GET_PSP	EQU	62h			; get program PSP (BX)
   DOS_VER	EQU	30h			; get DOS version (AX)
   DOS_FREE	EQU	49h			; free memory (ES)
   DOS_TERM	EQU	4Ch			; terminate MS-DOS program
						; return value in AL
   DOS_TSR	EQU	31h			; make program TSR
						; return value in AL
;   DOS_IOCTL_C	EQU	440Ch			; communicate with device
;      CATEGORY_CON	EQU	3		; CON: screen device
;      DOS_IOCTL_GETCP	EQU	6Ah		; get active Codepage

OLD_TERM	EQU	20h			; older DOS program termination

;  ***************************************************************************
;
;	internal program constants
;
;  ***************************************************************************

VERSION		EQU	0101h			; version maj/min (BCD) x.x.xx
DOSminVERSION	EQU	031Eh			; min. DOS version required
						; Per Definition it's 3.30
Xlate		EQU	0			; translation status (ON)

;  ***************************************************************************
;
;	DOS constants (in this case for close function)
;
;  ***************************************************************************

stdin		EQU	0			; standard input
stdout		EQU	1			; standard output
stderr		EQU	2			; standard error

;  ***************************************************************************
;
;	offset constants in PSP (C like)
;
;  ***************************************************************************

argc		EQU	80h			; offset in PSP for arg count
argv		EQU	82h			; offset in PSP for arg value 0
envp		EQU	2Ch			; offset in PSP for envp

;  ***************************************************************************
;
;	program return codes (error codes)
;
;  ***************************************************************************

ERR_NONE	EQU	0			; OK
ERR_SYNTAX	EQU	1			; syntax error
ERR_VERSION	EQU	2			; TSR version mismatch
ERR_HOOKED	EQU	3			; other program hooks int

;  ***************************************************************************
;
;	personal C style macros to ease coding using standard DOS functions
;
;  ***************************************************************************

;  ---------------------------------------------------------------------------

puts		MACRO	String			; write string to stdout

		lea	dx,String		; must be terminated by a '$'
		mov	ah,PUT_STR		;
		int	INT_DOS			;

		ENDM				;

;  ---------------------------------------------------------------------------

free		MACRO	Pointer			; free memory

		mov	es,Pointer		;
		mov	ah,DOS_FREE		;
		int	INT_DOS			;

		ENDM				;
BIOS_RAM	EQU	0040h		; segemt of BIOS area
