;  ***************************************************************************
;  *                                                                         *
;  * File:   NEWINT  .ASM         Version   1.01           Date: 01-OCT-1993 *
;  *                                                                         *
;  * Copyright (C) 1993 by Kosta Kostis - this is freeware!                  *
;  * Written by kosta@blues.sub.de (Kosta Kostis)                            *
;  *                                                                         *
;  ***************************************************************************
;  *                                                                         *
;  * Function:                                                               *
;  *     - install TSR program, get status, unload TSR program               *
;  *                                                                         *
;  ***************************************************************************
;  *                                                                         *
;  * Parameters:                                                             *
;  *     - U         unload (restore original int handler and free memory)   *
;  *     - S         status (default)                                        *
;  *     - A         activate translation                                    *
;  *     - D         deactivate translation                                  *
;  *                                                                         *
;  ***************************************************************************
;  *                                                                         *
;  * Comments:                                                               *
;  *     - only one parameter at a time                                      *
;  *                                                                         *
;  ***************************************************************************
;  *                                                                         *
;  * History:                                                                *
;  *    01-OCT-1993: KK V1.01                                                *
;  *        - added parameters A and D                                       *
;  *    14-JUN-1993: KK V1.00                                                *
;  *        - initial coding                                                 *
;  *                                                                         *
;  ***************************************************************************

.MODEL          TINY                            ; a COM TSR

INCLUDE         NEWINT.INC			; program constants

.CODE

		ORG     100h                    ; told yer 'tis a COM program

start:		jmp	CheckLoad		; try to load the TSR

;  ***************************************************************************
;  *                                                                         *
;  * NEWINT is the new int routine                                           *
;  * To ease maintainability NEWINT is in a serperate file (NEWINT.TSR).     *
;  *                                                                         *
;  ***************************************************************************

INCLUDE		NEWINT.TSR

;  ***************************************************************************
;  *                                                                         *
;  * Anything below this line is not part of the TSR code and data.          *
;  * The loader routine first checks for a previous TSR load                 *
;  * and then decides how to interprete the command line. Only one function  *
;  * per call is accepted. This is not very user friendly, I know...         *
;  *                                                                         *
;  ***************************************************************************

CheckLoad:	puts	Copyright		; tell user where we come from
		puts	About			; tell user who we are

		mov	ah,DOS_VER		; get DOS version
		int	INT_DOS			;
		xchg	al,ah			; this is better for compare
		cmp	ax,DOSminVERSION	; is it the minimum required?
		jl	DOSverError             ; no, terminate showing error

		mov	ah,TSR_XFACE		; check if TSR is loaded
		mov	al,TSR_CHK		; AL isn't changed by BIOS
		int	INT_TSR			; will be changed by TSR
		cmp	al,TSR_XFACE		; did the TSR answer?
		jne	LoadTSR			; no, load the TSR

		cmp	bx,VERSION		; does it match?
		jne	TSRverError		; no, fail on error

		mov	al,ERR_NONE		; default error is: none
		mov     ah,cs:argc              ; is there a command line parm?
		cmp     ah,1                    ; one blank is allowed
		jle     Status                  ; default is: status
		cmp	ah,3			; more than 2 characters?
		jg	SyntaxError		; only one parameter at a time
		mov	ah,cs:argv		; check command line parameters
		cmp	ah,'/'			; check for leading switch char
		je	GetParam		;
		cmp	ah,'-'			; accept both '-' and '/'
		jne	SyntaxError		;

GetParam:	mov	ah,cs:argv+1		; check parameter
		and     ah,0DFh                 ; ignore case, simple parse

		cmp     ah,'S'                  ; is it "status"?
		je      Status                  ; yeah, show status...
		cmp     ah,'U'                  ; is it "unload"?
		je	Unload			; yeah, unload...
		cmp	ah,'A'			; is it "activate"?
		je	Activate		; yeah, activate...
		cmp	ah,'D'			; is it "deactivate"?
		je	Deactivate		; yeah, deactivate...

		jmp     SyntaxError             ; show "syntax error"

;  ***************************************************************************
;  *                                                                         *
;  * modify scoll lock status                                                *
;  *                                                                         *
;  ***************************************************************************

Activate:	xor	cl,cl			; too lazy to find something
		jmp	SetScrollLock		; more simple than that...

Deactivate:	mov	cl,1			;

SetScrollLock:	push	ds			; save ds
		xor	bx,bx			; set ds to 0
		mov	ds,bx			;
		mov	ah,byte ptr ds:[BIOS_KBDSTAT] ;
		cmp	cl,0			;
		je	DoActivate		;
		and	ah,KEY_NOSCROLL		; turn off scroll lock
		jmp	ScrollLock		;

DoActivate:	or	ah,KEY_SCROLL		; turn on scroll lock

ScrollLock:	mov	byte ptr ds:[BIOS_KBDSTAT],ah ;
		pop	ds			; restore ds

		mov	ah,KBD_HIT		; check keyboard status
		int	INT_TSR			; to make the change
		jmp	Terminate		; terminate program

;  ***************************************************************************
;  *                                                                         *
;  * display current translation status                                      *
;  *                                                                         *
;  ***************************************************************************

Status:		call    DispStatus              ; display status
		mov     al,ERR_NONE             ; terminate with no error
		jmp     Terminate               ;

DispStatus:	puts	MsgXLATE		;

		mov	ah,TSR_XFACE		; get translation mode
		mov	al,TSR_GETMODE		; via TSR (in BH)
		int	INT_TSR			;
		cmp	bx,Xlate		; translation enabled?
		jne     NoXlation               ; no, say so...

		lea	dx,MsgEnable		; translation is enabled
		jmp	skipNoX			; say so...

NoXlation:	lea	dx,MsgDisable		; translation is disabled
skipNoX:	mov	ah,PUT_STR		; display message
		int	INT_DOS			;
		ret                             ; this is a subroutine

;  ***************************************************************************
;  *                                                                         *
;  * The unload feature removes the TSR, frees the allocated memory and      *
;  * restores the original interrupt vector.                                 *
;  *                                                                         *
;  ***************************************************************************

Unload:		mov	ah,TSR_XFACE		; get TSR addr in DX:CX
		mov	al,TSR_GETNVEC		;
		int	INT_TSR			;

		mov     ah,GET_VEC              ; get current vector in ES:BX
		mov     al,INT_TSR              ;
		int     INT_DOS                 ;

		mov     ax,es                   ; compare vectors
		cmp     ax,dx                   ; is the int hooked?
		jne     intHooked               ; yeah, can't unload
		cmp     bx,cx                   ;
		jne     intHooked               ;

		mov	ah,TSR_XFACE		; get TSR's PSP
		mov	al,TSR_GETPSP		;
		int	INT_TSR			;
		push	bx			; and keep it on the stack

		push    ds                      ; save DS because we change it
		mov	ah,TSR_XFACE		; retrieve original int 17h
		mov	al,TSR_GETOVEC		; address (DS:DX)
		int	INT_TSR			;

		mov     al,INT_TSR              ;
		mov     ah,SET_VEC              ; restore original vector
		int     INT_DOS                 ;
		pop     ds                      ; restore DS, vector restored

		pop	bx			; this was the TSR's PSP
		free	bx			; free TSR memory

		puts    MsgUnInst		; tell user what we've done
		mov     al,ERR_NONE             ; and terminate with no error
		jmp     Terminate               ;

;  ***************************************************************************
;  *                                                                         *
;  * Program Error(s) (Messages) are handled here                            *
;  *                                                                         *
;  ***************************************************************************

DOSverError:    puts    MsgBADDOS		; bad DOS version
		xor	ax,ax			;
		int     OLD_TERM                ; terminate the old DOS way

TSRverError:    puts    MsgBADTSR		; bad TSR version
		mov     al,ERR_VERSION          ; Error Code for TSR Error
		jmp     Terminate               ;

intHooked:      puts    MsgBADVEC		; someone hooked int 16h
		mov     al,ERR_HOOKED           ; can't unload
		jmp     Terminate               ;

SyntaxError:    puts    MsgSyntax		; inform user about the syntax
		mov     al,ERR_SYNTAX           ; Error Code for Syntax Error

;  ***************************************************************************
;  *                                                                         *
;  * Normal MS-DOS termination with error code (ERRORLEVEL).                 *
;  * The error code is in AL.                                                *
;  *                                                                         *
;  ***************************************************************************

Terminate:      mov     ah,DOS_TERM             ; terminate program with error
		int     INT_DOS                 ;

;  ***************************************************************************
;  *                                                                         *
;  * Load the TSR and tell the user about it.                                *
;  *                                                                         *
;  ***************************************************************************

LoadTSR:	mov	al,cs:argc		; for load no params
		cmp     al,1                    ; (one blank is OK)
		jg      SyntaxError             ;

		mov     ah,GET_VEC              ; get current vector
		mov     al,INT_TSR              ;
		int     INT_DOS                 ;
		mov     cs:INTVec,bx            ; store vector for later use
		mov     cs:INTVec+2,es          ; and for restauration

		mov     ah,GET_PSP              ; save original PSP
		int     INT_DOS                 ; for calling free when
		mov     cs:INTPSP,bx		; unloading

		mov     ax,ds                   ; save new int vector in TSR
		lea	dx,NEWINT		;
		mov     cs:TSRVec+2,ax		;
		mov	cs:TSRVec,dx		;
		mov     ah,SET_VEC              ; set new int vector
		mov     al,INT_TSR              ;
		int     INT_DOS                 ;

		puts    MsgNewInst		; tell user about TSR load

		mov	cx,5			;
		xor	bx,bx			;
CloseAll:	mov	ah,DOS_CLOSE		; prevent orphaned DOS files
		int	INT_DOS			;
		inc	bx			;
		loop	CloseAll		;

		free	cs:envp			; free environment space

		xor	dx,dx			; zero out envp
		mov	cs:envp,dx		;

		lea	dx,CheckLoad		; finally load the TSR
		mov     cl,4                    ; convert bytes to paragraphs
		shr     dx,cl                   ;
		inc     dx                      ; be on the safe side

		mov     ah,DOS_TSR              ; make it a TSR
		mov     al,ERR_NONE             ; terminate with no error
		int     INT_DOS                 ; all done!

;  ***************************************************************************
;  *                                                                         *
;  * These are the program messages not needed for the TSR part              *
;  * To ease maintainability and I18N they are in a seperate file.           *
;  *                                                                         *
;  ***************************************************************************

INCLUDE		NEWINT.MSG

		END     start                   ;
