%{ /* -*-C-*- */

/* asc2iso.l Version 0.510
 * lex file for converting Ascii German into diacritical German
 * Version 1.0 of diac.l written by
 *  Dorai Sitaram, Rice University, 1990   dorai@titan.rice.edu
 *
 * Version 1.1 of diac.l:
 * General rewrite, using some Material from
 *    H.Kaeslin, Behandlung der Umlaute bei der Verarbeitung deutscher
 *    Texte unter Unix, in: it, Vol 1, 1988
 * and Duden - die Rechtschreibung.
 *
 * Gustaf Neumann, Wirtschaftsuniversitaet Wien, October 1990
 * neumann@dec4.wu-wien.ac.at         neumann@awiwuw11.bitnet
 *
 * Version 1.2 of diac.l was renamed to version 0.400 of asc2iso.l:
 *    Output is now ISO-8859-1 instead of LaTeX
 *    done by Karl Brodowsky <bro@clio.iwr.uni-heidelberg.de>
 *
 * The resulting LaTeX file uses german.sty!
 * Representation of umlaut characters:    \"a \"A \"o \"O \"u \"U {\ss}
 * The style file german.sty would allow    "a  "A  "o  "O  "u  "U "s
 * as well, but the latter representation makes it impossible to
 * to distinguish between umlaut characters and quoted text. This distinction
 * is necessesay in cases where quotes should be changed into opening and
 * closing german quotes (\glqq and \qrqq) in an automated way (another
 * lex program).
 *
 * If you do NOT want to use GERMAN.STY, replace underneath the ruleset
 * for \documentstyle with the following rule:

\\documentstyle[^\}]*\}	{ printf("%s\n", yytext);
			printf("\\newskip\\zeeskip\n");
			printf("\\zeeskip=0pt plus0pt minus0pt\n");
			printf("\\def\\1{\\nobreak\\hskip\\zeeskip}\n");
			printf("\\let\\umlaut\\\"\n");
			printf("\\def\\\"#1{\\1\\umlaut#1\\1}\n");
			printf("\\let\\oldss\\ss\n");
			printf("\\def\\ss{\\1\\oldss\\1}\n"); }
 *
 *
 * To prevent the conversion from Ascii German into diacritical German,
 * it is necessary to insert empty groups into the words (e.g. Ka{}eslin).
 */

#include "asc2iso-aux.h"
int i;
%}

%p 6500
%n 1000
%e 2500
%a 4000
%k 2500
%o 3500


V	[AEIOUaeiou]
C	[B-DF-HJ-NP-TV-Zb-df-hj-np-tv-z]
W	[ "'\t\n,;!?().]
b       [ \t\n]

%%

\\input{b}*\{[^\}]+\}	{ texfile = getfilenamebrack(&yytext[6]);
			tempfile = maketempfilename(texfile);
			printf("\\input{%s}", tempfile);
			dosubasc2iso(texfile, tempfile); }

\\input{b}*[^ \t\n]+	{ texfile = getfilename(&yytext[6]);
			tempfile = maketempfilename(texfile);
			printf("\\input %s", tempfile);
			dosubasc2iso(texfile, tempfile); }

\\begin\{.+\}	ECHO;
\\end\{.+\}	ECHO;
\\[A-Za-z]+	ECHO;
[A-Za-z0-9%$.+!-]+@[A-Za-z0-9%$.+!-]+	ECHO;
[A-Za-z0-9%$.+!-]+![A-Za-z0-9%$.+-]+	ECHO;


%{ /* ue */
%}

[Rr]euessier 		printf("%cessier", yytext[0]);
[Bb]aeuer		printf("%cuer",yytext[0]);
[Zz]uende[nrt]		printf("%cnde%c",yytext[0],yytext[6]);
[Zz]uende[^nrt]		printf("%cuende%c",yytext[0],yytext[6]);
[Aa]nzuende[nrt]	printf("%cnznde%c",yytext[0],yytext[8]);
[Aa]uszueg		printf("%cuszg",yytext[0]);
bezueg		printf("bezg");
[tmr]eueber	printf("%ceber",yytext[0]);
tzueber		printf("tzber");
[^igGbB][Ee]ue 	ECHO;
[QqAa]ue 	ECHO;
[Uu]e[iu] 	ECHO;
[Gg]etue{W}	ECHO;
[a-rt-z]tuend	ECHO;
{W}tuet{W}	ECHO;
[Nn]ichtstuend	ECHO;
[Nn]ichtstuer	ECHO;
Tuerei{W}	ECHO;
[a-z]tuerei	ECHO;
[a-z]tuerisch	ECHO;
[Aa]bzue[b-z][a-z]*[elr]n	ECHO;
[Aa]nzue[b-z][a-z]*[elr]n	ECHO;
[Aa]u[fs]zue[b-z][a-z]*[elr]n	ECHO;
[Ee]inzue[b-z][a-z]*[elr]n	ECHO;
[Gg]uess			ECHO;
[Gg]renzueber			printf("%crenzber",yytext[0]);
[Hh]inzue[b-z][a-z]*[elr]n	ECHO;
[Mm]itzue[b-z][a-z]*[elr]n	ECHO;
[Nn]achzue[b-z][a-z]*[elr]n	ECHO;
[Tt]ue{W}			ECHO;
[Vv]orzue[b-z][a-z]*[elr]n	ECHO;
[Ww]iederzue[b-z][a-z]*[elr]n	ECHO;
[Zz]uege 			printf("%cge",yytext[0]);
[Zz]uege[nl]			printf("%cge%c",yytext[0],yytext[5]);
[Zz]uegeln			printf("%cgeln",yytext[0]);
[Zz]ue[b-z][a-z]*[elr]n		ECHO;
[Zz]urueckzue[b-z][a-z]*[elr]n	printf("%curckzu%s",yytext[0],&yytext[9]);
tuendere	ECHO;
[Aa]biguen	ECHO;
[Aa]ffluen	ECHO;
[Bb]u[ea]nos	ECHO;
[Bb]uesse	printf("%ce",yytext[0]);
[Dd]uett	ECHO;
[Dd]uell	ECHO;
entuell 	ECHO;
euer		ECHO;
[Ff]luess{C}	printf("%cl%c",yytext[0],yytext[6]);
[Gg]raduell	ECHO;
[Gg]rues[sz]	printf("%cr",yytext[0]);
[Gg]uerill	ECHO;
[Ii]ndividuen	ECHO;
[Ii]nfluen	ECHO;
[Ii]ssue	ECHO;
[Ll]eague	ECHO;
Lueger	        ECHO;
[krx]tuell	ECHO;
[Kk]ongruen	ECHO;
[Kk]onstituen	ECHO;
[Mm]enuett	ECHO;
[Mm]anuel	ECHO;
[Mm]igue[tl]	ECHO;
[Pp]irouett	ECHO;
[Pp]uerto	ECHO;
[Rr]esiduen	ECHO;
[Rr]ituell	ECHO;
[Ss]chuesse	printf("%cchsse",yytext[0]);
[Ss]tatue	ECHO;
[Ss]exuell	ECHO;
[Ss]uez		ECHO;
[Ss]uess	printf("%c",yytext[0]);
[Ss]uesse	printf("%ce",yytext[0]);
[^mM]uessig	printf("%cssig",yytext[0]);
[Tt]rue{W}	ECHO;
Uelzen		ECHO;
[Vv]alue{W}	ECHO;
[Vv]enezuel	ECHO;
[Vv]isuell	ECHO;
[Zz]uerkannt	ECHO;
[Zz]uerteil	ECHO;
[Zz]uerst	ECHO;


%{ /* ae */
%}

[Aa]ero		ECHO;
[Aa]lpentaeler	printf("%clpentler",yytext[0]);
[Dd]odekae	ECHO;
[Ff]aeroe	printf("%cr",yytext[0]);
[Gg]e[fm]aess	printf("%ce%c",yytext[0],yytext[2]);
[Hh]exae	ECHO;
[Ii]kosae	ECHO;
[Ii]srael	ECHO;
[Kk]afkaesk	ECHO;
aeuel           printf("uel");
aesser		printf("sser");
[Mm]ichael	ECHO;
[Mm]etae	ECHO;
[Oo]ctae	ECHO;
[Pp]assstraess{C}	printf("%castr%c",yytext[0],yytext[11]);
[Pp]entae	ECHO;
[Pp]harmae	ECHO;
[PpNn]aess{V}	printf("%css%c",yytext[0],yytext[5]);
[Rr]affael	ECHO;
[Rr]afael	ECHO;
[Rr]aphael	ECHO;
Schaeffer	ECHO;
Straelen	ECHO;
[Ss]traess{C}	printf("%ctr%c",yytext[0],yytext[7]);
[Tt]etrae	ECHO;
[Tt]hemae	ECHO;
[Ss]chemae	ECHO;
[Ss]amuel	ECHO;

%{ /* oe */
%}

[Aa]utoe	ECHO;
[Bb]enzoe	ECHO;
[Bb]uchloe	ECHO;
[Bb]ruttoein	ECHO;
[Cc]hemoe	ECHO;
Coesfeld	ECHO;
[Dd]iarrhoea	ECHO;
[Ee]lektroe	ECHO;
[Gg]oethe	ECHO;
[Gg]roesse	printf("%cre",yytext[0]);
[Hh]eroen 	ECHO;
[Hh]o[ml]oe 	ECHO;
[Hh]ydroe 	ECHO;
[Ii]ndoeuro	ECHO;
Itzehoe		ECHO;
Joel	        ECHO;
[Kk]inoe 	ECHO;
[Kk]oedukat 	ECHO;
[Kk]oeffizi 	ECHO;
[Kk]oerzi 	ECHO;
[Kk]oexist 	ECHO;
[Cc]oexist 	ECHO;
[Kk]oenzym 	ECHO;
[Kk]ontoe 	ECHO;
[Nn]oether	ECHO;
[Nn]ettoei	ECHO;
Oelde		ECHO;
Oeynhausen	ECHO;
[Ss]oeben 	ECHO;
Soest   	ECHO;
[Mm]etazoe 	ECHO;
[Mm][ai][ck]roe ECHO;
[Mm]onoe 	ECHO;
[Nn]euroe 	ECHO;
[Oo]boe 	ECHO;
[Oo]erlikon 	ECHO;
[Oo]ldesloe	ECHO;
[Oo]kto 	ECHO;
[Oo]pto 	ECHO;
[Pp]oesie 	ECHO;
[Pp]oebene 	ECHO;
[Pp]iezo 	ECHO;
[Pp]hoto 	ECHO;
[Pp]hysioe 	ECHO;
[Pp]oe[mt]i 	ECHO;
[Pp]oe[mt][^a-z]	ECHO;
[Pp]orto 	ECHO;
[Pp]roenzy	ECHO;
[Pp]roto	ECHO;
[Pp]rotozoe 	ECHO;
[Pp]seudo 	ECHO;
[Pp]sycho 	ECHO;
[Pp]yro 	ECHO;
[Rr]adio 	ECHO;
[Tt]empo	ECHO;
[Tt]otoer	ECHO;
[Tt]urbo	ECHO;
[Vv]ideo	ECHO;
hloesser	printf("hlsser");


%{ /* aa */
%}

Aaby		printf("by");
Aalborg		printf("lborg");
Aalesund	printf("lesund");
Aandalsnes	printf("ndalsnes");
Aarhus		printf("rhus");
Boraas		printf("Bors");
Luleaa		printf("Lule");
Skelefteaa	printf("Skelefte");
Snaasa		printf("Snsa");
Umeaa		printf("Ume");
Vaesteraas	printf("Vsters");
Torneaa		printf("Torne");
Kraakmo		printf("Krkmo");
Aabo		printf("bo");
Laatefossen	printf("Ltefossen");
Aakrafjord	printf("krafjord");
Voeringfoss	printf("Vringfoss");
Laagen		printf("Lgen");


%{ /* ss */
%}

{W}s[sz][a-z]	ECHO;
{V}sss		printf("%cs",yytext[0]);
bss		ECHO;
{C}{V}sser{W}	ECHO;
{C}{V}sser{V}	ECHO;
{C}{V}ssen	ECHO;
[^rSs]uesse[ln] 	printf("%csse%c",yytext[0],yytext[6]);
[Ff]okuss	ECHO;
[Ff]ossil	ECHO;
[Gg]ewissermassen	printf("%cewissermaen",yytext[0]);
[Mm]utmass		printf("%cutma",yytext[0]);
[Aa]ussasse	ECHO;
Dessau		ECHO;
Esso		ECHO;
Esslingen	ECHO;
[Hh]ausstrasse	printf("%causstrae",yytext[0]);
Kevelaer	ECHO;
Kossau		ECHO;
Moers		ECHO;
[Mm]issacht	printf("%ciacht",yytext[0]);
Neuss		ECHO;
ungstrasse	ECHO;
eitstrasse	ECHO;
[Dd]issona	ECHO;
[Ii]nsasse	ECHO;
usstrass	printf("usstrae");
ssatz		ECHO;
ssaetze		printf("sstze");
ssach		ECHO;
ssag		ECHO;
ssitua		ECHO;
sstoff		ECHO;
sserver		ECHO;
sseite		ECHO;
sspiel		ECHO;
sspur		ECHO;
sstern		ECHO;
sstand		ECHO;
sstufe		ECHO;
ssond		ECHO;
eeressp		ECHO;
essor		ECHO;
[^ns][Ss]assen	printf("%c%caen",yytext[0],yytext[1]);
ssstrasse	printf("strae");
[^s]sstrasse	printf("%csstrae",yytext[0]);
[Pp]assstrasse	printf("%castrae",yytext[0]);
[Pp]ass{V}	ECHO;
[Pp]reisst	ECHO;
[MmNn]uesse	printf("%csse",yytext[0]);
[Ss]pass[ie]	printf("%cpa%c",yytext[0],yytext[5]);
osso		ECHO;
[Aa]usmass	printf("%cusma",yytext[0]);
[Kk]arosse	ECHO;
[Mm]asses	printf("%caes",yytext[0]);
[mn]{W}+Masse	fwrite( yytext, yyleng-3, 1, yyout );printf("e");
[Mm]esseinri	printf("%ceeinri",yytext[0]);
Massarykovo	ECHO;
Scheessel	printf("Scheeel");
Voss		ECHO;
Langfoss	ECHO;
cmss		ECHO;
isse		ECHO;
oiss		ECHO;
ouss		ECHO;
issig		ECHO;
luesse 		printf("lsse");
iess[^tp]	printf("ie%c",yytext[4]);
ssung 		ECHO;
ssel 		ECHO;
ssich		ECHO;
ssoren 		ECHO;
ssiez 		ECHO;
ccess 		ECHO;
ssidy 		ECHO;
chss 		ECHO;
ssch 		ECHO;
sspiegel	ECHO;
ssuend		printf("ssnd");
ssystem		ECHO;
sspr[^o]	ECHO;
ssier 		ECHO;
nisse		ECHO;
lss 		ECHO;
tionss		ECHO;
tss		ECHO;
ussisch		ECHO;
ungss		ECHO;
weissch		ECHO;
usserl{W}	ECHO;
sstr		ECHO;
[Aa]ssoz	ECHO;
[Aa]ssi		ECHO;
[Aa]ssemb	ECHO;
[Aa]uss[^e]	ECHO;
[Aa]usse[^rn]	ECHO;
[Aa]ussende	ECHO;
Barbarossa	ECHO;
[Ee]sse		ECHO;
[Bb]isschen	printf("%cichen", yytext[0]);
[Bb]usiness	ECHO;
[Ee]inbusse	printf("%cinbue",yytext[0]);
[Ee]inbuesse	printf("%cinbe",yytext[0]);
[Gg]eldbusse	printf("%celdbue",yytext[0]);
[Bb]usse	ECHO;
[Bb]ussard	ECHO;
[Cc]ross	ECHO;
[Dd]iskussion	ECHO;
[Dd]issert	ECHO;
[Dd]asselb	ECHO;
[Ee]ssi		ECHO;
[EeAa][iu]ss	printf("%c%c", yytext[0],yytext[1]);
essur		ECHO;
[Ff]lusse	ECHO;
[Ff]luess[ie]	printf("%clss%c", yytext[0],yytext[6]);
[Ff]usses	printf("%cues",yytext[0]);
[Ff]ass{V}	ECHO;
[Ff]aesser	printf("%csser",yytext[0]);
[FfGg]aesschen	printf("%cchen",yytext[0]);
[Gg]ass[ei]	ECHO;
[Gg]lass[pt]	ECHO;
[Hh]asse	ECHO;
[Mm]essage	ECHO;
triebss		ECHO;
beitss		ECHO;
[Ss]trasse 	printf("%c%crae",yytext[0],yytext[1]);
ungsstrasse	printf("ungsstrae");
eitsstrasse	printf("eitsstrae");
hrsstrasse	printf("hrsstrae");
[Rr]asse	ECHO;
{C}usses	ECHO;
Wissmann	ECHO;
Gauss		printf("Gau");
Grass		ECHO;
[Gg]enosse	ECHO;
[Gg]rosse       printf("%croe",yytext[0]);
[gG]l?osse	ECHO;
[Ii]nteress	ECHO;
[Kk]lass[ie]	ECHO;
[Kk]assette	ECHO;
[Ll]asse	ECHO;
[Ll]aessig	printf("%cssig", yytext[0]);
[Mm]assa[^nr]	ECHO;
[Mm]asseu	ECHO;
[Mm]isser{C}	printf("%cier%c", yytext[0],yytext[6]);
[Mm]isstrau	printf("%citrau",yytext[0]);
[Mm]iss[ei]	ECHO;
[Ee]rmassen	printf("%crmaen", yytext[0]);
[MmKkCc]ass[ei]	ECHO;
[oO]dyssee	ECHO;
[Pp]rivatissi	ECHO;
[Pp]assiv	ECHO;
[Pp]rozessor	ECHO;
Pyrrussieg	ECHO;
[Ss]chloss{V}	ECHO;
[Ss]tossen	printf("%ctoen", yytext[0]);
[Rr]essource	ECHO;
[Vv]erkehrss[^tu]        ECHO;
[Ww][ia]sse	ECHO;
[Ww]eissag	ECHO;

%{ /* sz */
%}
{V}szs		printf("%cs",yytext[0]);
[EeAu][iu]sz	printf("%c%c", yytext[0],yytext[1]);
[Aa]uszahl	ECHO;
[Aa]uszeich	ECHO;
[Aa]usz[iu]	ECHO;
bsz		ECHO;
[Ee]iszeit	ECHO;
psz		ECHO;
dsz		ECHO;
tsz		ECHO;
gsz		ECHO;
ksz		ECHO;
hrsz		ECHO;
fsz		ECHO;
szu		ECHO;
iesz		printf("ie");
[bdeln]sziel	ECHO;
[bdeln]szeit	ECHO;
[bdeln]szelle	ECHO;
[bdeln]szeug	ECHO;
[bdelnh]szahl	ECHO;
[bdeln]szentr	ECHO;
[bdeln]szins	ECHO;
[bdeln]szeich	ECHO;
szylinder	ECHO;
nisz		ECHO;
[Bb]iszchen	printf("%cichen", yytext[0]);
[Dd]isziplin	ECHO;
[Ee]iszapf	ECHO;
Eszet		ECHO;
[Ff]aszin	ECHO;
[Gg]rosze       printf("%croe",yytext[0]);
Lusztig		ECHO;
[Mm]aszung	printf("%caung",yytext[0]);
[Mm]iszer{C}	printf("%cier%c", yytext[0],yytext[6]);
[Ee]rmaszen	printf("%crmaen", yytext[0]);
[Ff]luszufer	printf("%cluufer",yytext[0]);
[Ss]toszen	printf("%ctoen", yytext[0]);
[Tt]ranszend	ECHO;

{C}ss{C}	ECHO;

Ae		printf("");
Oe		printf("");
Ue		printf("");
ae		printf("");
oe		printf("");
ue		printf("");
ss		printf("");
sz		printf("");
