%{
/*
 * Yacc file for sumitup.
 *
 * HISTRORY
 * 
 *   $Log:	parse.y,v $
 * Revision 1.2  91/06/10  08:24:05  cessu
 * Changed yyerror so that it returns, thus hopefully improving error recovery
 * 
 * Revision 1.1  91/06/10  08:22:19  cessu
 * Initial revision
 * 
 */

#include <stdio.h>

int yyerror(msg)
char *msg;
{
  fprintf(stderr, "%s\n", msg);
}

%}

%start expressions

%union {
  double numerical;
  double (*function)();
}

%token COMMA OPEN_PAREN CLOSE_PAREN
%token <numerical> CONSTANT
%token <function> UNARY_FUNCTION BINARY_FUNCTION
%type <numerical> expression

%left SEMICOLON
%left PLUS_OP MINUS_OP
%left TIMES_OP DIVIDES_OP
%left UMINUS

%%

expressions: expression SEMICOLON { printf("%lf\n", $1); } expressions
	|
	;

expression: OPEN_PAREN expression CLOSE_PAREN 		    { $$ = $2; }
	| UNARY_FUNCTION OPEN_PAREN expression CLOSE_PAREN  { $$ = $1($3); }
	| BINARY_FUNCTION OPEN_PAREN expression COMMA expression CLOSE_PAREN
							    { $$ = $1($3,$5); }
	| expression PLUS_OP expression                     { $$ = $1 + $3; }
	| expression MINUS_OP expression		    { $$ = $1 - $3; }
	| expression TIMES_OP expression		    { $$ = $1 * $3; }
	| expression DIVIDES_OP expression		    { $$ = $1 / $3; }
	| MINUS_OP expression %prec UMINUS		    { $$ = - $2; }
	| CONSTANT					    { $$ = $1; }
	;

%%

extern FILE *yyin;

main()
{
  yyin = stdin;
  return yyparse();
}
