/* This program is the main-part of a bunch of files that make up the taalam
 * program.  They are,

-rw-------  1 seetam       2933 Mar  2 19:14 database.h
-rw-------  1 seetam       2199 Mar  2 19:14 readnum.h
-rw-------  1 seetam       2334 Mar  2 19:15 screen.h
-rw-------  1 seetam       6174 Mar  2 19:15 setup.h
-rw-------  1 seetam       1414 Mar  2 19:16 sound.h
-rw-------  1 seetam       7651 Mar  2 19:11 taalam.c
-rw-------  1 seetam       6571 Mar  2 19:12 taalam.doc
-rw-------  1 seetam      17739 Mar  2 19:21 taalam.exe
-rw-------  1 seetam       1167 Mar  2 19:18 taalam.viv
-rw-------  1 seetam       2095 Mar  2 19:16 timing.h

			The *.h files are automatically included in taalam.c;
   Use microsoft C to compile this program set.
   Read the Copyright file, which does not authorize U to use this program :-)
 +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
			Seetamraju Udaya Bhaskar Sarma
			(email : seetam @ ece7 . eng . wayne . edu)
 +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

/* This program is to play the taaLams.  The usage is :-
 * See the taaLam.doc & taaLam.viv files for more information...
 * The options clearly are order sensitive : i.e., parameter inputs if
 *     rearranged, will mean something else...
 */

#define TRUE 1
#define FALSE 0
#define NOT !
#define EndIf }
#define EndWhile }
#define EndFor }
#define NotFound 0
#define Found    1
#define FOREGRND 219
#define BACKGRND 176

#include <stdio.h>
#include <string.h>
#include <time.h>
#include <bios.h>
#include <dos.h>
#include <conio.h>
#include <stdlib.h>

char    ** argv;
int     NoOftaaLams, taaLam_kaalam, ReadingFromFile;
enum    taaLa_x         { vElu, bOrla, vellika };
char    taaLam_pEru[128];
typedef struct
	{  enum    taaLa_x      taaLam;
	   int     gap;
	}  taaLa_details_type;
taaLa_details_type              taaLaList[256];
FILE *FP;

#include "screen.h"
#include "timing.h"
#include "sound.h"


main(int argc, char **argv_tmp)
{  int     kaalam_given_on_cmdline,  Default_kaalam;
   int     jaati, Default_laghu_jaati, jaati_given;
   int	   item_no, ch, ii, jj, mm; 
   char    *NextArg;
   struct  dostime_t    InitKeyPressTime;
   void    Play_taaLams(void);
   char    *GetNextArg(void);
   void    UngetArg(char *);
   int     Search_taaLam_InFile(char *, FILE *);

printf("\n\nProgram written by Seetamraju Uday Bhaskar Sarma\n\n");

#include "setup.h"  /* This file `setup.h' contains the body of the main()
			function, which does all the command line and user
			input processing and setting up of this program */

Play_taaLams();
/* The global scope variable `taaLamList' has all the info needed to play */

} /* End of main() function */

/*........................................................*/
#include "database.h"
/*............................................*/

/* All the information about what taaLam to play and how to play is all
 * available in the global scope variable called `taaLamList' -- its an
 * array of structures... see the beginning of this file for more on how
 * its structure is...  **/

struct dostime_t taaLamStartedAt;

void Play_taaLams()
{ void vElu_Sabdam(void);
  void bOrla_hastam(void);
  void vellikala_hastam(void);
  int niSSabdam(void);
  void Adjust_kaalam(int);
  void AdjustStartTimeVV( int );
  void DrawRectangle ( char, int, int, int, int );
  int iii,ix,ch;

RESTART_taaLam:
  printf( "\n\n\tStarting a new taaLam of count %d & avarta kaalam = %d\n%s",
		NoOftaaLams,  taaLam_kaalam,
	  "\t\tPress any key again to synchronize (please)\n\n" ); getch();
  ClearScreen();
  (void) DrawRectangle( BACKGRND, 12, -3, 17, 2); /* boTana_vElu */
  GetTimeIn_Centisecs(taaLamStartedAt);
  for ( iii=0;  TRUE ; /* */ )  /* taaLam Sabdam for ever */
  {  switch (taaLaList[iii].taaLam)
       {  case vElu     : vElu_Sabdam();  iii=niSSabdam(); break;
	  case bOrla    : bOrla_hastam(); iii=niSSabdam(); break;
	  case vellika  : vellikala_hastam(); iii=niSSabdam(); break;
       } /*..... End Switch ....*/
     if (_bios_keybrd(_KEYBRD_READY)) ch=0xFF&getch();  else ch=00;
     /* Check to see if a character (from KBD) if avail, this call enables
      * the BIOS to recieve characters when typed by user during execution.
      * This attitude helps us to task switch in DOS5.0 or to use CNTL-C */
     if ((ch=='=')||(ch=='+')) Adjust_kaalam( +1 );
     if ((ch=='_')||(ch=='-')) Adjust_kaalam( -1 );
     if (ch=='?') { MoveCursorTo(23, 10); printf("taaLam_pEru [%s], avarta kaalam=%d, taaLam count=%d\n",taaLam_pEru,taaLam_kaalam,NoOftaaLams); }
     if ((ch=='r')||(ch=='R')) goto RESTART_taaLam;
     if ((ch=='<')||(ch==',')) AdjustStartTimeVV(-1);
     if ((ch=='>')||(ch=='.')) AdjustStartTimeVV(1);
  } /* End For Loop */
}

/*............................................*/

int niSSabdam()
{ struct dostime_t CurrentTimeIn_centisecs, NewTime;
  int ii, pp, sum, ResidueTime;
  long ResTim;
  void DelayFor(int);
  void AdjustStartTime( struct dostime_t );
  int  TimeDifference( struct dostime_t, struct dostime_t );

  GetTimeIn_Centisecs( NewTime );
  ResTim = TimeDifference( NewTime, taaLamStartedAt );
  pp = (int) ( ResTim / taaLam_kaalam );
  if (pp > 0)  /* Only then do the following */
  #define UU unsigned char
  { struct dostime_t T;
    T.hour = (UU) (pp*taaLam_kaalam/360000);
    T.minute=(UU)((pp*taaLam_kaalam-T.hour*360000)/6000);
    T.second= (UU)((pp*taaLam_kaalam-T.hour*360000-T.minute*6000)/100);
    T.hsecond = (UU) (pp*taaLam_kaalam-T.hour*360000-T.minute*6000-T.second*100);
    AdjustStartTime( T );  /** does this :-> taaLamStartedAt += pp * taaLam_kaalam  **/
  }
  ResidueTime = (int) (ResTim - pp * taaLam_kaalam);
  for ( ii=0,sum=0; sum<=ResidueTime; ii++ )
      { sum += taaLaList[ii].gap;  if (ii+1>=NoOftaaLams) ii=-1;  }
  DelayFor( sum - ResidueTime );
  return ( ii );
}

/*............................................*/
int finger;
int x1,x2, y_1,y2;
void DrawRectangle( char, int, int, int, int);
#define FLASHDELAY  DelayFor(20);

void vElu_Sabdam()
{ void sound(int, int);  void DelayFor (int);
  switch (finger) {
     case 0 : x1=5;y_1=22; x2=11;y2=25; break;
     case 1 : x1=1;y_1=16; x2=10;y2=19; break;
     case 2 : x1=0;y_1=10; x2=10;y2=13; break;
     case 3 : x1=2;y_1= 4; x2=11;y2= 7; break;
	  } /*.. end switch .. */
  (void) DrawRectangle( FOREGRND, x1,y_1, x2,y2);
  finger++;  if (finger>=4) finger=0;
  sound(6000, 4 );  FLASHDELAY
  (void) DrawRectangle( BACKGRND, x1,y_1, x2,y2);
} /* End of VOID fn */
/*............................................*/
#define COMMONLINE  finger = 0; x1=11;y_1=4; x2=18;y2=25;
void bOrla_hastam()
{ void sound(int, int);  void DelayFor (int);
  COMMONLINE
  (void) DrawRectangle( ' ', x1,y_1, x2,y2);
  sound(  20, 15 );  FLASHDELAY
  (void) DrawRectangle( BACKGRND, x1,y_1, x2,y2);
} /* End of VOID fn */
/*............................................*/
void vellikala_hastam()
{ void sound(int, int);  void DelayFor (int);
  COMMONLINE
  (void) DrawRectangle( FOREGRND, x1,y_1, x2,y2);
  sound(  20, 2 ); /* send a 100 Hz freq for 0.4 secs */
  sound( 100, 4 );  FLASHDELAY
  (void) DrawRectangle( BACKGRND, x1,y_1, x2,y2);
} /* End of VOID fn */

/*............................................*/

void Adjust_kaalam(int adjust)
{ int ixlx;
  for( ixlx=0; ixlx<NoOftaaLams; ixlx++) taaLaList[ixlx].gap += adjust;
  taaLam_kaalam += NoOftaaLams*adjust;
}

/*............................................*/

void AdjustStartTime (struct dostime_t Delta)
{ int hsCO, secCO, minCO;
#define SS taaLamStartedAt
#define hr Delta.hour
#undef min
#define min Delta.minute
#define sec Delta.second
#define hs  Delta.hsecond
  hsCO= secCO= minCO= 0;
  if( (hs+SS.hsecond)>100 ) {SS.hsecond += hs-100; hsCO=1;} else SS.hsecond += hs;
  if( (sec+SS.second+hsCO)>60 ) {SS.second += sec+hsCO-60; secCO=1;} else SS.second += sec+hsCO;
  if( (min+SS.minute+secCO)>60 ) {SS.minute += min+secCO-60; minCO=1;} else  SS.minute += min+secCO;
  if( (hr+SS.hour+minCO)>24 ) {SS.hour += hr+minCO-24;} else SS.hour += hr+minCO;
} /* Does this :-> taaLamStartedAt += pp * taaLam_kaalam  **/

/*............................................*/

void AdjustStartTimeVV (int II)
{ struct dostime_t U;
#define STEPSIZE 10
  if (II == 1)
  { U.hour= U.minute= U.second= 0; U.hsecond= STEPSIZE; }
  else  if (II == -1)
	{ U.hour=23; U.minute=59; U.second=59; U.hsecond=100-STEPSIZE; }
  else printf("unimplemented AdjustStartTimeVV parameter value");

  AdjustStartTime( U );
}

/* ............................... EOF ....................................*/
