/* ............................ screen.h ..................................
 * This file contains my own graphics routines that are simple and fast
 * and dont require sophisticated calls or ANSI.sys etc...
 */
/*....................................*/

#define ROWBIAS 3
#define COLUMNBIAS  18

void MoveCursorTo (int row, int col)   /* See the book Microsoft C programming for the IBM -- Robert Lafore -- The Waite Group */
{ union REGS regs, reg22;
  regs.h.ah = 2;
  regs.h.dl = (unsigned char) col;
  regs.h.dh = (unsigned char) row;
  regs.h.bh = 0; /* page 0 */
  int86( 0x10, &regs, &reg22 ); /* Video Interrupt Routine */
}
/*......................................*/

char FG_LINE[100],BLANKLINE[100],BG_LINE[100];
char CurrentFillChar;

void ClearScreen()  /* write 25 blank lines ! */
{ int line;
  for (line=0; line<25; line++)
  {  MoveCursorTo( line, 0); printf("                                                                                "); }
  for (line=0; line<100; line++)  FG_LINE[line]=FOREGRND;  /* initialize it' */
  for (line=0; line<100; line++)  BLANKLINE[line]=' ';  /* initialize it' */
  for (line=0; line<100; line++)  BG_LINE[line]=BACKGRND;  /* initialize it' */
}
/*.....................................*/
void DrawRectangle ( ch, rowi, coli, rowf, colf )
int rowi, coli, rowf, colf;
int ch;
{ int ii2;  char *CharPtr;

  switch (ch)
   { case FOREGRND : CharPtr = FG_LINE;  break;
     case ' '      : CharPtr = BLANKLINE; break;
     case BACKGRND : CharPtr = BG_LINE; break;
     default       : CharPtr = BG_LINE; break;
   } /* End switch */
  CharPtr[colf-coli+1] = '\0';  /* Make a corresponding STRING of chars */
  for(ii2=rowi; ii2<rowf; ii2++)
     { MoveCursorTo(ii2+ROWBIAS, coli+COLUMNBIAS); puts(CharPtr);}
  CharPtr[colf-coli+1] = (char)ch;   /* Restore the line */
}
/*.....................................*/
/* Some other int86 commands....
/* inregs.h.ah = 9;  /* Display character interrupt serive routine */
/* inregs.h.al = ch; /* The char to be displayed */
/* inregs.h.bh = 0; /* Video Page # */
/* inregs.h.bl = 1; /* Color */
/* inregs.x.cx = 1; /* Count of Chars */
/* int86 ( 0x10, &inregs, &outregs ); /* Now make the call to display char */
/*..............................<EOF>..............................*/
