/* ITRANS song book utility to combine multiple song files into
 * a single file (for TeX usage only).
 * Program to accept a list of isong file names from stdin, and
 * print them out to stdout, adding a \def\songfile before each file.
 * Make sure to edit isitx.hdr as required - font size, two column
 * format, etc as needed.
 *
 * TWO Ways to run this program:
 * 1)
isongcat < _index > allsongs.s
 * (assume _index is a file that contains lines like:
136.s: a.ndhe jahaa.n ke a.ndhe raaste,  jaaye.n to jaaye.n kahaa.n
 78.s: a.nkhiiyo.n ke jharokho.n se
 12.s: aa chal ke tujhe mai.n le ke chaluu.n
 ......)
 * The above command will read each line in the _index file, and if the
 * first word is a number, that isong file (<number>.s) will be printed out
 * to stdout.
 * 2)
isongcat <startnum> <endnum> > allsongs.s
 *
 * <number>.s is searched for in the current directory, and in the
 * directory numbered "<number> / 100" (integer divison, truncated)
 */
 
/*------------------------------------------------------------------*/
/* This file is part of the ITRANS song book package.
 * avinash@acm.org
 */
/*------------------------------------------------------------------*/
/* MS-DOS info: compile this into a .com file - tiny model.
 * bcc -N -mt -lt isongcat.c
 */
/* UNIX info: (not tested on UNIX), but a simple
 * cc -o isongcat isongcat.c
 * should work.
 */

#include <stdio.h>

#define LEN_STRING 1024

/* MS-DOS */
#if defined(__MSDOS__) || defined(MSDOS)
#define FOPEN_READ_TEXT "rt"
/* don't use this, printing out songfile causes problems, and anyway,
 * / works just fine under dos too.
 *  #define DIR_SEP '\\' */
#else
/* UNIX */
#define FOPEN_READ_TEXT "r"
#endif

#define DIR_SEP '/'

int handle_isongfile(int fno)
{
    FILE* ifp; 
    char fname[LEN_STRING];
    int c;

    sprintf(fname, "%d.s", fno);
    ifp = fopen(fname, FOPEN_READ_TEXT);
    if (!ifp) {
	sprintf(fname, "%d%c%d.s", fno/100, DIR_SEP, fno);
	ifp = fopen(fname, FOPEN_READ_TEXT);
	if (!ifp) return 0;
    }

    printf("%% ------- ISONGCATed FILE: ---------------\n");
    printf("\\def\\songfile{%d.s}\n", fno);
    printf("%% -------\n");
    while ((c = getc(ifp)) != EOF)
        putchar(c);
        
    fclose(ifp);
    return 1;
}

int main(int argc, char* argv[])
{
    char istring[LEN_STRING];
    int hcount  = 0;
    int errcount = 0;
    int fno, f1 = 0, f2 = 0;

    if (argc == 2) {
        f1 = f2 = atoi(argv[1]);
    } else if (argc == 3) {
        f1 = atoi(argv[1]);
        f2 = atoi(argv[2]);
        if (f2 < f1) {
	    f1 = atoi(argv[2]);
	    f2 = atoi(argv[1]);
        }
    }
    
    printf("%% ------- ISONGCAT OUTPUT ------------\n");
    printf("\\hrule height1pt\n");
    printf("%% --------------------------------\n");
    
    if (f1 > 0 && f2 > 0) {
        /* handle a range of file numbers passed thru argv[1] and argv[2] */
	for (fno = f1; fno <= f2; fno ++) {
	    if (handle_isongfile(fno) != 0) {
		hcount++;
	    } else {
		errcount++;
	    }
	}
    } else {
        /* read file numbers from stdin */
	while (fgets(istring, sizeof(istring), stdin)) {
	    if (sscanf(istring, "%d", &fno) == 1) {
		if (handle_isongfile(fno) != 0) {
		    hcount++;
		} else {
		    errcount++;
		}
	    }
	}
    }
    printf("%% --------------------------------\n");
    printf("\\vfill\\hrule height1pt\n");
    printf("%% ------- END OF ISONGCAT OUTPUT ------------\n");
    
    fprintf(stderr, "isongcat: ignored %3d input lines -----------\n", errcount);
    fprintf(stderr, "isongcat: handled %3d song files -----------\n", hcount);
    
    return 0;
}
