/******************************************************************************
 * Copyright (C) 1991 by Wei Sun 
 * All Rights Reserved
 * Version 1.00
 *
 * File: 
 *	GB2PS.C
 *
 * Name: 
 *	GB2PS V1.0
 *
 * SYNOPSIS:
 * 	1)	GB2PS [-h] [-c cclib] [input_file [output_file]]
 *		or
 *	2)	GB2PS [-h] [-c cclib] [input_file] [> output_file]
 *
 * DESCRIPTION:
 * 	GB2PS converts the HANZI GB code article into PostScript printable
 * 	files that can be printed on PostScript printers.
 *	Because the PostScript program is very big normally (around 250k/page
 *	in chinese article),  the spool area will be easily overflow if the 
 *	large print jobs are sent, in this case, use format 1 to generate 
 *	series of PS programs (one file/page), then print them separately.
 *	The name of PS program will be in this format:
 *		output_file.page_number
 *	If you just want to generate one PS program, format 2 can do this
 *	properly.
 *
 * FILES:
 *	gb2ps.c: 	source code
 *	csong24.plib:	24X24 Chinese characters font file.
 *
 * DISTRIBUTION:
 *	This program and the font file are NOT in public domain.  
 *	The files listed in FILES can be freely distributed for 
 *	non-commercial purposes only, and THERE IS NO WARRANTY FOR 
 *	THIS PROGRAM.
 *
 * AUTHOR:
 * 	The author can be reached by Emil: william@anucsd.anu.edu.au
 *	or mail at:
 *
 *	   Wei Sun
 *	   Department of Computer Science
 *	   The Australian National University
 *	   Canberra, ACT 2601
 *	   Australia
 *****************************************************************************/

#include <stdio.h>

#ifndef CCLIB
#define CCLIB  "csong24.plib"
#endif

/* define margins, line space and character space*/
#define _LM 270
#define _RM 4400
#define _TM 700
#define _BM 6300
#define _CSP 90
#define _ASP 45
#define _CLP 100

char	cclib_name[100];
char	filename[100];
char	fn[100];
int	filecount=1;
int	flag=0;
int	charcount=0;
char	fext[10];
long	offset_ASC=0;
long	offset_CH=31488;
long	size_of_ASC=123;
long	size_of_CH=173;
char	line[500];

FILE	*in, *out;
FILE	*cclib;
int	H,V;


int init(arg,arglist)
int arg;
char **arglist;
{
  char** i;
  int k=0;

  *cclib_name=0;
  strcpy(fn,"file");
  in = stdin;
  out = stdout;
  
  for (i=arglist+1; i<arglist+arg; i++) 
	switch (**i)  {
	case '-':
    		switch (*((*i)+1)) {
    		case 'c':
      			strcpy (cclib_name,*(++i));
      			break;
    		case 'h':

    		default:
      			printf("Usage: %s [-h] [-c font] [input_file [output_file]]\n",arglist[0]);
      			exit(0);
		}
		break;
	default:
		switch(k) {
		case 0:
		    if ((in=fopen(*i,"r"))==NULL) {
      			printf("Can't open input file -> %s\n",*i);
      			exit (1);
    		    }
    		    k++;
    		    break;
    		case 1: 
  			flag=1;
    			sprintf(fext,".%d",filecount);
    			strcpy(fn,*i); 
    			strcpy(filename,fn); strcat(filename,fext);
    			if ((out=fopen(filename,"w"))==NULL) {
      				printf("Can't open output file -> %s\n",filename);
      				exit (1);
    			}
			k++;
			break;
		default:
    			printf("Usage: %s [-h] [-c font] [input_file [output_file]]\n",arglist[0]);
    			exit(0);
  		}
  	}
  	
  if (*cclib_name==0)
    strcpy (cclib_name,CCLIB);
  if ((cclib = fopen (cclib_name, "r"))==NULL)
    {
      fprintf(stderr,"Cannot open the chinese font file -> %s\n",
	      cclib_name);
      exit (-1);
    }
  return k;
}

cleanup(i)
int i;
{
  switch(i) { 
  	case 2: fclose(out);
  	case 1: fclose(in);
  }
  fclose (cclib);
}

newline ()
{
	charcount=0; V += _CLP; H=_LM;
	if (V> _BM){
		end_page ();
		V=_TM;
		fprintf(out,"save\n0 0 moveto\n");
	}
}

end_page ()
{
	fprintf(out,"endpage\n");
	if (flag==1) {
		fclose(out);
		filecount++;
		sprintf(fext,".%d",filecount);
		strcpy(filename,fn); strcat(filename,fext);
		if ((out=fopen(filename,"w"))==NULL) {
	      		printf("Can't open output file - %s\n",filename);
			exit(1);
		}
	      	ps_header();
	}
	else return;
}

ps_header ()
{
  fprintf(out,"%%!W. SUN, ANU\n");
  fprintf(out,"/endpage {restore showpage } def\n");
  fprintf(out,"/sc24 {10 10 scale 24 24 true [24 0 0 -24 0 24] } def\n");
  fprintf(out,"/sc12 {10 10 scale 12 24 true [24 0 0 -24 0 24] } def\n");
  fprintf(out,"/H {8 div currentpoint exch pop moveto} def\n");
  fprintf(out,"/V {8 div 840 exch sub currentpoint pop exch moveto} def\n");
  fprintf(out,"%%!End of Prolog\n"); 
}

put_ASC(c)
int c;
{
	char st1[10];
	char st2[10];
	char st3[200];
	charcount++;
	if (c!=' ') {
		fprintf(out,"%d H %d V gsave currentpoint translate\n",H, V);
		fseek(cclib,offset_ASC+c*size_of_ASC,0);
		fgets(line,size_of_ASC,cclib);
		sscanf(line,"%s %s %s",st1,st2,st3);
		fprintf(out,"%s\n%s imagemask\ngrestore\n",&st2[1],st3);
	}
	H+=_ASP;
	if (H>_RM)
		newline ();
}

put_CH(ch1,ch2)
int ch1,ch2;
{
	long addr;
	char st1[10];
	char st2[10];
	char st3[200];
	charcount+=2;
	if (ch1!=0xa1||ch2!=0xa1) {
		fprintf(out,"%d H %d V gsave currentpoint translate\n",H, V);
		addr=(ch1-0xA1)*94+ch2-0xA1;
		fseek(cclib,offset_CH+addr*size_of_CH,0);
		fgets(line,size_of_CH,cclib);
		sscanf(line,"%s %s %s",st1,st2,st3);
		fprintf(out,"%s\n%s imagemask\ngrestore\n",&st2[1],st3);
	}
	H+=_CSP;
	if (H>_RM)
		newline ();
}

main (argc,argv)
int	argc;
char	**argv;
{
  int	ch;
  unsigned char	ch1,ch2;
  int	charno,i;
  char	charcnt;
  int	k,k1;
 
  i=init(argc,argv);
  ps_header ();
  V=_TM; H=_LM;
  fprintf(out,"save\n0 0 moveto\n");
  while ((ch=fgetc (in))!=EOF) {
      ch1 = ch;
      if (ch1==13 || ch1==26) continue; /* for PC format file*/
      else if (ch1=='\n') 
		newline ();
      else if (ch1=='\t') {
		k1=8-charcount%8;
		for (k=0;k<=k1;k++)
			put_ASC(' '); 
      }
      else if (ch1>=0xA1) {
	  ch=fgetc(in);
	  ch2=ch;
          if (ch1==13 || ch==26) continue; /* for PC format file*/
	  else if (ch==EOF || ch=='\n') {
	  	put_ASC(ch1);
	  	newline();
	  }
	  else if (ch2<0xA1) {
	  	put_ASC(ch1);
	  	put_ASC(ch2);
	  }
	  else put_CH(ch1,ch2);
      }
      else put_ASC(ch1);
    }
    flag=0;
    end_page ();
    cleanup(i);
}

