/* $Id: tty.c,v 1.7 1992/07/31 03:32:13 ygz Exp $ */

#ifndef lint
static char *rcs_id="$Id: tty.c,v 1.7 1992/07/31 03:32:13 ygz Exp $";
#endif /* lint */

#include "config.h"

/* 
 * Functions get_pty() and pty_search() in this file are adopted from
 * X11R5 xterm, copyrighted by DEC & MIT.
 */ 

#ifdef hpux
# define	PTYCHAR1	"zyxwvutsrqp"
# define	PTYCHAR2	"fedcba9876543210"
# define	PTYDEV		"/dev/ptym/ptyxx"
# define	TTYDEV		"/dev/pty/ttyxx"
#else   /* !hpux */
# define	PTYCHAR1	"pqrstuvwxyzPQRSTUVWXYZ"
# define	PTYCHAR2	"0123456789abcdef"
# define	PTYDEV		"/dev/ptyxx"
# define	TTYDEV		"/dev/ttyxx"
#endif  /* !hpux */

#ifdef	SYSV
extern char *ptsname();
#endif

#ifdef hpux
# include <sys/utsname.h>
#endif

static char ptydev[32];
static char ttydev[32];
static int pty_search();

/* This function opens up a pty master and stuffs its value into pty.
 * If it finds one, it returns a value of 0.  If it does not find one,
 * it returns a value of !0.  This routine is designed to be re-entrant,
 * so that if a pty master is found and later, we find that the slave
 * has problems, we can re-enter this function and get another one.
 */

get_pty (pty, ttyline)
    int *pty;
    char **ttyline;
{
	strcpy (ptydev, PTYDEV);
	strcpy (ttydev, TTYDEV);

	*ttyline = ttydev;
#if defined(SYSV) && defined(SYSV386)
        /*
	  The order of this code is *important*.  On SYSV/386 we want to open
	  a /dev/ttyp? first if at all possible.  If none are available, then
	  we'll try to open a /dev/pts??? device.
	  
	  The reason for this is because /dev/ttyp? works correctly, where
	  as /dev/pts??? devices have a number of bugs, (won't update
	  screen correcly, will hang -- it more or less works, but you
	  really don't want to use it).
	  
	  Most importantly, for boxes of this nature, one of the major
	  "features" is that you can emulate a 8086 by spawning off a UNIX
	  program on 80386/80486 in v86 mode.  In other words, you can spawn
	  off multiple MS-DOS environments.  On ISC the program that does
	  this is named "vpix."  The catcher is that "vpix" will *not* work
	  with a /dev/pts??? device, will only work with a /dev/ttyp? device.
	  
	  Since we can open either a /dev/ttyp? or a /dev/pts??? device,
	  the flag "IsPts" is set here so that we know which type of
	  device we're dealing with in routine spawn().  That's the reason
	  for the "if (IsPts)" statement in spawn(); we have two different
	  device types which need to be handled differently.
	  */
        if (pty_search(pty) == 0)
	    return 0;
#endif /* SYSV && SYSV386 */
#if (!defined(_SEQUENT_)) && (defined(att) || defined(ATT))
	if ((*pty = open ("/dev/ptmx", O_RDWR)) < 0) {
	    return 1;
	}
# if defined(SVR4) || defined(SYSV386)
	strcpy(ttydev, ptsname(*pty));
# endif
	return 0;
#else /* ATT else */
# if defined(AIXV3) || defined(_IBMR2)
	if ((*pty = open ("/dev/ptc", O_RDWR)) < 0) {
	    return 1;
	}
	strcpy(ttydev, (char *)ttyname(*pty));
	return 0;
# endif
# if defined(sgi) && defined(IRIX4)
	{
	    char    *tty_name;

	    tty_name = _getpty (pty, O_RDWR, 0622, 0);
	    if (tty_name == 0)
		return 1;
	    strcpy (ttydev, tty_name);
	    return 0;
	}
# endif
# ifdef __convex__
        {
	    char *pty_name, *getpty();

	    while ((pty_name = getpty()) != NULL) {
		if ((*pty = open (pty_name, O_RDWR)) >= 0) {
		    strcpy(ptydev, pty_name);
		    strcpy(ttydev, pty_name);
		    ttydev[5] = 't';
		    return 0;
		}
	    }
	    return 1;
	}
# endif /* __convex__ */
# if defined(sequent) || defined(_SEQUENT_)
	{
	    char *sl[2], *ms[2];
	    *pty = getpseudotty (sl, ms);
	    strcpy(ptydev, ms[0]);
	    strcpy(ttydev, sl[0]);
	    return (*pty >= 0 ? 0 : 1);
	}
# else
#  if (defined(sgi) && defined(IRIX3)) || (defined(umips) && defined (SYSTYPE_SYSV))
	{
	    struct stat fstat_buf;
	    int tty;

	    *pty = open ("/dev/ptc", O_RDWR);
	    if (*pty < 0 || (fstat (*pty, &fstat_buf)) < 0) {
	      return(1);
	    }
	    sprintf (ttydev, "/dev/ttyq%d", minor(fstat_buf.st_rdev));
#   ifndef sgi
	    sprintf (ptydev, "/dev/ptyq%d", minor(fstat_buf.st_rdev));
	    if ((*tty = open (ttydev, O_RDWR)) < 0) {
	      close (*pty);
	      return(1);
	    }
#   endif /* !sgi */
	    /* got one! */
	    return(0);
	}
#  else /* sgi or umips */

	return pty_search(pty);

#  endif /* sgi or umips else */
# endif /* sequent else */
#endif /* ATT else */
}

/*
 * Called from get_pty to iterate over likely pseudo terminals
 * we might allocate.  Used on those systems that do not have
 * a functional interface for allocating a pty.
 * Returns 0 if found a pty, 1 if fails.
 */
static int pty_search(pty)
    int *pty;
{
    static int devindex, letter = 0;

#ifdef	O_NOCTTY
# define	O_RDWRPTY	(O_RDWR | O_NOCTTY)
#else
# define	O_RDWRPTY	(O_RDWR)
#endif

#ifdef CRAY
    for (; devindex < 256; devindex++) {
	sprintf (ttydev, "/dev/ttyp%03d", devindex);
	sprintf (ptydev, "/dev/pty/%03d", devindex);

	if ((*pty = open (ptydev, O_RDWRPTY)) >= 0) {
	    /* We need to set things up for our next entry
	     * into this function!
	     */
	    (void) devindex++;
# ifdef	TIOCEXCL
	    ioctl (*pty, TIOCEXCL, (char *)0);
# endif
	    return 0;
	}
    }
#else /* CRAY */
    while (PTYCHAR1[letter]) {
	ttydev [strlen(ttydev) - 2] = PTYCHAR1 [letter];
	ptydev [strlen(ptydev) - 2] = PTYCHAR1 [letter];

	while (PTYCHAR2[devindex]) {
	    ttydev [strlen(ttydev) - 1] = PTYCHAR2 [devindex];
	    ptydev [strlen(ptydev) - 1] = PTYCHAR2 [devindex];

	    if ((*pty = open (ptydev, O_RDWRPTY)) >= 0) {
		/* We need to set things up for our next entry
		 * into this function!
		 */
		(void) devindex++;
# ifdef	TIOCEXCL
		ioctl (*pty, TIOCEXCL, (char *)0);
# endif
		return 0;
	    }
	    devindex++;
	}
	devindex = 0;
	letter++;
    }
#endif /* CRAY else */
    /*
     * We were unable to allocate a pty master!  Return an error
     * condition and let our caller terminate cleanly.
     */
    return 1;
}

get_tty(tty, termptr)
     int tty;
     struct term_mode *termptr;
{
#ifdef	TIOCSLTC
	(void) ioctl (tty, TIOCGLTC, (char *)&(termptr->ltc));
#endif
#ifdef	  TIOCLSET
	(void) ioctl (tty, TIOCLGET, (char *)&(termptr->lmode));
#endif
#ifdef	USE_SYSV_TERMIO
	(void) ioctl (tty, TCGETA,   (char *)&(termptr->tio));
#else	/* USE_SYSV_TERMIO */
	(void) ioctl (tty, TIOCGETP, (char *)&(termptr->sb));
	(void) ioctl (tty, TIOCGETC, (char *)&(termptr->tc));
	(void) ioctl (tty, TIOCGETD, (char *)&(termptr->ldis));
#endif	/* USE_SYSV_TERMIO */
}

set_tty(tty, termptr)
     int tty;
     struct term_mode *termptr;
{
#ifdef	TIOCSLTC
	(void) ioctl (tty, TIOCSLTC, (char *)&(termptr->ltc));
#endif
#ifdef	  TIOCLSET
	(void) ioctl (tty, TIOCLSET, (char *)&(termptr->lmode));
#endif
#ifdef	USE_SYSV_TERMIO
# ifdef	POSIX
	(void) tcsetattr (fd, TCSAFLUSH, (char *)&(termptr->tio));
# else
	(void) ioctl (tty, TCSETA,   (char *)&(termptr->tio));
# endif
#else	/* USE_SYSV_TERMIO */
	(void) ioctl (tty, TIOCSETP, (char *)&(termptr->sb));
	(void) ioctl (tty, TIOCSETC, (char *)&(termptr->tc));
	(void) ioctl (tty, TIOCSETD, (char *)&(termptr->ldis));
#endif	/* USE_SYSV_TERMIO */
}

make_raw(oldtermptr, newtermptr)
     struct term_mode *oldtermptr, *newtermptr;
{
	*newtermptr = *oldtermptr;

#ifdef	TIOCSLTC
	newtermptr->ltc.t_suspc = 0377;
	newtermptr->ltc.t_dsuspc = 0377;
	newtermptr->ltc.t_flushc = 0377;
	newtermptr->ltc.t_lnextc = 0377;
#endif
#if  defined(TIOCLSET) && defined(LPASS8)
	newtermptr->lmode |= LPASS8;
#endif

#ifdef	USE_SYSV_TERMIO

	newtermptr->tio.c_iflag &= ~(ICRNL|IXON);
# ifdef	ISTRIP
	newtermptr->tio.c_iflag &= ~ISTRIP;
# endif
# ifdef ONLCR
	newtermptr->tio.c_oflag &= ~ONLCR;
# endif
	newtermptr->tio.c_cflag |= CS8;
	newtermptr->tio.c_cflag &= ~(PARENB);
	newtermptr->tio.c_lflag &= ~(ICANON|ISIG|ECHO);
	newtermptr->tio.c_cc[VMIN] = 1;
	newtermptr->tio.c_cc[VTIME] = 0;
	newtermptr->tio.c_cc[VINTR] = 0377;
	newtermptr->tio.c_cc[VQUIT] = 0377;
	newtermptr->tio.c_cc[VINTR] = 0377;
# ifdef VSTART
	newtermptr->tio.c_cc[VSTART] = 0377;
# endif
# ifdef VSTOP
	newtermptr->tio.c_cc[VSTOP] = 0377;
# endif
# ifdef VDISCARD
	newtermptr->tio.c_cc[VDISCARD] = 0377;
# endif
# ifdef VSUSP
 	newtermptr->tio.c_cc[VSUSP] = 0377;
# endif
# ifdef VDSUSP
	newtermptr->tio.c_cc[VDSUSP] = 0377;
# endif

#else	/* USE_SYSV_TERMIO */

	newtermptr->sb.sg_flags &= ~(CRMOD | ECHO);
	newtermptr->sb.sg_flags |= CBREAK;
	newtermptr->tc.t_quitc = 0377;
	newtermptr->tc.t_intrc = 0377;
	newtermptr->tc.t_startc = 0377;
	newtermptr->tc.t_stopc = 0377;

#endif	/* USE_SYSV_TERMIO */
}

#include <utmp.h>
#ifdef USE_SYSV_UTMP
# ifndef SVR4			/* otherwise declared in utmp.h */
extern struct utmp *getutent();
extern struct utmp *getutid();
extern struct utmp *getutline();
extern void pututline();
extern void setutent();
extern void endutent();
extern void utmpname();
# endif /* !SVR4 */

# ifndef SYSV386
extern struct passwd *getpwuid();
# endif

extern time_t time();

#else   /* not USE_SYSV_UTMP */
# define UTMP_FILENAME	"/etc/utmp"
#endif

/*
 * addutmp() and rmutmp() will run in different processes --
 * one in subsubprocess, and the other in subprocess.  There is no way to
 * pass values or the status to each other by means of global variables.
 */

/* addutmp() -- add a record to the utmp file */
addutmp()
{
  struct utmp utmp;
  struct passwd *pw;
#ifndef	USE_SYSV_UTMP
  int utmpf;
  int tslot;
#endif

	pw = getpwuid(getuid());

#ifdef	USE_SYSV_UTMP
	(void) setutent ();

	/* set up entry to search for */
	utmp.ut_type = DEAD_PROCESS;
	(void) strncpy ((char *)utmp.ut_id, ttydev + strlen(ttydev) - 2,
			sizeof (utmp.ut_id));
	(void) getutid(&utmp);

	/* set up the new entry */
	utmp.ut_type = USER_PROCESS;
	utmp.ut_exit.e_exit = 2;
	(void) strncpy ((char *)utmp.ut_user,
			(pw && pw->pw_name) ? pw->pw_name : "???",
			sizeof(utmp.ut_user));
	(void) strncpy ((char *)utmp.ut_id, ttydev + strlen(ttydev) - 2,
			sizeof(utmp.ut_id));
	utmp.ut_pid = getpid();

#else	/* USE_SYSV_UTMP */

# ifndef apollo
	tslot = ttyslot();
# else
	tslot = 1;
# endif

	utmpf = open (UTMP_FILENAME, O_WRONLY);
	if (utmpf < 0)
		return;
	bzero((char *)&utmp, sizeof(struct utmp));
#endif	/* USE_SYSV_UTMP */

	(void) strncpy (utmp.ut_line, ttydev + strlen("/dev/"),
			sizeof (utmp.ut_line));
	(void) strncpy (utmp.ut_name,
			(pw && pw->pw_name) ? pw->pw_name : "???",
			sizeof(utmp.ut_name));
	utmp.ut_time = time ((time_t *) 0);

#ifdef	USE_SYSV_UTMP
	(void) pututline(&utmp);
	(void) endutent();
#else
	lseek (utmpf, (long)(tslot * sizeof(struct utmp)), 0);
	write (utmpf, (char *)&utmp, sizeof(struct utmp));
	close (utmpf);
#endif
}

rmutmp(child_pid)
     int child_pid;
{
  struct utmp utmp;
#ifdef	USE_SYSV_UTMP
  struct utmp *utptr;
#else
  int utmpf;
  int tslot;
#endif

#ifdef	USE_SYSV_UTMP
	(void) setutent();

	utmp.ut_type = USER_PROCESS;
	(void) strncpy ((char *)utmp.ut_id, ttydev + strlen(ttydev) - 2,
			sizeof(utmp.ut_id));
	utptr = getutid(&utmp);

	/* write it out only if it exists, and the pid's match */
	if (utptr && (utptr->ut_pid == child_pid)) {
		utptr->ut_type = DEAD_PROCESS;
		utptr->ut_time = time ((time_t *) 0);
		(void) pututline(utptr);
	}
	(void) endutent();

#else	/* USE_SYSV_UTMP */

	utmpf = open (UTMP_FILENAME, O_RDWR);
	if (utmpf < 0)
		return;
	tslot = 0;
	while (read(utmpf, (char *)&utmp, sizeof (utmp)) == sizeof (utmp)) {
		if (strncmp (utmp.ut_line, ttydev + strlen("/dev/"),
				sizeof (utmp.ut_line)) != 0) {
			tslot ++;
			continue;
		}

		/* find the right slot */
		utmp.ut_name[0] = '\0';
		utmp.ut_time = time ((time_t *) 0);
		lseek (utmpf, (long)(tslot * sizeof(struct utmp)), 0);
		write (utmpf, (char *)&utmp, sizeof(struct utmp));
		close (utmpf);
		break;
	}

#endif	/* USE_SYSV_UTMP */
	return;
}
