/****************************************************************/
/*                                                              */
/*                                                              */
/*                            RDBConv                           */
/*                                                              */
/*          Convert Old to New BrewNIX Recipe Data Base         */
/*                                                              */
/*                                                              */
/****************************************************************/

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*          Copyright (C) 1995   Richard J. Procassini          */
/*                                                              */
/*             (See file 'rdbconv.h' for warranty               */
/*               and redistribution information.)               */
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/*  Include Files  */
#include <stdio.h>

#include "rdbconv.h"

/****************************************************************/


void main(void)
/****************************************************************/
/*  Program RDBInit initializes a recipe data base binary       */
/*  for use by BrewNIX.                                         */
/****************************************************************/
{
    int bytes_read;
    int bytes_written;
    int i;
    int j;
    int k;
    int num_recipes;
    FILE *file_pointer;

    /* Open the old-recipe data base binary file. */
    file_pointer = fopen("old_recipes.rdb", "r");
    if (file_pointer == NULL)
    {
	fprintf(stderr, "RDBConv: Open of 'old_recipes.rdb' failed!\n");
	exit(1);
    }
    
    /* Read the number of recipes in the old-recipe data base. */
    bytes_read = 0;
    bytes_read = fread(&num_recipes, sizeof(char), sizeof(int),
		       file_pointer);
    if (bytes_read != sizeof(int))
    {
	fprintf(stderr, "RDBConv: Error reading the variable\n");
	fprintf(stderr, "\t num_recipes from old_recipes.rdb!\n");
	exit(1);
    }
    
    /* Allocate space for the old-recipe and new_recipe data bases. */
    old_recipe_data_base = (old_beer *)malloc(num_recipes*sizeof(old_beer));
    new_recipe_data_base = (new_beer *)malloc(num_recipes*sizeof(new_beer));
    
    /* Read the entries in the old-recipe data base. */
    bytes_read = 0;
    bytes_read = fread(old_recipe_data_base, sizeof(char),
		       num_recipes*sizeof(old_beer), file_pointer);
    if (bytes_read != num_recipes*sizeof(old_beer))
    {
	fprintf(stderr, "RDBConv: Error reading num_recipes\n");
	fprintf(stderr, "\t recipes from old_recipes.rdb!\n");
	exit(1);
    }
    
    /* Close the old-recipe data base binary file. */
    fclose(file_pointer);
    
    fprintf(stderr, "\n\t****  Old-Recipe Data Base 'old_recipes.rdb' Read  ****\n");
    
    /* Initialize the existing data items from the old-recipe */
    /* data base to the new-recipe data base. */
    for (i = 0; i < MAX_NAME_SIZE_1; i++)
    {
	new_recipe_data_base[0].name[i] = 0;
    }
    new_recipe_data_base[0].name[0] = '(';
    new_recipe_data_base[0].name[1] = 'N';
    new_recipe_data_base[0].name[2] = 'O';
    new_recipe_data_base[0].name[3] = 'N';
    new_recipe_data_base[0].name[4] = 'E';
    new_recipe_data_base[0].name[5] = ')';
    for (i = 0; i < MAX_NUM_MALTS; i++)
    {
	for (j = 0; j < MAX_NAME_SIZE_2; j++)
	{
	    new_recipe_data_base[0].malts[i].name[j] = 0;
	}
	new_recipe_data_base[0].malts[i].gravity = 0;
	new_recipe_data_base[0].malts[i].color = 0;
	new_recipe_data_base[0].malts[i].converted = 0;
	new_recipe_data_base[0].malt_amounts[i] = 0;
	new_recipe_data_base[0].malt_colors[i] = 0;
	new_recipe_data_base[0].malt_gravities[i] = 0;
	new_recipe_data_base[0].malt_units[i] = 0;
    }
    for (i = 0; i < MAX_NUM_HOPS; i++)
    {
	for (j = 0; j < MAX_NAME_SIZE_2; j++)
	{
	    new_recipe_data_base[0].hops[i].name[j] = 0;
	}
	new_recipe_data_base[0].hops[i].alpha_acid_percentage = 0;
	new_recipe_data_base[0].hop_amounts[i] = 0;
	new_recipe_data_base[0].hop_times[i] = 0;
	new_recipe_data_base[0].hop_IBUs[i] = 0;
	new_recipe_data_base[0].hop_units[i] = 0;
    }
    new_recipe_data_base[0].style = 0;
    new_recipe_data_base[0].total_volume = 0;
    new_recipe_data_base[0].total_volume_units = 0;
    new_recipe_data_base[0].boil_volume = 0;
    new_recipe_data_base[0].boil_volume_units = 0;
    new_recipe_data_base[0].num_malts = 0;
    new_recipe_data_base[0].num_hops = 0;
    new_recipe_data_base[0].extraction_efficiency = 0;
    new_recipe_data_base[0].apparent_attenuation = 0;
    new_recipe_data_base[0].real_attenuation = 0;
    new_recipe_data_base[0].original_gravity = 0;
    new_recipe_data_base[0].final_gravity = 0;
    new_recipe_data_base[0].alcohol_by_volume = 0;
    new_recipe_data_base[0].color = 0;
    new_recipe_data_base[0].IBUs = 0;
    
    /* Initialize the new data item(s) to the new-recipe data base. */
    new_recipe_data_base[0].IBU_method = 0;
    
    for (i = 1; i < num_recipes; i++)
    {
	/* Copy the existing data items from the old-recipe */
	/* data base to the new-recipe data base. */
	for (j = 0; j < MAX_NAME_SIZE_2; j++)
	{
	    new_recipe_data_base[i].name[j] =
		old_recipe_data_base[i].name[j];
	}
	for (j = 0; j < MAX_NUM_MALTS; j++)
	{
	    for (k = 0; k < MAX_NAME_SIZE_2; k++)
	    {
		new_recipe_data_base[i].malts[j].name[k] =
		    old_recipe_data_base[i].malts[j].name[k];
	    }
	    new_recipe_data_base[i].malts[j].gravity =
		old_recipe_data_base[i].malts[j].gravity;
	    new_recipe_data_base[i].malts[j].gravity =
		old_recipe_data_base[i].malts[j].gravity;
	    new_recipe_data_base[i].malts[j].color =
		old_recipe_data_base[i].malts[j].color;
	    new_recipe_data_base[i].malts[j].converted =
		old_recipe_data_base[i].malts[j].converted;
	    new_recipe_data_base[i].malt_amounts[j] =
		old_recipe_data_base[i].malt_amounts[j];
	    new_recipe_data_base[i].malt_colors[j] =
		old_recipe_data_base[i].malt_colors[j];
	    new_recipe_data_base[i].malt_gravities[j] =
		old_recipe_data_base[i].malt_gravities[j];
	    new_recipe_data_base[i].malt_units[j] =
		old_recipe_data_base[i].malt_units[j];
	}
	for (j = 0; j < MAX_NUM_HOPS; j++)
	{
	    for (k = 0; k < MAX_NAME_SIZE_2; k++)
	    {
		new_recipe_data_base[i].hops[j].name[k] =
		    old_recipe_data_base[i].hops[j].name[k];
	    }
	    new_recipe_data_base[i].hops[j].alpha_acid_percentage =
		old_recipe_data_base[i].hops[j].alpha_acid_percentage;
	    new_recipe_data_base[i].hop_amounts[j] =
		old_recipe_data_base[i].hop_amounts[j];
	    new_recipe_data_base[i].hop_times[j] =
		old_recipe_data_base[i].hop_times[j];
	    new_recipe_data_base[i].hop_IBUs[j] =
		old_recipe_data_base[i].hop_IBUs[j];
	    new_recipe_data_base[i].hop_units[j] =
		old_recipe_data_base[i].hop_units[j];
	}
	new_recipe_data_base[i].style =
	    old_recipe_data_base[i].style;
	new_recipe_data_base[i].total_volume =
	    old_recipe_data_base[i].total_volume;
	new_recipe_data_base[i].total_volume_units =
	    old_recipe_data_base[i].total_volume_units;
	new_recipe_data_base[i].boil_volume =
	    old_recipe_data_base[i].boil_volume;
	new_recipe_data_base[i].boil_volume_units =
	    old_recipe_data_base[i].boil_volume_units;
	new_recipe_data_base[i].num_malts =
	    old_recipe_data_base[i].num_malts;
	new_recipe_data_base[i].num_hops =
	    old_recipe_data_base[i].num_hops;
	new_recipe_data_base[i].extraction_efficiency =
	    old_recipe_data_base[i].extraction_efficiency;
	new_recipe_data_base[i].apparent_attenuation =
	    old_recipe_data_base[i].apparent_attenuation;
	new_recipe_data_base[i].real_attenuation =
	    old_recipe_data_base[i].real_attenuation;
	new_recipe_data_base[i].original_gravity =
	    old_recipe_data_base[i].original_gravity;
	new_recipe_data_base[i].final_gravity =
	    old_recipe_data_base[i].final_gravity;
	new_recipe_data_base[i].alcohol_by_volume =
	    old_recipe_data_base[i].alcohol_by_volume;
	new_recipe_data_base[i].color =
	    old_recipe_data_base[i].color;
	new_recipe_data_base[i].IBUs =
	    old_recipe_data_base[i].IBUs;
	
	/* Add the new data item(s) to the new-recipe data base. */
	new_recipe_data_base[i].IBU_method = 0;
    }
    
    /* Open the new-recipe data base binary file. */
    file_pointer = fopen("new_recipes.rdb", "w");
    if (file_pointer == NULL)
    {
	fprintf(stderr, "RDBConv: Open of 'new_recipes.rdb' failed!\n");
	exit(1);
    }
    
    /* Write the number of recipes to the new-recipe data base binary file. */
    bytes_written = 0;
    bytes_written = fwrite(&num_recipes, sizeof(char), sizeof(int),
			   file_pointer);
    if (bytes_written != sizeof(int))
    {
	fprintf(stderr, "RDBConv: Error writing the variable\n");
	fprintf(stderr, "\t num_recipes to 'new_recipes.rdb'!\n");
	exit(1);
    }
    
    /* Write the existing entries to the new-recipe data base binary file. */
    bytes_written = 0;
    bytes_written = fwrite(new_recipe_data_base, sizeof(char),
			   num_recipes*sizeof(new_beer), file_pointer);
    if (bytes_written != num_recipes*sizeof(new_beer))
    {
	fprintf(stderr, "RDBConv: Error writing %d\n", num_recipes);
	fprintf(stderr, "\t recipe(s) to 'new_recipes.rdb'!\n");
	exit(1);
    }
    
    /* Close the new-recipe data base binary file. */
    fclose(file_pointer);
    
    fprintf(stderr, "\n\t****  New-Recipe Data Base 'new_recipes.rdb' Written  ****\n\n");
    
}  /* End main */
