/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*          Copyright (C) 1995   Richard J. Procassini          */
/*                                                              */
/*             (See file 'brewcalc.h' for warranty              */
/*               and redistribution information.)               */
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#include <ctype.h>
#include "brewcalc.h"

void get_string(char *string, int size, int nullOK)
/*
   AUTHOR
   George W. Sherouse
   11 April 1984
   
   Revised and updated by N.S. "Teddy" Winstead
   3 June 1994

*/
{
    int c;
    int loop;
    int count,
    where_x,
    where_y,
    x,
    y;
    char Format[30];

    nonl();

    standout();
    getyx(stdscr, where_y, where_x);

    for (loop = 0; loop < size; loop++)
    {
	printw(" ");
	string[loop] = (char) 0;
    }
    string[size] = (char) 0;
    move(where_y, where_x);
    refresh();

    count = 0;
    while (1)
    {
	switch (c = (getch() & 0177))
	{
#ifdef ABORT_CHAR
	case ABORT_CHAR:
	    clear();
	    standend();
	    mvprintw(0, 0, "Program aborted at your request...");
	    move(LINES - 1, 0);
	    refresh();
	    nl();
	    endwin();
	    exit(0);
	    break;
#endif ABORT_CHAR

	case '\015':
	    if (count || nullOK)
	    {
		standend();
		sprintf(Format, "%%-%ds", size);
		mvprintw(where_y, where_x, Format, string);
		refresh();
		return;
	    }
	    else
	    {
		fprintf(stderr, "%c", '\007');
		break;
	    }
	case '\030':
	    while (count)
	    {
		string[--count] = (char) 0;
		getyx(stdscr, y, x);
		mvprintw(y, x-1, " ");
		move(y, x - 1);
	    }
	    break;
	case '\021':
	case '\023':
	    break;
	default:
	    if (count && c == erase_char)
	    {
		getyx(stdscr, y, x);
		mvprintw(y, x-1, " ");
		move(y, x - 1);
		string[--count] = (char) 0;
		break;
	    }

	    if (isprint(c) && count < size)
	    {
		printw("%c", c);
		string[count++] = c;
		break;
	    }

	    fprintf(stderr, "%c", '\007');
	}
    refresh();
    }
    nl();

}
