/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*          Copyright (C) 1995   Richard J. Procassini          */
/*                                                              */
/*             (See file 'brewcalc.h' for warranty              */
/*               and redistribution information.)               */
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#include <stdio.h>
#ifdef LINUX
#include </usr/include/bsd/sgtty.h>
#endif
#ifdef SUNOS
#include </usr/include/sgtty.h>
#endif
#include <sys/ioctl.h>
#include "brewcalc.h"

char get_erase()
/*
   AUTHOR
   George W. Sherouse
   3 January 1985

   Revised and updated by N.S. "Teddy" Winstead
   3 June 1994

*/
{
	struct sgttyb params;
	int ret;

	ret = ioctl(0, TIOCGETP, &params);
	if (ret == -1)
	{
	    fprintf(stderr, "ioctl fail\n");
	    perror("get_erase");
	    exit(1);
	}

	return(params.sg_erase);
}
