/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*          Copyright (C) 1995   Richard J. Procassini          */
/*                                                              */
/*     This program is free software.  You can redistribute     */
/*     it and/or modify it under the terms of Version 2 of      */
/*     the GNU General Public License as published by the       */
/*     Free Software Foundation.                                */
/*                                                              */
/*     This program is distributed in the hope that it will     */
/*     be useful, but WITHOUT ANY WARRANTY, and without even    */
/*     the implied warranty of MERCHANTABILITY or FITNESS       */
/*     FOR A PARTICULAR PURPOSE.  See the GNU General Public    */
/*     License for more details.                                */
/*                                                              */
/*     You should have received a copy of the GNU General       */
/*     Public License along with this program.  If you have     */
/*     not received a copy of the GNU General Public License,   */
/*     then write to:                                           */
/*                                                              */
/*              The Free Software Foundation, Inc.              */
/*              675 Massachusetts Avenue                        */
/*              Cambridge, MA  02139                            */
/*              United States of America                        */
/*                                                              */
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*                                                              */
/*           (See file 'COPYING' for the text of the            */
/*                 GNU General Public License.)                 */
/*                                                              */
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#include <stdio.h>


#define NAMESIZE 25
#define MAX_NUM_MALTS 8
#define MAX_NUM_HOPS 6


/* Typedefs used for the data base files. */

struct malt_struct
{
  char name[NAMESIZE];
  float gravity;
  float color;
  int converted;
};

typedef struct malt_struct malt;

struct hop_struct
{
  char name[NAMESIZE];
  float alpha_acid_percentage;
};

typedef struct hop_struct hop;

struct beer_struct
{
  char name[NAMESIZE];
  int style;
  float total_volume;
  int total_volume_units;
  float boil_volume;
  int boil_volume_units;
  malt malts[MAX_NUM_MALTS];
  int num_malts;
  float malt_amounts[MAX_NUM_MALTS];
  float malt_colors[MAX_NUM_MALTS];
  float malt_gravities[MAX_NUM_MALTS];
  int malt_units[MAX_NUM_MALTS];
  hop hops[MAX_NUM_HOPS];
  int num_hops;
  float hop_amounts[MAX_NUM_HOPS];
  int hop_times[MAX_NUM_HOPS];
  float hop_IBUs[MAX_NUM_HOPS];
  int hop_units[MAX_NUM_HOPS];
  float extraction_efficiency;
  float apparent_attenuation;
  float real_attenuation;
  float original_gravity;
  float final_gravity;
  float alcohol_by_volume;
  float color;
  float IBUs;
};

typedef struct beer_struct beer;


/* Global symbols. */

beer recipe_data_base;
