%***************************************************************************
%  FILE = utility1.red 				Mon Dec 12 15:43:52 EST 1988
% 
%  Procedures in this file:
%  
%  APPENDN ARBINDEX CANONINDEX CHECKTYPE CLEANER CLEARTMP CNSTN 
%  DERIV FDERIV FREE1 GETINDICES GETNME HEAD IND INDH INSERT 
%  INTINDEX LOOK MAKENAME MAP43 MASCII MERROR ORDERINDEX
%  REPLACINDEX RESIMPSCALAR SIGN SETLIS SUBLIST TMPNAMES ZPN
% 
%  REDTEN source code
%  Copyright (c) 1986, 1987 University of Toronto.
%  All Rights Reserved.
%
%  Written by John Harper and Charles Dyer
%
%  Permission to use this software without fee is granted subject to 
%  the following restrictions:
% 
%  1. This software may not be used or distributed for direct commercial
%     gain.
% 
%  2. The author is not responsible for the consequences of use of this
%     software, no matter how awful, even if they arise from flaws in it.
% 
%  3. The origin of this software must not be misrepresented, either by
%     explicit claim or by omission.
% 
%  4. This code may be altered to suit your need, but such alterations
%     must be plainly marked and the code must not be misrepresented
%     as the original software.
% 
%  5. This notice may not be removed or altered.
% 
%**********************************************************************
REMPROP ('INDEX, 'STAT);

% alphalist* contains all the indices ever used by the system for its
% work. the user should NEVER fiddle with these guys. 

GLOBAL '(ALPHALIST!* INAMES INDICEMAT INDICESP INDICETEN);

ALPHALIST!* := '(a!# b!# c!# d!# e!# f!# g!# h!# i!# j!# k!# l!# m!# n!# 
                 o!# p!# q!# r!# s!# t!# u!# v!# w!# x!# y!# z!# !#1); 

% appendn quickly appends an arbitrary number of lists in the single super-list
% argument. 

SYMBOLIC PROCEDURE APPENDN (U);
BEGIN SCALAR LEX;
  LEX := APPEND (CAR (U), 'NIL);
  U := CDR (U);
  WHILE U DO <<
    LEX := NCONC (LEX, APPEND (CAR (U), 'NIL));
    U := CDR (U)
  >>;
  RETURN (LEX);
END;

% arbindex determines whether the given index is 'arbitrary' i.e. not
% all the indices reduce to integers.

SYMBOLIC PROCEDURE ARBINDEX (INDEX);
BEGIN;
  INDEX := INDH (INDEX);	% clear out shift ops.
  LOOP:
    IF NOT IDP (MYCAR (INDEX)) AND NOT MYCAR (FDERIV (INDEX)) = 1 THEN
        RETURN ('NIL);
    INDEX := MYCDR (INDEX);
    IF NOT INDEX THEN RETURN ('T);
  GO TO LOOP;
END;

% CANONINDEX produces a canonical form for an index by replacing each
% arbitrary index with a choice from the ALPHALIST!*. The result
% should be the same for any choice of arbitrary indices. Integer
% indices and derivative ops are passed through. This function does
% not know about shifted indices. 

SYMBOLIC PROCEDURE CANONINDEX (INDEX);
BEGIN SCALAR LIS, LIS1, LEX, LEX1; INTEGER I;
    I := 0;
    WHILE INDEX DO <<
        IF FIXP (LEX := MYCAR (INDEX)) OR (LEX EQ '!#BR)
            OR (LEX EQ '!#DBR) THEN LIS := LEX . LIS
	ELSE IF (LEX1 := ASSOC (LEX, LIS1)) THEN
           LIS := CDR (LEX1) . LIS
	ELSE <<
           LEX1 := NTH (ALPHALIST!*, I := I + 1);
           LIS1 := (LEX . LEX1) . LIS1;
           LIS := LEX1 . LIS
        >>;
	INDEX := MYCDR (INDEX)
    >>;
    RETURN (REVERSE (LIS) . LIS1);
END;

% checktype checks whether a given expression has a car equal to type,
% avoiding a problem with taking the car of an atom.

SYMBOLIC PROCEDURE CHECKTYPE (EX, TYPE);
  IF ATOM (EX) THEN 'NIL
  ELSE MYCAR (EX) EQ TYPE;

GLOBAL '(PROGRAM!*);  	% parser variable contains input line.

% cleaner prints the finished banner from many functions if they were not
% called at the top level, and calls cleartmp if they were.

SYMBOLIC PROCEDURE CLEANER (NAME);
BEGIN SCALAR LEX;
  LEX := MYCADR (MYCADADR (PROGRAM!*));
  IF LEX NEQ NAME AND GET (LEX, 'OTHERNAME) NEQ NAME THEN << % not top level call.
    WRITE (NAME, " finished.");
    TERPRI();
    RETURN;
  >>;
  CLEARTMP ();		% clear trash
END;

FLAG ('(CLEARTMP), 'OPFN);

GLOBAL '(TMPNAMES!* DPCT!*);

% cleartmp removes temporary objects created and clears the Derivative Partial
% Computation Table.

SYMBOLIC PROCEDURE CLEARTMP ();
BEGIN SCALAR LIS, LEX;
  TMPNAMES!* := 0;
  DPCT!* := 'NIL;
  SETLIS (ALPHALIST!*, ALPHALIST!*);
  LEX := INAMES;
  WHILE LEX DO << 	% look for temps among indexed objects.
    IF HEAD (EXPLODE (MYCAR (LEX)), 4) = '(!# T M P) THEN
      LIS := MYCAR (LEX) . LIS;
    LEX := MYCDR (LEX)
  >>;
  MAPCAR (LIS, 'KILL);
  RETURN ('T);
END;

% cnstn generates a list of n repetitions of indice.

SYMBOLIC PROCEDURE CNSTN (INDICE, N);
BEGIN SCALAR INDEX;
  WHILE NOT N = 0 DO <<
    INDEX := INDICE . INDEX;
    N := N - 1
  >>;
  RETURN (INDEX);
END;

% deriv looks into the given index and returns either the location of
% the indicated derivative operator (in ex) or, if ex is 'nil, whether
% a derivative operator exists in the index.

SYMBOLIC PROCEDURE DERIV (INDEX, EX);
  IF EX THEN LOOK (INDEX, EX, 1)
  ELSE LOOK (INDEX, '!#BR, 1) OR LOOK (INDEX, '!#DBR, 1);

% fderiv looks into an index and returns the location and type of the
% first derivative operator.

SYMBOLIC PROCEDURE FDERIV (INDEX);
BEGIN SCALAR LEX, LEX1;
  LEX := DERIV (INDEX, '!#BR);
  LEX1 := DERIV (INDEX, '!#DBR);
  IF (NOT LEX AND NOT LEX1) THEN RETURN ('NIL)
  ELSE IF (NOT LEX OR LEX1 AND LEX1 < LEX) THEN
    RETURN (LIST (LEX1, '!#DBR))
  ELSE RETURN (LIST (LEX, '!#BR));
END;

% free1 checks an expression to see if does not contain another expression.

SYMBOLIC PROCEDURE FREE1 (EX1, EX2);
BEGIN;
  IF EX1 = EX2 THEN RETURN ('NIL);
    LOOP:
      IF ATOM (EX1) THEN RETURN ('T)
      ELSE IF NOT FREE1 (MYCAR (EX1), EX2) THEN RETURN ('NIL);
      EX1 := MYCDR (EX1);
    GO TO LOOP;
END;

% getindices returns the index run for the given concov element.

SYMBOLIC PROCEDURE GETINDICES (N);
  IF NOT FIXP (N) OR (N := ABS (N)) > 5 THEN
    MERROR (LIST ("bad concov element:", N), 'TRUE, 'GETINDICES)
  ELSE IF N = 1 OR N = 2 THEN INDICETEN	% these are globally defined
  ELSE IF N = 3 OR N = 4 THEN INDICESP	% in sys.env
  ELSE IF N = 5 THEN INDICEMAT;

% getnme detemines what the object name is from the given input 
% which may be just the name, an indexed form, or a shift request.

SYMBOLIC PROCEDURE GETNME (EX, FROM);
BEGIN SCALAR LEX;
  IF NOT (ATOM (EX)) AND (MYCAR (EX) EQ 'MINUS) THEN EX := MYCADR (EX);
  IF NOT EX THEN MERROR ('("input name required"), 'T, FROM)
  ELSE IF ATOM (EX) AND NOT FIXP (EX) THEN RETURN (EX)
  ELSE IF MYCAR (EX) EQ 'RDR THEN <<  % is an indexed object.
    IF NOT FREE1 (MYCADDR (EX), '!*AT!*) THEN RETURN (MYCADR (SHIFT!* (EX, 'NIL)))
    ELSE RETURN (MYCADR (EX))
  >>
  ELSE MERROR (LIST ("bad input:", EX), 'T, FROM);
END;

% head returns the first n elements of the list lis, or all of lis if it
% has fewer than n elements.

SYMBOLIC PROCEDURE HEAD (LIS, N);
BEGIN SCALAR LEX;
  WHILE LIS AND NOT (N = 0) DO <<
    LEX := MYCAR (LIS) . LEX;
    LIS := MYCDR (LIS);
    N := N - 1
  >>;
  RETURN (REVERSE (LEX));
END;

% ind returns the actual indice, regardless of whether it was buried
% in a list (by tracesym). i.e.  a -->a, (a) --> a.

SYMBOLIC PROCEDURE IND (EX);
  IF ATOM (EX) THEN EX
  ELSE MYCAR (EX);

% indh is similar to, but smarter than ind. it returns the actual indice
% from a shifted form, and can map itself over an index.
% so: (a (*at* b) (c)) --> (a b (c))
% it doesn't handle the case ind does.

SYMBOLIC PROCEDURE INDH (EX);
BEGIN SCALAR LEX;
  IF ATOM (EX) OR NOT EX THEN RETURN (EX)
  ELSE IF MYCAR (EX) EQ '!*AT!* THEN RETURN (MYCADR (EX));
  LEX := FOR EACH X IN EX COLLECT INDH (X);
  RETURN (LEX);
END;

% insert inserts an element into a list  at position n, either overwritting
% the element already there (cutout = 't) or going just after that element.
% if cutout is 't and inp is 'nil, the n'th element is removed.

SYMBOLIC PROCEDURE INSERT (LIS, INP, N, CUTOUT);
BEGIN SCALAR LEX;
  IF N > LENGTH (LIS) THEN <<  % just append the element
    IF INP AND NOT CUTOUT THEN RETURN (APPEND (LIS, LIST (INP)))
    ELSE RETURN (LIS)
  >>;
  WHILE LIS AND NOT N = 1 DO <<  % stack up the first n - 1 elements.
    LEX := MYCAR (LIS) . LEX;
    LIS := MYCDR (LIS);
    N := N - 1
  >>;
  IF CUTOUT THEN <<    		% remove the n'th and discard.
    LIS := MYCDR (LIS);
    IF INP THEN LIS := INP . LIS   % if inp is not 'nil, put it in.
    >>
  ELSE LIS := INP . LIS;	% just add the new element.
  RETURN (APPEND (REVERSE (LEX), LIS));  % put the list back together.
END;

% intindex determines whether the given index is and integer index, i.e.
% whether all indices reduce to integers.

SYMBOLIC PROCEDURE INTINDEX (INDEX);
BEGIN;
  INDEX := INDH (INDEX);	% clear out shift ops.
  LOOP:
    IF NOT FIXP (MYCAR (INDEX)) AND NOT MYCAR (FDERIV (INDEX)) = 1 THEN
        RETURN ('NIL);	 % not an int and not a deriv op.
    INDEX := MYCDR (INDEX);
    IF NOT INDEX THEN RETURN ('T);
  GO TO LOOP;
END;

% look looks into a list for the element el, and returns its location
% (where the first element is at location n).  if the element is not there,
% look returns 'nil.

SYMBOLIC PROCEDURE LOOK (LIS, EL, N);
BEGIN SCALAR I;
  I := LENGTH (MEMBER (EL, LIS));
  IF I = 0 THEN RETURN ('NIL)
  ELSE RETURN (LENGTH (LIS) - I + N);
END;

% makename compresses a list into a name and interns it.

SYMBOLIC PROCEDURE MAKENAME (U);
  INTERN (COMPRESS (U));

% map43 converts primed spinor indices to unprimed indices, to make it easier
% to compare concov lists etc.

SYMBOLIC PROCEDURE MAP43 (U);
  IF ATOM (U) THEN 'NIL
  ELSE IF MYCAR (U) = 4 THEN 3 . MAP43 (MYCDR (U))
  ELSE IF MYCAR (U) = -4 THEN (-3) . MAP43 (MYCDR (U))
  ELSE MYCAR (U) . MAP43 (MYCDR (U));

% mascii will convert numbers to ascii chars, or chars to their
% equivalents. in franz there are routines that can be combined into
% another routine for this.

%SYMBOLIC PROCEDURE MASCII (X);   % for Franz
%  IF FIXP (X) THEN ASCII (X)
%  ELSE GETCHARN (X, 1);

SYMBOLIC PROCEDURE MASCII (EX);   % for PSL
  IF FIXP (EX) THEN INT2ID (EX)
  ELSE ID2INT (EX);

%SYMBOLIC PROCEDURE MASCII (EX);
%BEGIN SCALAR LEX;
%  IF FIXP (EX) THEN <<
%    LEX := ATSOC (EX,
%                     '((32 . ! ) (33 . !!) (34 . !") (35 . !#) (36 . )
%               (37 . !%) (38 . !&) (39 . !\') (40 . !() (41 . !)) (42 . !*)
%               (43 . +) (44 . ,) (45 . -) (46 . .) (47 . /) (48 . 0)
%'((35 . !#)(63 . !?) (48 . 0) (49 . 1) (50 . 2) (51 . 3) (52 . 4) (53 . 5) (54 . 6)
%               (55 . 7) (56 . 8) (57 . 9) (58 . :) (59 . ;) (60 . <)
%               (61 . =) (62 . >) (63 . ?) (64 . @) (65 . A) (66 . B)
%               (67 . C) (68 . D) (69 . E) (70 . F) (71 . G) (72 . H)
%               (73 . I) (74 . J) (75 . K) (76 . L) (77 . M)
%               (78 . N) (79 . O) (80 . P) (81 . Q) (82 . R) (83 . S)
%               (84 . T) (85 . U) (86 . V) (87 . W) (88 . X) (89 . Y)
%               (90 . Z) (91 . [) (92 . \) (93 . ]) (94 . ^) (95 . _)
%               (96 . `) (97 . a) (98 . b) (99 . c) (100 . d) (101 . e)
%        (102 . f) (103 . g) (104 . h) (105 . i) (106 . j) (107 . k)
%        (108 . l) (109 . m) (110 . n) (111 . o) (112 . p) (113 . q)
%        (114 . r) (115 . s) (116 . t) (117 . u) (118 . v) (119 . w)
%        (120 . x) (121 . y) (122 . z) (123 . {) (124 . |) (125 . })
%        (126 . ~)) );
%    IF NOT LEX THEN RETURN ('NIL)
%    ELSE RETURN (MYCDR (LEX))
%    >> ELSE <<
%    LEX := ATSOC (EX,
%             '((  . 32) ( . 33) (" . 34) (# . 35) ( . 36)
%               (% . 37) (& . 38) (' . 39) (( . 40) () . 41) (* . 42)
%               (+ . 43) (, . 44) (- . 45) (. . 46) (/ . 47) (0 . 48)
%'((!# . 35)(!? . 63)   (0 . 48) (1 . 49) (2 . 50) (3 . 51) (4 . 52) (5 . 53) (6 . 54)
%               (7 . 55) (8 . 56) (9 . 57) (: . 58) (; . 59) (< . 60)
%               (= . 61) (> . 62) (? . 63) (@ . 64) (A . 65) (B . 66)
%               (C . 67) (D . 68) (E . 69) (F . 70) (G . 71) (H . 72)
%               (I . 73) (J . 74) (K . 75) (L . 76) (M . 77)
%               (N . 78) (O . 79) (P . 80) (Q . 81) (R . 82) (S . 83)
%               (T . 84) (U . 85) (V . 86) (W . 87) (X . 88) (Y . 89)
%               (Z . 90) ([ . 91) (\ . 92) (] . 93) (^ . 94) (_ . 95)
%               (` . 96) (a . 97) (b . 98) (c . 99) (d . 100) (e . 101)
%        (f . 102) (g . 103) (h . 104) (i . 105) (j . 106) (k . 107)
%        (l . 108) (m . 109) (n . 110) (o . 111) (p . 112) (q . 113)
%        (r . 114) (s . 115) (t . 116) (u . 117) (v . 118) (w . 119)
%        (x . 120) (y . 121) (z . 122) ({ . 123) (| . 124) (} . 125)
%        (~ . 126)) );
%    IF NOT LEX THEN RETURN ('NIL)
%    ELSE RETURN (MYCDR (LEX))
%    >>;
%END;

% merror is the system error routine. given a message in list form, it
% prints each element, and if stat is 't then it calls a real error routine.
% if from is non-'nil, the name of the routine calling merror (i.e from)
% is also printed.

SYMBOLIC PROCEDURE MERROR (MES, STAT, FROM);
BEGIN;
  TERPRI ();
  IF STAT THEN WRITE ("ERROR: ")	% fatal error, will call error1 below.
  ELSE WRITE ("WARNING: ");		% warning, will return to caller.
  WHILE MES DO <<		% dump the message.
    WRITE (MYCAR (MES));
    WRITE (" ");
    MES := MYCDR (MES)
  >>;

  IF FROM THEN <<		% name of calling routine.
    WRITE (" ");
    WRITE ("(");
    WRITE ("from ");
    WRITE (FROM);
    WRITE (")")
    >>;
  TERPRI ();
  IF STAT THEN <<		% fatal, clean up and go away.
    MCLEAR ();
    ERROR1 ()
  >>;
END;


% orderindex compares the index lis1 to the index lis2 and reports on whether
% lis1 is <,= or > than lis2. it runs down the indices and compares elements.

SYMBOLIC PROCEDURE ORDERINDEX (LIS1, LIS2);
BEGIN;
  IF LIS1 = LIS2 OR NOT LIS2 THEN RETURN ('E);
  LOOP:
    IF NOT LIS2 THEN RETURN ('NIL)
    ELSE IF NOT LIS1 THEN RETURN ('T)
    ELSE IF MYCAR (LIS1) > MYCAR (LIS2) THEN RETURN ('NIL)
    ELSE IF MYCAR (LIS1) < MYCAR (LIS2) THEN RETURN ('T)
    ELSE <<
      LIS1 := MYCDR (LIS1);
      LIS2 := MYCDR (LIS2)
    >>;
   GO TO LOOP;
END;

% replacindex looks through an expression and replaces object indices 
% with the values indicated in the association list replac.

SYMBOLIC PROCEDURE REPLACINDEX (VALUE, REPLAC);
  IF NOT REPLAC OR FREE1 (VALUE, 'RDR) THEN VALUE
  ELSE IF CHECKTYPE (VALUE, 'RDR) THEN	 % replace indices
    LIST ('RDR, MYCADR (VALUE), SUBLIS (REPLAC, MYCADDR (VALUE)))
  ELSE FOR EACH X IN VALUE COLLECT REPLACINDEX (X, REPLAC);

% resimpscalar is called by routines which store scalar
% quantities on the property list of an indexed object
% (eg det, riccisc). the name of the object and the key
% under which the value is stored form the second and
% third arguments. if the first argument is 'nil, the
% value is read-out, if it is 't, simp!* is applied to
% the value, otherwise, it replaces the value.

SYMBOLIC PROCEDURE RESIMPSCALAR (U, TNSR, KEY);
  IF NOT U THEN GET (TNSR, KEY)
%  ELSE IF U EQ 'T THEN      % this is a pain, and does not work well 12/12/88
%    PUT (TNSR, KEY, SIMP!* (LIST ('!*SQ, GET (TNSR, KEY))))
  ELSE
    PUT (TNSR, KEY, SIMP!* (U));

% there probably exits a routine like this in reduce but i can't find it.

SYMBOLIC PROCEDURE SIGN (NUM);   % note: want sign(0) = 1
  IF NUM < 0 THEN -1
  ELSE 1;

% setlis assigns the elements of the first list with the corresponding
% elements of the second list.

SYMBOLIC PROCEDURE SETLIS (LIS1, LIS2);
BEGIN;
  WHILE LIS1 AND LIS2 DO <<
    SET (MYCAR (LIS1), MYCAR (LIS2));
    LIS1 := MYCDR (LIS1);
    LIS2 := MYCDR (LIS2)
  >>;
END;

% sublist returns a segments of a list beginning at position n, and running
% for len elements. the first element of the list corresponds to n = 1.

SYMBOLIC PROCEDURE SUBLIST (LIS, N, LEN);
  IF N < 0 OR LEN < 1 OR N > LENGTH (LIS) THEN 'NIL
  ELSE HEAD (PNTH (LIS, N), LEN);

SYMBOLIC SETQ (TMPNAMES!*, 0); 	% global integer used to generate temp names.

% tmpnames generates a sequence of temporary names of the form *tmp<n>.
% the counter is reset when cleartmp is called.

SYMBOLIC PROCEDURE TMPNAMES ();
  MAKENAME (APPEND ('(!# T M P),
        EXPLODE (TMPNAMES!* := TMPNAMES!* + 1)));

% zpn returns a list of numbers from i to j by k.

SYMBOLIC PROCEDURE ZPN (I, J, K);
BEGIN SCALAR LIS;
  WHILE NOT J < I DO <<
    LIS := J . LIS;
    J := J - K
  >>;
  RETURN (LIS);
END;

;END;

