%******************************************************************************
%  FILE = symindex.red 				Sun May 17 20:07:37 EDT 1987
% 
%  Procedures in this file:
%  
%  SYMINDEX PARSELCUB SYMGEN SYMGEN1 SYMMAP SYMROL SYMSHFT
% 
%  REDTEN source code
%  Copyright (c) 1986, 1987 University of Toronto.
%  All Rights Reserved.
%
%  Written by John Harper and Charles Dyer
%
%  Permission to use this software without fee is granted subject to 
%  the following restrictions:
% 
%  1. This software may not be used or distributed for direct commercial
%     gain.
% 
%  2. The author is not responsible for the consequences of use of this
%     software, no matter how awful, even if they arise from flaws in it.
% 
%  3. The origin of this software must not be misrepresented, either by
%     explicit claim or by omission.
% 
%  4. This code may be altered to suit your need, but such alterations
%     must be plainly marked and the code must not be misrepresented
%     as the original software.
% 
%  5. This notice may not be removed or altered.
% 
%**********************************************************************
REMPROP ('INDEX, 'STAT);

% symindex is the routine which expands symmetrization operations.

SYMBOLIC PROCEDURE SYMINDEX (INP);
BEGIN SCALAR LEX, LEX1, SIGN, L, LIS, INDEX1, TNSR, INDEX;
  IF ATOM (INP) OR FREE1 (INP, 'RDR) OR (CHECKTYPE (INP, 'RDR) AND 
     (NOT MYCADDR (INP) OR NOT MYCADDDR (INP))) THEN RETURN (INP)  % no op
  ELSE IF NOT CHECKTYPE (INP, 'RDR) THEN 
     RETURN (MAPCAR (INP, 'SYMINDEX));
  LEX := MYCADDDR (INP);		% get the symmetrization list
  IF NOT SYMSHFT (MYCADDR (INP), MYCDAR (LEX))  % see what can be done without
    THEN RETURN (INP);	% messing shift operations (these must be done 1st).
  TNSR := MYCADR (INP);	% object name
  INDEX := MYCADDR (INP); % object index
  LEX1 := MYCAR (LEX);    % first symmetrization list
  LEX := MYCDR (LEX);     % remaining ones are handled recursively.
  SIGN := MYCAR (LEX1);	% sign of the operation
  LEX1 := MYCDR (LEX1);   % indices involved in the symmetrization
  INDEX := SYMGEN (LEX1, INDEX);  % a list of permuted indices
  LIS := '(0);		% this really isn't needed in reduce.
  L := SIGN;		% permuted indices are in alternating order (i.e 1
			% pair flip moves an index into the next one)
  WHILE INDEX DO <<	% build a list of objects with these indices.
    IF LEX THEN LIS := LIST ('TIMES, L,  % add remaing sym list to new objects
           SYMI (LIST ('RDR, TNSR, MYCAR (INDEX), LEX))) . LIS
    ELSE LIS := LIST ('TIMES, L,
           SYMI (LIST ('RDR, TNSR, MYCAR (INDEX)))) . LIS;
    INDEX := MYCDR (INDEX);
    L := L * SIGN	% alternating sign
  >>;
  L := REVAL (LIST ('QUOTIENT, 'PLUS .  LIS, FACTORIAL (LENGTH (LEX1))));
  IF L = 0 THEN RETURN ('NIL) 	% if sum goes to 0, return 0.
  ELSE IF LEX THEN RETURN (REVAL (SYMINDEX (L)))	 % recursive
  ELSE RETURN (L);
END;

PUT('!{, 'STAT, 'PARSELCUB);	% define parsing property

FLAG('(!}),'DELIM);	% } delimits a {} group.
FLAG('(!}),'NODEL); 	% still dont know what this means.
GLOBAL '(CURSYM!* SYMLST!*);

% parselcub is analogous to parselsqb except that it does not need
% to be able to tell if it has been recursively called. it collects
% up the stuff between {} symmetrization brackets, pushes a real
% clean list onto symlst!*, and a not so clean (it still has the
% shift ops in it) list is returned to parselsqb.

SYMBOLIC PROCEDURE PARSELCUB;
BEGIN SCALAR LEX, LST, LOCALFLAG;
  LOOP:
    LEX := XREAD ('GROUP);
    IF ATOM (LEX) THEN LST := ACONC (LST, LEX)
    ELSE LST := APPEND (LST, LEX);
    IF NOT (CURSYM!* EQ '!}) THEN GO TO LOOP;

  SCAN ();
  LEX := CLEANSYM (LST);  % clean up the input.
     % recall the parser wants names at the head of a list so we use
     % *mone to represent -1.
  SYMLST!* := ('!*MONE . MYCAR (LEX)) . SYMLST!*;
  RETURN (MYCADR (LEX));
END;

FLUID '(INDEX INDX1);
GLOBAL '(SYMGEN!*);

% symgen is the routine which generates a list of permuted indices from
% the list of symmetrizable indices and the object index. the indices are
% generated in order, each is a pair exchange derived from the previous one.

SYMBOLIC PROCEDURE SYMGEN (LIS, INDEX);
BEGIN SCALAR LEX, LEX1, I, INDEX1, INDX1;
  INDEX1 := SYMMAP (LIS, INDEX);	% map the index to the sym list.
  LEX1 := SYMGEN1 (MYCAR (INDEX1));	% pointers to sequential exchange pairs
  INDEX1 := MYCADR (INDEX1);		
  LEX := LIST (INDEX);
  WHILE LEX1 DO <<		% for all n! pairs
    INDX1 := MYCAR (LEX1);
    LEX1 := MYCDR (LEX1);
    LEX := (INDEX := MAPCAR (INDEX1, 'EVAL)) . LEX
  >>;
  RETURN (LEX);
END;

% symgen1 generates a list of pointer pairs for sequential exchanges.
% there is no algorithm for this, it uses a hard-coded list stored
% in symgen*, hence the 4-indice limit.

SYMBOLIC PROCEDURE SYMGEN1 (EX);
BEGIN SCALAR N, LEX, A, B, C, D;
  N := LENGTH (EX);	% number of indices to be sym'ed
  IF N > 4 THEN
    MERROR ('("cannot symmetrize more than 4 indices"), 'TRUE, 'NIL);
  LEX := HEAD ('(A B C D), N);	% we take the head of symgen* and replace the
		% place-holder names with real pointers.
  RETURN (SUBLIS (PAIR (LEX, EX), (HEAD (SYMGEN!*, FACTORIAL (N) - 1))));
END;

% symmap is the routine which maps the given index to the symmetrization
% list. it returns a list of (nthelmnt index i, or symrol (i, ind))'s
% and a list of pointers.

SYMBOLIC PROCEDURE SYMMAP (LIS, INDEX);
BEGIN SCALAR INDEX1, LEX, I, LEX1;
  I := 1;
  INDEX1 := INDEX;
  WHILE INDEX DO <<	% run over thw whole index
    IF NOT MEMBER (MYCAR (INDEX), LIS) THEN   % direct copy from the index
         LEX := LIST ('NTH, 'INDEX, I) . LEX
	% symrol implements the permutation, see the code for it.
    ELSE LEX := LIST ('NTH, 'INDEX, LIST ('SYMROL, I, 'INDX1)) . LEX;
    INDEX := MYCDR (INDEX);
    I := I + 1
  >>;
  WHILE LIS DO << 	% this finds out what pointers to index each symm'ed
			% indice has.
    LEX1 := LOOK (INDEX1, MYCAR (LIS), 1) . LEX1;
    LIS := MYCDR (LIS)
  >>;
  RETURN (LIST (REVERSE (LEX1), REVERSE (LEX)));
END;

% symrol implements the permutaion operation. it returns a pointer to
% the nthelmnt call in the psuedo index written by symmap. the input
% consists of two things: a pointer to where this particular instance
% of symrol sits in the psuedo index, and a list of 2 pointers which
% are the ones which are being exchanged. if the pointer is not in this
% list, it is returned, and nthelmnt will copy this indice into the same
% position. if the pointer equals one of the two given, the other is returned,
% causing the pair to be exchanged.

SYMBOLIC PROCEDURE SYMROL (LOC, INDX1);
  IF LOC = MYCAR (INDX1) THEN MYCADR (INDX1)
  ELSE IF LOC = MYCADR (INDX1) THEN MYCAR (INDX1)
  ELSE LOC;


% symgen* stores the list of sequential pair exchanges to be used by
% symgen1. it must be true that a pair exchange will take one permutation
% into the next because we must know we can simply alternate signs if
% we are doing an anti-symmetrization operation. if one needs to be able
% to do more than 4 indices, this list can be extended and symgen1's
% error code fixed, but then we have at least 120 terms and its getting
% rediculously expensive to do things this way.

SYMGEN!* := '((A B) (B C) (A B) (B C) (A B) (B D) (A B) (B C) (A B)
              (B C) (A B) (B D) (A B) (B C) (A B) (B C) (A B) (A D)
              (A B) (B C) (A B) (B C) (A B));

% symshft determines whether we can proceed with the symmetrization operation
% without disturbing any pending shift operations.
 
SYMBOLIC PROCEDURE SYMSHFT (INDEX, SYMLST);
BEGIN;
  LOOP:
    IF NOT SYMLST THEN RETURN ('T)
    ELSE IF NOT MEMBER (MYCAR (SYMLST), INDEX) THEN RETURN ('NIL);
    SYMLST := MYCDR (SYMLST);
  GO TO LOOP;
END;

;END;
