%******************************************************************************
%  FILE = cmplx.red 				Sun May 17 20:07:37 EDT 1987
%  
%  Procedures in this file:
%  
%  PRINTCONJ SIMPCONJ CONJSQ CONJF CONJT CONJD SIMPREAL 
%  SIMPIMG SIMPCMOD SIMPRAT COMPLEX NOCOMPLEX CONJEXPT
% 
%  REDTEN source code
%  Copyright (c) 1986, 1987 University of Toronto.
%  All Rights Reserved.
%
%  Written by John Harper and Charles Dyer
%
%  Permission to use this software without fee is granted subject to 
%  the following restrictions:
% 
%  1. This software may not be used or distributed for direct commercial
%     gain.
% 
%  2. The author is not responsible for the consequences of use of this
%     software, no matter how awful, even if they arise from flaws in it.
% 
%  3. The origin of this software must not be misrepresented, either by
%     explicit claim or by omission.
% 
%  4. This code may be altered to suit your need, but such alterations
%     must be plainly marked and the code must not be misrepresented
%     as the original software.
% 
%  5. This notice may not be removed or altered.
% 
%**********************************************************************
REMPROP ('INDEX, 'STAT);

GLOBAL '(POSN!* YCOORD!* YMAX!*);

PUT ('CONJ, 'SPECPRN, 'PRINTCONJ);

% printconj is the routine which prints a conjugate form nicely. if the
% conjugation is applied to an atom, a bar is printed over the atom's
% name, otherwise it appears as an uneval'ed form.

SYMBOLIC PROCEDURE PRINTCONJ (U);
BEGIN INTEGER I, POSL;
  IF NOT !*NAT OR NOT ATOM (MYCAR (U)) THEN <<
    PRIN2!* ("conj (");		% operator
    MAPRINT (MYCAR (U), 0);	% operand
    PRIN2!* (")")
  >> ELSE <<
    POSL := POSN!*;
    YCOORD!* := YCOORD!* + 1;		% move up a line to make bar
    IF YCOORD!* > YMAX!* THEN YMAX!* := YCOORD!*;
    FOR I := FLATSIZE2 (MYCAR (U)) STEP -1 	% print _ for length of name
      UNTIL 1 DO PRIN2!*("_");
    YCOORD!* := YCOORD!* - 1;
    POSN!* := POSL;
    MAPRINT (MYCAR (U), 0)	% print it
  >>;
END;

PUT ('CONJ, 'SIMPFN, 'SIMPCONJ);

% simpconj is the routine which applies the conjugation operator to an
% expression. to do a conjugate, the expression is searched for complex
% objects and 'i, these are then replaced by conjugate operations.
% since the conjugation cannot change the form of the expression, no
% reevaluation is required.

SYMBOLIC PROCEDURE SIMPCONJ (U);
  IF CHECKTYPE (MYCAR (U), 'CONJ) THEN SIMP!* (MYCADAR (U)) % conj (conj (x)) -> x
  ELSE CONJSQ (SIMP!* (MYCAR (U)));	% conjugate the standard quotient.

% conjsq applies the conjugation to the numerator and denominator of the
% standard quotient.

SYMBOLIC PROCEDURE CONJSQ (U);
  CONJF (NUMR (U)) . CONJF (DENR (U));

FLUID '(FLAG);	% flag 't says 'i appears in this form, negate it.

% conjf conjugates standard forms. if a form contains i, it is negated
% to form the conjugate.

SYMBOLIC PROCEDURE CONJF (U);
BEGIN SCALAR LEX, FLAG;
  IF ATOM (U) THEN RETURN (U);
  LEX := CONJT (MYCAR (U));	% conjugate terms
  IF FLAG THEN LEX := MYCAR (MULTD (-1, !*T2F (LEX)));
  RETURN (LEX . CONJF (MYCDR (U)))
END;

% conjt conjugates terms, it applies conjd to domain elements.

SYMBOLIC PROCEDURE CONJT (U);
  IF ATOM (U) THEN U	% end of recursion
  ELSE IF MYCDR (U) THEN CONJD (MYCAR (U)) . CONJF (MYCDR (U))
  ELSE CONJD (MYCAR (U)) . LIST (CONJT (MYCADR (U)));

% conjd conjugates domain elements. if the main variable is 'i, the
% flag is set so that conjf can negate the term. if the main variable is
% a name flagged 'complex, it is replaced by an unevaled function call to
% conj: (conj <main variable>). if the main variable begins with 'conj,
% it is replaced by the operand. atom that are not flagged 'complex are
% not touched. if the main variable is not an atom, then if the car of
% the main variable has a 'conjfn property, the function named is applied,
% otherwise nothing happens.

SYMBOLIC PROCEDURE CONJD (U);
BEGIN SCALAR MAINVAR, PWER, LEX;
  MAINVAR := MYCAR (U);		% main variable
  PWER := MYCDR (U);		% integer power
  IF MAINVAR EQ 'I THEN FLAG := 'T
  ELSE IF ATOM (MAINVAR) AND FLAGP (MAINVAR, 'COMPLEX) THEN 
    MAINVAR := CAR (FKERN (LIST ('CONJ, MAINVAR)))
  ELSE IF ATOM (MAINVAR) THEN 'T   % dont want to change anything, just avoid ifs
  ELSE IF MYCAR (MAINVAR) EQ 'CONJ THEN MAINVAR := MYCADR (MAINVAR)
  ELSE IF (LEX := GET (MYCAR (MAINVAR), 'CONJFN)) THEN 
    MAINVAR := APPLY (LEX, LIST (MAINVAR))
  ELSE <<				% function 
    IF MAPCAR (FOR EACH X IN MYCDR (MAINVAR) COLLECT LIST (X), 'SIMPCONJ) = 
       MAPCAR (MYCDR (MAINVAR), 'SIMP!*) THEN 'T
    ELSE MAINVAR := CAR (FKERN (LIST ('CONJ, MAINVAR)))
  >>;
  RETURN (MAINVAR . PWER);		% put it back together and return
END;

PUT ('RE, 'SIMPFN, 'SIMPREAL);

% simpreal computes the real part of an expression.

SYMBOLIC PROCEDURE SIMPREAL (U);
  SIMP (LIST ('QUOTIENT, LIST ('PLUS, MYCAR (U), 
       LIST ('CONJ, MYCAR (U))), 2));

PUT ('IM, 'SIMPFN, 'SIMPIMG);

% simpimg computes the imaginary part of an expression.

SYMBOLIC PROCEDURE SIMPIMG (U);
  SIMP (LIST ('QUOTIENT, LIST ('PLUS, MYCAR (U), 
       LIST ('MINUS, LIST ('CONJ, MYCAR (U)))), '(TIMES I 2)));

PUT ('CMOD, 'SIMPFN, 'SIMPCMOD);

% simpcmod computes the modulus of an expression.

SYMBOLIC PROCEDURE SIMPCMOD (U);
  SIMP (LIST ('SQRT, LIST ('TIMES, MYCAR (U), LIST ('CONJ, MYCAR (U)))));

PUT ('RAT, 'SIMPFN, 'SIMPRAT);

% simprat rationalizes an expression. it will not work if names flagged
% 'complex occur in the expression, since the conjugates cancel out again.

SYMBOLIC PROCEDURE SIMPRAT (U);
BEGIN SCALAR LEX, LEX1;
  U := SIMP (MYCAR (U));
  IF ATOM (LEX1 := DENR (U)) THEN RETURN (U);
  LEX := CONJF (LEX1);	% conjugate of denominator.
  RETURN (QUOTSQ (SUBS2 !*F2Q (MULTF (NUMR (U), LEX)), 
      SUBS2 !*F2Q (MULTF (LEX1, LEX))));
END;

% complex declares each member of the given list to be 'complex.

SYMBOLIC PROCEDURE COMPLEX U;
<<
  FLAG (U, 'COMPLEX);
  U
>>;

% nocomplex removes the 'complex declaration from each memeber of the given
% list.

SYMBOLIC PROCEDURE NOCOMPLEX U;
<<
  REMFLAG (U, 'COMPLEX);
  U
>>;

RLISTAT '(COMPLEX NOCOMPLEX);	% parse with no evaluation

PUT ('EXPT, 'CONJFN, 'CONJEXPT);

% conjexpt handles the conjugation of powers where the power is not an
% integer.

SYMBOLIC PROCEDURE CONJEXPT (U);
  IF NOT FLAGP (MYCADR (U), 'COMPLEX) THEN
     LIST ('EXPT, MYCADR (U), REVAL (LIST ('CONJ, (MK!*SQ (SIMP (MYCADDR (U)))))))
  ELSE IF FLAGP (MYCADR (U), 'COMPLEX) AND NOT FLAGP (MYCADDR (U), 'COMPLEX) THEN
     LIST ('EXPT, LIST ('CONJ, MYCADR (U)), MYCADDR (U))
  ELSE U;

;END;

  
