/*******************************************************************
 *  FILE: GARB.C                           Wed Mar  2 16:38:07 EST 1988
 * 
 *  Functions in this file:
 * 
 *  main abort
 * 
 *  muTENSOR source code
 *  Copyright (c) 1986, 1987 University of Toronto.
 *  All Rights Reserved.
 *
 *  Written by John Harper and Charles Dyer
 *
 *  Permission to use this software without fee is granted subject to 
 *  the following restrictions:
 * 
 *  1. This software may not be used or distributed for direct commercial
 *     gain.
 * 
 *  2. The author is not responsible for the consequences of use of this
 *     software, no matter how awful, even if they arise from flaws in it.
 * 
 *  3. The origin of this software must not be misrepresented, either by
 *     explicit claim or by omission.
 * 
 *  4. This code may be altered to suit your need, but such alterations
 *     must be plainly marked and the code must not be misrepresented
 *     as the original software.
 * 
 *  5. This notice may not be removed or altered.
 * 
 **********************************************************************/

#include <stdio.h>
#ifndef CI86
#include <io.h>
#endif
#define BUFSIZE 512			/* buffer to read and write with */

FILE *fpp, *fpo, *fpi;

main ()
{
    long ftell();
    long stblock, size, len, olen;
    char garbfile[50];
    char buf[BUFSIZE];

    if ((fpp = fopen ("ptr.mem", "r")) == NULL)
      {
	  fprintf (stderr, "cannot open block pointer file ptr.mem\n");
	  exit (1);
      }
    (void) fscanf (fpp, "%s", garbfile);

    if ((fpi = fopen (garbfile, "rb")) == NULL)
      {
	  fprintf (stderr, "cannot open offload file %s\n", garbfile);
	  exit (1);
      }
    /*
     * Note that with the MSC compiler one cannot open the file for append
     * ('a') since MSC (wrongly) forces the write pointer to the end of the
     * file regardless of any fseek's.
     */

    if ((fpo = fopen (garbfile, "r+b")) == NULL)
      {
	  fprintf (stderr, "cannot open offload file %s\n", garbfile);
	  exit (1);
      }
    (void) fseek (fpi, 0L, 2);
    olen = ftell (fpi);			/* tacky way get file length */
    
    (void) fseek (fpo, 0L, 0);
 
    while (1)
      {
	  if (fscanf (fpp, "%ld %ld", &stblock, &size) == EOF)
	    {
		fprintf (stderr, "end of file in ptr.mem\n");
		break;
	    }
	  if (stblock == -1) break;
	  if (fseek (fpi, (long) stblock, 0) == -1)
	    {
		fprintf (stderr, "cannot seek, aborting\n");
		abort ();
	    }
	  while (size > BUFSIZE)
	    {
		if (fread (buf, 1, BUFSIZE, fpi) == 0)
		  {
		      fprintf (stderr, "Early EOF, aborting\n");
		      abort ();
		  }
		if (fwrite (buf, 1, BUFSIZE, fpo) == 0)
		  {
		      fprintf (stderr, "Write error, aborting\n");
		      abort ();
		  }
		size -= BUFSIZE;
	    }
	  if (size == 0) continue;
	  if (fread (buf, 1, (int) size, fpi) == 0)
	    {
		fprintf (stderr, "Early EOF, aborting\n");
		abort ();
	    }
	  if (fwrite (buf, 1, (int) size, fpo) == 0)
	    {
		fprintf (stderr, "Write error, aborting\n");
		abort ();
	    }
      }
    len = ftell (fpo);
    fclose (fpp);
    fclose (fpi);
    unlink ("ptr.mem");
#ifdef CI86
    trunc (garbfile, len);
#else
    chsize (fileno (fpo), (long) len);		/* truncate the file */
#endif
    fprintf (stderr, "%s reduced from %ld to %ld bytes.\n",
	     garbfile, olen, len);
    fclose (fpo);
}

abort ()
{
    fclose (fpp);
    fclose (fpo);
    fclose (fpi);
    unlink ("ptr.mem");
    exit (1);
}


#ifdef CI86

struct fcb {
  unsigned char drive;
  char filenme[8];
  char ext[3];
  unsigned int curblock;
  unsigned int recsize;
  unsigned long filesize;
  int date;
  int time;
  char reserved[8];
  unsigned char currec;
  unsigned long relrec;
};

/*
 * This function truncates the vm file by setting the file-length. The disk
 * seems to only be updated if a write is done to the file as well, so we
 * write a '( to the top of the file.
 */

trunc (file, len)
char *file;
long len;
{
    char *makefcb();
    struct fcb *fcb;
    char buf[2];
    buf[0] = 39;			/* put '( in buf */
    buf[1] = 40;
    fcb = (struct fcb *) makefcb (file);    /* make a new fcb for the garb file */
    bdos (0x0f, fcb);			/* open the vm file */
    fcb->recsize = 2;			/* set the record length to 2 chars */
    bdos (0x1a, buf);			/* set the DTA to be buf */
    bdos (0x22, fcb);			/* write buf to the top of the file */
    fcb->filesize = len;		/* set the new file length */
    bdos (0x10, fcb);			/* close the file */
    free ((char *) fcb);		/* free the fcb block */
}

#endif
