/*
** @(#)vr.h	1.2	(NCSA)	9/27/87
*/

#ifdef RASTER_MASTER

/*
** defines for raster states and variables
*/

/*
** states
*/

#define	DONE		0		/* we've been called */
#define	ESCFOUND	1		/* found escape */
#define	WANTCMD		2		/* want a command char */
#define	WANTDEL		3		/* want that first delimiter */
#define	IARG		4		/* looking for integer arg */
#define	SARG		5		/* looking for string arg */
#define	CARG		6		/* looking for count arg */
#define	DATA		7		/* all args parsed, found ^ */

/*
** commands
*/

#define ESC		0x1b			/* start of a sequence */
#define	ESCCMD	' '				/* escape to next level of commands */
#define	DELIM	';'				/* argument delimiter */
#define	CMDTRM	'^'				/* terminator, but also prefix w/ ESC */
#define	WINCMD	'W'				/* create a window */
#define	DESCMD	'D'				/* destroy a window */
#define	MAPCMD	'M'				/* change color map entries */
#define	RLECMD	'R'				/* run-length encoded data */
#define	PIXCMD	'P'				/* standard pixel data */
#define	FILCMD	'F'				/* save to file command */
#define	CLKCMD	'C'				/* click the slide camera */
#define	SAVCMD	'S'				/* save a color map to a file */

/*
** command parameter types
*/

#define	MAXARGS	7				/* maximum args to a command */
#define INT		1				/* integer argument */
#define	STRING	2				/* string (character) argument */
#define	COUNT	3				/* data count argument */
#define LINEMAX 1024			/* longest width for window */

/*
** virtual-level functions -- each one will call a similarly named
** function prefixed with RR, e.g VRwindow becomes RRwindow
*/

extern int VRwindow(), VRdestroy(), VRmap(), VRfile(), VRpixel();
extern int VRrle(), VRmsave(), VRclick();

/*
** flag values
*/

#define FL_NORMAL	1		/* command needs no data */
#define	FL_DATA		2		/* command takes data */

/*
** structure of command table
*/

struct cmd {
	char	c_name;
	int		c_flags;
	int		(*c_func)();
	int		c_args[MAXARGS];
};

struct cmd cmdtab[] = {
	WINCMD, FL_NORMAL, VRwindow, {INT, INT, INT, INT, INT, STRING, 0},
	DESCMD, FL_NORMAL, VRdestroy, {STRING, 0, 0, 0, 0, 0, 0},
	MAPCMD, FL_DATA, VRmap, {INT, INT, COUNT, STRING, 0, 0, 0},
	FILCMD, FL_NORMAL, VRfile, {INT, INT, INT, INT, INT, STRING, STRING},
	PIXCMD, FL_DATA, VRpixel, {INT, INT, COUNT, STRING, 0, 0, 0},
	RLECMD, FL_DATA, VRrle, {INT, INT, COUNT, STRING, 0, 0, 0},
	CLKCMD, FL_NORMAL, VRclick, {STRING, 0, 0, 0, 0, 0, 0},
	SAVCMD, FL_NORMAL, VRmsave, {STRING, STRING, 0, 0, 0, 0, 0}
};

#define NCMDS	(sizeof(cmdtab) / sizeof(struct cmd))

#endif RASTER_MASTER

/*
** everything after here is safe to be included by client
** ie, low-level routines
*/

/*
** saved arg values in parser
*/

union arg {
	int		a_num;			/* integer number */
	char	a_ptr[100];			/* string pointer */
};

typedef	struct VRwin VRW;
typedef	struct RRwin RRW;

/*
** format of a window entry
*/

struct VRwin {
	char	*w_name;			/* window's name, assigned on creation */
	int		w_left;				/* left edge */
	int		w_top;				/* top edge */
	int		w_width;			/* width */
	int		w_height;			/* height */
	int		w_display;			/* hardware display number of window */
	RRW		w_rr;				/* machine dep info for window */
	VRW		*w_next;			/* next pointer */
};

/*
** variables for linked list management
*/

#ifdef MASTERDEF
struct VRwin	VRhead;
#else
extern struct VRwin VRhead;
#endif
