.TH DES 1 
.SH NAME
des - encrypt or decrypt data using Data Encryption Standard
.SH SYNOPSIS
.B des
(
.B \-e
|
.B \-E
) | (
.B \-d
|
.B \-D
)
[
.B \-bfs
] [
.B \-k
.I key
]
] [
.B \-u[\fIuuname\fR]
[
.I input-file
[
.I output-file
] ]
.SH DESCRIPTION
.B des
encrypts and decrypts data using the
Data Encryption Standard algorithm.
One of
.B \-e, \-E
(for encrypt) or
.B \-d, \-D
(for decrypt) must be specified.
.LP
Two standard encryption modes are supported by the
.B des
program, Cipher Block Chaining (the default) and Electronic Code Book
(specified with
.B \-b
).
.LP
The key used for the
.B DES
algorithm is obtained by prompting the user unless the
.B `\-k
.I key'
option is given.
If the key is an argument to the
.B des
command, it is potentially visible to users executing
.BR ps (1)
or a derivative.  To minimise this possibility,
.B des
takes care to destroy the key argument immediately upon entry.
If your shell keeps a history file be careful to make sure it is not
world readable.
.LP
The
.B des
command reads from standard input unless
.I input-file
is specified and writes to standard output unless
.I output-file
is given.
.SH OPTIONS
.TP
.B \-b
Select ECB
(eight bytes at a time) encryption mode.
.TP
.B \-e
Encrypt data using an 8 byte key in a manner compatible with sunOS
des(1).
.TP
.B \-E
Encrypt data using a key of nearly unlimited length (1024 bytes).
This will product a more secure encryption.
.TP
.B \-d
Decrypt data that was encrypted with the \-e option.
.TP
.B \-D
Decrypt data that was encrypted with the \-E option.
.TP
.B \-f
Does nothing - allowed for compatibility with sunOS des(1) command.
.TP
.B \-s
Does nothing - allowed for compatibility with sunOS des(1) command.
.TP
.I "\-k key"
Use the encryption 
.I key
specified.
.TP
.B \-u
This flag is used to read and write uuencoded files.  If decrypting,
the input file is assumed to contain uuencoded, DES encrypted data.
If encrypting, the characters following the -u are used as the name of
the uuencoded file to embed in the begin line of the uuencoded
output.  If there is no name specified after the -u, the name text.des
will be embedded in the header.
.SH SEE ALSO
.B ps (1)
.B des_crypt(3)
.SH BUGS
.LP
The problem with using the
.B -e
option is the short key length.
It would be better to use a real 56-bit key rather than an
ASCII-based 56-bit pattern.  Knowing that the key was derived from ASCII
radically reduces the time necessary for a brute-force cryptographic attack.
My attempt to remove this problem is to add an alternative text-key to
DES-key function.  This alternative function (accessed via
.B -E
and
.B -D
)
used DES to help generate the key.
.LP
Be carefull when using the -u option.  Doing des -ud <filename> will
not decrypt filename (the -u option will gobble the d option).
.LP
The VMS operating system operates in a world where files are always a
multiple of 512 bytes.  This causes problems when encrypted data is
send from unix to VMS since a 88 byte file will suddenly be padded
with 424 null bytes.  To get around this problem, use the -u option
to uuencode the data before it is send to the VMS system.
.SH AUTHOR
.LP
Eric Young (eay@psych.psy.uq.oz.au), Psychology Department,
University of Queensland, Australia.
.SH RESTRICTIONS
.LP
This software was written in Australia and should be available
outside the USA.
