/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
import { ComponentChildren, Fragment, h, VNode } from "preact";
import { useSettings } from "../hooks/useSettings.js";
import { Settings } from "../platform/api.js";

export function EnabledBySettings<K extends keyof Settings>({
  children,
  value,
  name,
}: {
  name: K;
  value?: Settings[K];
  children: ComponentChildren;
}): VNode {
  const [settings] = useSettings();
  if (value === undefined) {
    if (!settings[name]) return <Fragment />;
    return <Fragment>{children}</Fragment>;
  }
  if (settings[name] !== value) {
    return <Fragment />;
  }
  return <Fragment>{children}</Fragment>;
}
