/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { Amounts, ScopeInfo, ScopeType, WalletBalance } from "@gnu-taler/taler-util";
import { Fragment, VNode, h } from "preact";
import {
  TableWithRoundRows
} from "./styled/index.js";

export function BalanceTable({
  balances,
  goToWalletHistory,
}: {
  balances: WalletBalance[];
  goToWalletHistory: (currency: ScopeInfo) => void;
}): VNode {
  return (
    <Fragment>
      <TableWithRoundRows>
        {balances.map((entry, idx) => {
          const av = Amounts.parseOrThrow(entry.available);

          return (
            <tr
              key={idx}
              onClick={() => goToWalletHistory(entry.scopeInfo)}
              style={{ cursor: "pointer" }}
            >
              <td>{av.currency}</td>
              <td
                style={{
                  fontSize: "2em",
                  textAlign: "right",
                  width: "100%",
                }}
              >
                {Amounts.stringifyValue(av, 2)}
                <div style={{ fontSize: "small", color: "grey" }}>
                  {entry.scopeInfo.type === ScopeType.Exchange ||
                    entry.scopeInfo.type === ScopeType.Auditor
                    ? entry.scopeInfo.url
                    : undefined}
                </div>
              </td>
            </tr>
          );
        })}
      </TableWithRoundRows>
    </Fragment>
  );
}
