/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_create_mfa_challenge.h
 * @brief implementation of the create_mfa_challenge function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_CREATE_MFA_CHALLENGE_H
#define PG_CREATE_MFA_CHALLENGE_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"


/**
 * Create new multi-factor authorization (MFA) challenge in the database.
 *
 * @param cls closure
 * @param op operation that triggered the MFA request
 * @param h_body hash of the request body
 * @param salt salt used to compute @a h_body
 * @param code challenge code sent to the user
 * @param expiration_date when should the challenge expire
 * @param retansmission_date when do we next allow retransmission
 *        of the challenge
 * @param tan_channel which channel was used
 * @param required_address address
 *        where the challenge is to be sent
 * @param[out] challenge_id set to the ID of the new challenge
 * @return database result code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_create_mfa_challenge (
  void *cls,
  enum TALER_MERCHANT_MFA_CriticalOperation op,
  const struct TALER_MERCHANT_MFA_BodyHash *h_body,
  const struct TALER_MERCHANT_MFA_BodySalt *salt,
  const char *code,
  struct GNUNET_TIME_Absolute expiration_date,
  struct GNUNET_TIME_Absolute retransmission_date,
  enum TALER_MERCHANT_MFA_Channel tan_channel,
  const char *required_address,
  uint64_t *challenge_id);

#endif
