// Copyright (C) 2005 Open Source Telecom Corp.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

namespace scdriver {
using namespace ost;
using namespace std;

static Keydata::Define driver[] = {
        {"device", "0"},
	{"stack", "0"},
	{"events", "8"},
	{"priority", "0"},
	{"level", "200"},
        {NULL, NULL}};

#ifdef	WIN32
#define	KEYS	"/bayonne/soundcard"
#else
#define	KEYS	"/bayonne/driver/soundcard"
#endif

Driver Driver::soundcard;

Driver::Driver() :
BayonneDriver(driver, KEYS, "soundcard", true)
{
	const char *cp;
#ifdef	WIN32
	const char *env = Process::getEnv("DRIVERCONFIG");

	if(env)
		loadFile(env, "soundcard");
#else
	load("~bayonne/soundcard");
#endif

	device = atoi(getLast("device"));
	active = Audio::hasDevice(device);
	keyboard = NULL;

	cp = getLast("level");
	if(cp)
		audio_level = atoi(cp);

	if(!active)
		slog.warn("soundcard/*: device %d unavailable", device);

	if(peer_encoding == Audio::unknownEncoding)
		peer_encoding = Audio::mulawAudio;

	if(!peer_framing)
		peer_framing = Audio::getFraming(peer_encoding, 10);

	seize_timer = 0;	// no seizure
}

void Driver::startDriver(void)
{
	keyboard = new Keyboard(this);
	msgport = new BayonneMsgport(this);

	timeslot = ts_used;
	new Session(0, device);
	count = ts_used - timeslot;

	msgport->start();
	keyboard->start();
	BayonneDriver::startDriver();
}

void Driver::stopDriver(void)
{
	if(keyboard)
	{
		delete keyboard;
		keyboard = NULL;
	}
	BayonneDriver::stopDriver();
}

}
