inherit "module";
inherit "roxenlib";
import Stdio;
#include <module.h>
#include <roxen.h>

constant cvs_version = "$Id: fwww.pike,v 1.7 1998/08/26 17:53:01 grubba Exp $";

array register_module()
{
#if !constant(HTTPAccept.prog)
  return 0;	// Disabled.
#else /* constant(HTTPAccept.prog) */
  return ({ MODULE_EXPERIMENTAL|MODULE_PROTOCOL,
	    "Fast HTTP port module (EXPERIMENTAL)",
	    "This module uses the Pike C-module HTTPAccept to facilitate "
	    "a rather fast HTTP protocol implementation. It also has an "
	    "in-memory cache to avoid calls to the Pike layer, and also "
	    "speed things up (no need for disk accesses).<br>\n"
	    "Performance:<br>\n"
	    "Over 6000 requests/second on a PII/333 running solaris 2.6.<br>\n"
	    "<br>\n"
	    "<font color=red size=+2>This module can right now not be "
	    "reloaded. Most variable changes take effect only upon server "
	    "restart.</font>"
  });
#endif /* constant(HTTPAccept.prog) */
}

#if constant(HTTPAccept.prog)

int log_method_is_commonlog()
{
  return query("log")!="Commonlog";
}

void create()
{
  defvar("port", 8080, "Port", TYPE_INT, "The port to bind to.");
  defvar("ip", "ANY", "IP", TYPE_STRING, "The IP to bind to.");

  defvar("timeout", 120, "Read timeout", 
	 TYPE_INT, "The read timeout used when parsing requests. "
	 "If the request has not been finished in this many seconds, "
	 "a timeout message will be sent to the client and the connection "
	 "will be closed.");

  defvar("ram_cache", 5, "Cache: Size", TYPE_INT,
	 "The size of the RAM cache in megabytes. Having a big RAM cache can "
	 "speed things up quite considerably.");

  defvar("cache_max_age", 30, "Cache: Max age", TYPE_INT,
	 "The maximum age of cached documents, in seconds.");

  defvar("cache_max_fsize", 50, "Cache: Max file size", TYPE_INT,
	 "The maximum size of files that will be cached (in KB). "
	 "Files bigger than this limit will not be cached in the RAM cache.");

  defvar("cache_max_psize", 100, "Cache: Max parsed file size", TYPE_INT,
	 "The maximum size of parsed files (RXML, pike scripts etc) that will "
	 "be cached.");

  defvar("log", "None", "Log", TYPE_STRING_LIST,
	 "Logging method. None is fastest, Commonlog is rather fast, Emulated "
	 "is rather slow, maximum is ~400 requests/second. Emulated emulates "
	 "the normal roxen logging method.<br>\n"
	 "<font color=red>Emulated is not finished yet.</font>",
	 ({ "None", "Commonlog", "Emulated" }));
 
  defvar("log_file", "../logs/fcl", "Log file", TYPE_FILE,
	 "Common log file name.", 0, log_method_is_commonlog);
}

class request_program 
{
  inherit HTTPAccept.prog : orig;
  inherit "roxenlib";
  static mapping _modified = ([]);
  constant version = roxen->version;
#include <variables.h>
  mapping misc = ([]);
  int _nono=0;
  mapping file;
  object conf;
//   string rawauth, realauth;
//   array (int|string) auth;
  mixed `->=(string a, mixed b)
  {
    switch(a)
    {
     case "file": return file = b;
     case "conf": return conf = b;
     case "misc": return misc = b;
     case "_nono": return _nono = b;
     default: return _modified[a] = b;
    }
  }

  mixed `[]=(string a, string b)
  {
    return `->=(a,b);
  }

  mixed `->(string a)
  {
    switch(a)
    {
     case "end": return lambda(){ destruct(); };
     case "file": return file;
     case "conf": return conf;
     case "misc": return misc;
     case "my_fd":
      return 0;
      object o = Stdio.File();
       o->_fd = orig::`->("my_fd");
       return o;
     case "_nono": return _nono;
     default: 
       if(_modified[a]) return _modified[a];
       if(!_nono) return orig::`->(a);
    }
  }

  mixed `[](string a)
  {
    return `->(a);
  }

  object clone_me()
  {
    object c,t;
    c=object_program(t=this_object())();
    c->_nono = 1;

    // c->first = first;
    c->extra_extension="";
    c->conf = this_object()->conf;
    c->time = this_object()->time;
    c->raw_url = this_object()->raw_url;
    c->variables = copy_value(this_object()->variables);
    c->misc = copy_value(misc);
    c->misc->orig = this_object();

    c->prestate = this_object()->prestate;
    c->supports = this_object()->supports;
    c->config = this_object()->config;

    c->remoteaddr = this_object()->remoteaddr;
    c->host = this_object()->host;

    c->client = this_object()->client;
    c->referer = this_object()->referer;
    c->pragma = this_object()->pragma;

    c->cookies = this_object()->cookies;
    c->my_fd = 0;
    c->prot = this_object()->prot;
    c->clientprot = this_object()->clientprot;
    c->method = this_object()->method;
  
    // realfile virtfile   // Should not be copied.  
    c->rest_query = this_object()->rest_query;
    c->raw = this_object()->raw;
    c->query = this_object()->query;
    c->not_query = this_object()->not_query;
    c->data = this_object()->data;
  
    c->auth = this_object()->auth;
    c->realauth = this_object()->realauth;
    c->rawauth = this_object()->rawauth;
#if 0
    c->since = this_object()->since;
#endif
    return c;
  }


  void internal_error(array err)
  {
    file = ([
      "type":"text/plain",
      "data":describe_backtrace(err),
    ]);
  }

  // Send the result.
  void send_result(mapping|void result)
  {
    array err;
    int tmp;
    mapping heads;
    string head_string;
    object thiso = this_object();

    if (result) {
      file = result;
    }

    if(!mappingp(file))
    {
      if(misc->error_code)
	file = http_low_answer(misc->error_code, errors[misc->error]);
      else if(this_object()->method != "GET" && 
	      this_object()->method != "HEAD" && 
	      this_object()->method != "POST")
	file = http_low_answer(501, "Not implemented.");
      else if(err = catch {
	file=http_low_answer(404,
			     replace(parse_rxml(conf->query("ZNoSuchFile"),
						thiso),
				     ({"$File", "$Me"}), 
				     ({this_object()->not_query,
				       conf->query("MyWorldLocation")})));
      }) {
	internal_error(err);
      }
    } else {
      if((file->file == -1) || file->leave_me) 
      {
	if(_modified->do_not_disconnect) {
	  file = 0;
	  return;
	}
// 	destruct(this_object());
	return;
      }
      if(!file->type)     file->type="text/plain";
    }
  
    if(!file->raw)
    {
      string h;
      heads=
      (["MIME-Version":(file["mime-version"] || "1.0"),
	"Content-type":file["type"],
	"Server":replace(version(), " ", ""),
// 	"Date":http_date(this_object()->time)
      ]);    

      if(file->encoding)
	heads["Content-Encoding"] = file->encoding;
    
      if(!file->error) 
	file->error=200;
    
      if(file->expires)
	heads->Expires = http_date(file->expires);

      if(!file->len)
      {
	if(objectp(file->file))
	  if(!file->stat && !(file->stat=misc->stat))
	    file->stat = (int *)file->file->stat();
	array fstat;
	if(arrayp(fstat = file->stat))
	{
	  if(file->file && !file->len)
	    file->len = fstat[1];

	  heads["Last-Modified"] = http_date(fstat[3]);
#if 0
	  if(this_object()->since)
	  {
	    if(is_modified(this_object()->since, fstat[3], fstat[1]))
	    {
	      file->error = 304;
	      file->file = 0;
	      file->data="";
	      misc->cacheable=0;
	    }
	  }
#endif
	}
	if(stringp(file->data))
	  file->len += strlen(file->data);
      }

      if(mappingp(file->extra_heads)) {
	heads |= file->extra_heads;
      }

      if(mappingp(misc->moreheads)) {
	heads |= misc->moreheads;
      }
    
      array myheads = ({this_object()->prot+" "+
			(file->rettext||errors[file->error])});
      foreach(indices(heads), h)
	if(arrayp(heads[h]))
	  foreach(heads[h], tmp)
	    myheads += ({ `+(h,": ", tmp)});
	else
	  myheads +=  ({ `+(h, ": ", heads[h])});


      if(file->len > -1)
	myheads += ({"Content-length: " + file->len });
      myheads += ({ "Connection: Keep-Alive" });
      head_string = (myheads+({"",""}))*"\r\n";
    } else
      misc->cacheable=0;

    if(this_object()->method == "HEAD")
    {
      file->file = 0;
      file->data="";
      misc->cacheable=0;
    }

    if(misc->cacheable && file->data)
    {
      if(_modified->cmp < file->len/1024)
	misc->cacheable=0;
    } else if(_modified->cmf < file->len/1024)
      misc->cacheable=0;
    

    if(head_string && misc->cacheable)
    {
      string data=head_string + (file->data||"");
      if(file->file)
	data += file->file->read(0x7fffffff);
      reply_with_cache( data, misc->cacheable );
    } else {
//       werror("reply: '%s' %s<%d>\n",
// 	     head_string, (file->file?"file":"nofile"), file->len);
      if(file->file)
	reply( head_string, file->file, file->len );
      else
	reply( head_string+file->data );
    }
  }

  // Execute the request
  void handle_request( )
  {
    mixed *err;
    //  perror("Handle request, got conf.\n");

    function funp;
    object thiso=this_object();
    
    if(!file)
    {
      object oc = conf;
      foreach(conf->first_modules(), funp) 
      {
	if(file = funp( thiso )) break;
	if(conf != oc) {
	  handle_request();
	  return;
	}
      }    
      if(!file) err=catch(file = conf->get_file( thiso ));

      if(err) internal_error(err);

      if(!mappingp(file))
	foreach(conf->last_modules(), funp) if(file = funp(thiso)) break;
    }
    send_result();
  }
}

object conf;

mapping flatten_headers( mapping from )
{
  mapping res = ([]);
  foreach(indices(from), string f)
    res[f] = from[f]*", ";
  return res;
}

void setup_fake(object o)
{
  mapping vars = ([]);
  o->conf = conf;
  o->extra_extension = "";
  o->supports = roxen->find_supports( lower_case(o->client*" "), 0 );
  o->misc = flatten_headers(o->headers);

  o->cmf = query("cache_max_fsize");
  o->cmp = query("cache_max_psize");

  
//   werror("%O\n", o->variables);
  if(o->method == "POST" && strlen(o->data))
  {
    mapping variabels = ([]);
    switch((o->misc["content-type"]/";")[0])
    {
     default: // Normal form data, handled in the C part.
       break;
       
     case "multipart/form-data":
       object messg = MIME.Message(o->data, o->misc);
       mapping misc = o->misc;
       foreach(messg->body_parts, object part) 
       {
	 if(part->disp_params->filename) 
	 {
	   vars[part->disp_params->name]=part->getdata();
	   vars[part->disp_params->name+".filename"]=
	     part->disp_params->filename;
	   if(!misc->files)
	     misc->files = ({ part->disp_params->name });
	   else
	     misc->files += ({ part->disp_params->name });
	 } else {
	   vars[part->disp_params->name]=part->getdata();
	 }
       }
       break;
    }
    o->variables = vars|o->variables;
  }

  string contents;
  if(contents = o->misc->authorization)
  {
    string *y;
    o->rawauth = contents;
    y = contents / " ";
    if(sizeof(y) >= 2)
    {
      y[1] = MIME.decode_base64(y[1]);
      o->realauth=y[1];
      if(conf && conf->auth_module)
	y = conf->auth_module->auth( y, o );
      o->auth=y;
    }
  }

  if(contents = o->misc["proxy-authorization"])
  {
    string *y;
    y = contents /= " ";
    if(sizeof(y) > 2)
    {
      y[1] = MIME.decode_base64(y[1]);
      o->realauth=y[1];
      if(conf && conf->auth_module)
	y = conf->auth_module->auth( y, o );
      o->proxyauth=y;
    }
  }

  if(contents = o->misc["accept-encoding"])
  {
    foreach((contents-" ")/",", string e) {
      if (lower_case(e) == "gzip") {
	o->supports["autogunzip"] = 1;
      }
    }
  }

  if(contents = o->misc["cookie"])
  {
    string c;
    mapping cookies = ([]);
    multiset config = (<>);
    o->misc->cookies = contents;
    foreach(((contents/";") - ({""})), c)
    {
      string name, value;
      while(sizeof(c) && c[0]==' ') c=c[1..];
      if(sscanf(c, "%s=%s", name, value) == 2)
      {
	value=http_decode_string(value);
	name=http_decode_string(name);
	cookies[ name ]=value;
	if(name == "RoxenConfig" && strlen(value))
	  config = aggregate_multiset(@(value/"," + ({ })));
      }
    }


    o->cookies = cookies;
    o->config = config;
  } else {
    o->cookies = ([]);
    o->config = (<>);
  }
  
  if(contents = o->misc->accept)
    o->misc->accept = ({ contents/"," });

  if(contents = o->misc["accept-charset"])
    o->misc["accept-charset"] = ({ contents/"," });

  if(contents = o->misc["accept-language"])
    o->misc["accept-language"] = ({ contents/"," });

  if(contents = o->misc["session-id"])
    o->misc["session-id"] = ({ contents/"," });

  //  o->misc->cookies = o->cookies;
  if(query("ram_cache"))
    o->misc->cacheable = query("cache_max_age");
}


void handle(object o)
{
  setup_fake( o ); // Equivalent to parse_got in http.pike
  roxen->handle( o->handle_request );
}

object port;
object l;

int cdel=10;
void do_log()
{
  if(l->logp())
  {
//     werror("log..\n");
    switch(query("log"))
    {
     case "None":
       l->log_as_array();
       break;
     case "Commonlog":
       object f = Stdio.File( query("log_file"), "wca" );
       l->log_as_commonlog_to_file( f );
       destruct(f);
       break;
    }
    cdel--;
    if(cdel < 1) cdel=1;
  } else {
    cdel++;
//     werror("nolog..\n");
  }
  call_out(do_log, cdel);
}

void low_adjust_stats(mapping m)
{
  //  werror("%O\n", m);
  conf->requests += m->num_request;
  conf->received += m->received_bytes;
  conf->sent += m->sent_bytes;
}

void adjust_stats()
{
  call_out(adjust_stats, 2);
  low_adjust_stats( l->cache_status() );
}

void start(int level, object config)
{
  if(config)
  {
    conf = config;
    if(port)
      return;

    port = Stdio.Port();
    if(query("ip") != "ANY")
    {
      if(!port->bind( query("port"), 0, query("ip")))
      {
	report_error("Failed to bind to port.\n");
	return;
      }
    } else if(!port->bind( query("port") )) {
      report_error("Failed to bind to port.\n");
      return;
    }
    int dolog = (query("log")!="None");
    l = HTTPAccept.Loop( port, request_program, handle, 0, 
			 query("ram_cache")*1024*1024, dolog,
			 query("timeout") );

    call_out(adjust_stats, 10);

    if(dolog)
    {
      remove_call_out(do_log);
      call_out(do_log, 5);
    }
  }
}

void stop()
{
  catch {
    destruct(l);
    destruct(port);
    remove_call_out(do_log);
  };
}


string status()
{
  mapping c = l->cache_status();
  c->total = c->hits + c->misses + c->stale;
#define PCT(X) ((int)(((X)/(float)(c->total+0.1))*100))
  return sprintf("<pre> %d elements in cache, size is %1.2fMB max is %dMB\n"
		 " %d cache lookups, %d%% hits, %d%% misses and %d%% stale."
		 "</pre>\n",
		 c->entries, c->size/(1024.0*1024), 
		 (int)(c->max_size/(1024*1024.0)),
		 c->total, PCT(c->hits), PCT(c->misses), PCT(c->stale));
  low_adjust_stats(c);
}

#endif /* constant(HTTPAccept.prog) */
